// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/essentialcontacts/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ESSENTIALCONTACTS_V1_ESSENTIAL_CONTACTS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ESSENTIALCONTACTS_V1_ESSENTIAL_CONTACTS_CLIENT_H

#include "google/cloud/essentialcontacts/v1/essential_contacts_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace essentialcontacts_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Manages contacts for important Google Cloud notifications.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class EssentialContactsServiceClient {
 public:
  explicit EssentialContactsServiceClient(
      std::shared_ptr<EssentialContactsServiceConnection> connection,
      Options opts = {});
  ~EssentialContactsServiceClient();

  ///@{
  /// @name Copy and move support
  EssentialContactsServiceClient(EssentialContactsServiceClient const&) =
      default;
  EssentialContactsServiceClient& operator=(
      EssentialContactsServiceClient const&) = default;
  EssentialContactsServiceClient(EssentialContactsServiceClient&&) = default;
  EssentialContactsServiceClient& operator=(EssentialContactsServiceClient&&) =
      default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(EssentialContactsServiceClient const& a,
                         EssentialContactsServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(EssentialContactsServiceClient const& a,
                         EssentialContactsServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Adds a new contact for a resource.
  ///
  /// @param parent  Required. The resource to save this contact for.
  ///  Format: organizations/{organization_id}, folders/{folder_id} or
  ///  projects/{project_id}
  /// @param contact  Required. The contact to create. Must specify an email address and language
  ///  tag.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.essentialcontacts.v1.Contact])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.essentialcontacts.v1.Contact]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L139}
  /// [google.cloud.essentialcontacts.v1.CreateContactRequest]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L242}
  ///
  // clang-format on
  StatusOr<google::cloud::essentialcontacts::v1::Contact> CreateContact(
      std::string const& parent,
      google::cloud::essentialcontacts::v1::Contact const& contact,
      Options opts = {});

  // clang-format off
  ///
  /// Adds a new contact for a resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.essentialcontacts.v1.CreateContactRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.essentialcontacts.v1.Contact])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.essentialcontacts.v1.Contact]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L139}
  /// [google.cloud.essentialcontacts.v1.CreateContactRequest]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L242}
  ///
  // clang-format on
  StatusOr<google::cloud::essentialcontacts::v1::Contact> CreateContact(
      google::cloud::essentialcontacts::v1::CreateContactRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a contact.
  /// Note: A contact's email address cannot be changed.
  ///
  /// @param contact  Required. The contact resource to replace the existing saved contact. Note:
  ///  the email address of the contact cannot be modified.
  /// @param update_mask  Optional. The update mask applied to the resource. For the `FieldMask`
  ///  definition, see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.essentialcontacts.v1.Contact])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.essentialcontacts.v1.Contact]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L139}
  /// [google.cloud.essentialcontacts.v1.UpdateContactRequest]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L259}
  ///
  // clang-format on
  StatusOr<google::cloud::essentialcontacts::v1::Contact> UpdateContact(
      google::cloud::essentialcontacts::v1::Contact const& contact,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a contact.
  /// Note: A contact's email address cannot be changed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.essentialcontacts.v1.UpdateContactRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.essentialcontacts.v1.Contact])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.essentialcontacts.v1.Contact]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L139}
  /// [google.cloud.essentialcontacts.v1.UpdateContactRequest]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L259}
  ///
  // clang-format on
  StatusOr<google::cloud::essentialcontacts::v1::Contact> UpdateContact(
      google::cloud::essentialcontacts::v1::UpdateContactRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the contacts that have been set on a resource.
  ///
  /// @param parent  Required. The parent resource name.
  ///  Format: organizations/{organization_id}, folders/{folder_id} or
  ///  projects/{project_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.essentialcontacts.v1.Contact], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.essentialcontacts.v1.Contact]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L139}
  /// [google.cloud.essentialcontacts.v1.ListContactsRequest]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L177}
  ///
  // clang-format on
  StreamRange<google::cloud::essentialcontacts::v1::Contact> ListContacts(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the contacts that have been set on a resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.essentialcontacts.v1.ListContactsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.essentialcontacts.v1.Contact], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.essentialcontacts.v1.Contact]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L139}
  /// [google.cloud.essentialcontacts.v1.ListContactsRequest]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L177}
  ///
  // clang-format on
  StreamRange<google::cloud::essentialcontacts::v1::Contact> ListContacts(
      google::cloud::essentialcontacts::v1::ListContactsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a single contact.
  ///
  /// @param name  Required. The name of the contact to retrieve.
  ///  Format: organizations/{organization_id}/contacts/{contact_id},
  ///  folders/{folder_id}/contacts/{contact_id} or
  ///  projects/{project_id}/contacts/{contact_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.essentialcontacts.v1.Contact])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.essentialcontacts.v1.Contact]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L139}
  /// [google.cloud.essentialcontacts.v1.GetContactRequest]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L214}
  ///
  // clang-format on
  StatusOr<google::cloud::essentialcontacts::v1::Contact> GetContact(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a single contact.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.essentialcontacts.v1.GetContactRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.essentialcontacts.v1.Contact])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.essentialcontacts.v1.Contact]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L139}
  /// [google.cloud.essentialcontacts.v1.GetContactRequest]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L214}
  ///
  // clang-format on
  StatusOr<google::cloud::essentialcontacts::v1::Contact> GetContact(
      google::cloud::essentialcontacts::v1::GetContactRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a contact.
  ///
  /// @param name  Required. The name of the contact to delete.
  ///  Format: organizations/{organization_id}/contacts/{contact_id},
  ///  folders/{folder_id}/contacts/{contact_id} or
  ///  projects/{project_id}/contacts/{contact_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.essentialcontacts.v1.DeleteContactRequest]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L228}
  ///
  // clang-format on
  Status DeleteContact(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a contact.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.essentialcontacts.v1.DeleteContactRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.essentialcontacts.v1.DeleteContactRequest]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L228}
  ///
  // clang-format on
  Status DeleteContact(
      google::cloud::essentialcontacts::v1::DeleteContactRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all contacts for the resource that are subscribed to the
  /// specified notification categories, including contacts inherited from
  /// any parent resources.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.essentialcontacts.v1.ComputeContactsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.essentialcontacts.v1.Contact], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.essentialcontacts.v1.ComputeContactsRequest]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L272}
  /// [google.cloud.essentialcontacts.v1.Contact]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L139}
  ///
  // clang-format on
  StreamRange<google::cloud::essentialcontacts::v1::Contact> ComputeContacts(
      google::cloud::essentialcontacts::v1::ComputeContactsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Allows a contact admin to send a test message to contact to verify that it
  /// has been configured correctly.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.essentialcontacts.v1.SendTestMessageRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.essentialcontacts.v1.SendTestMessageRequest]: @googleapis_reference_link{google/cloud/essentialcontacts/v1/service.proto#L316}
  ///
  // clang-format on
  Status SendTestMessage(
      google::cloud::essentialcontacts::v1::SendTestMessageRequest const&
          request,
      Options opts = {});

 private:
  std::shared_ptr<EssentialContactsServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace essentialcontacts_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ESSENTIALCONTACTS_V1_ESSENTIAL_CONTACTS_CLIENT_H
