// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/site_search_engine_service.proto

#include "google/cloud/discoveryengine/v1/site_search_engine_connection.h"
#include "google/cloud/discoveryengine/v1/internal/site_search_engine_connection_impl.h"
#include "google/cloud/discoveryengine/v1/internal/site_search_engine_option_defaults.h"
#include "google/cloud/discoveryengine/v1/internal/site_search_engine_stub_factory.h"
#include "google/cloud/discoveryengine/v1/internal/site_search_engine_tracing_connection.h"
#include "google/cloud/discoveryengine/v1/site_search_engine_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SiteSearchEngineServiceConnection::~SiteSearchEngineServiceConnection() =
    default;

StatusOr<google::cloud::discoveryengine::v1::SiteSearchEngine>
SiteSearchEngineServiceConnection::GetSiteSearchEngine(
    google::cloud::discoveryengine::v1::GetSiteSearchEngineRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
SiteSearchEngineServiceConnection::CreateTargetSite(
    google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::TargetSite>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceConnection::CreateTargetSite(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
SiteSearchEngineServiceConnection::CreateTargetSite(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::TargetSite>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesResponse>>
SiteSearchEngineServiceConnection::BatchCreateTargetSites(
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::discoveryengine::v1::BatchCreateTargetSitesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceConnection::BatchCreateTargetSites(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesResponse>>
SiteSearchEngineServiceConnection::BatchCreateTargetSites(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::discoveryengine::v1::BatchCreateTargetSitesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::discoveryengine::v1::TargetSite>
SiteSearchEngineServiceConnection::GetTargetSite(
    google::cloud::discoveryengine::v1::GetTargetSiteRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
SiteSearchEngineServiceConnection::UpdateTargetSite(
    google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::TargetSite>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceConnection::UpdateTargetSite(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
SiteSearchEngineServiceConnection::UpdateTargetSite(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::TargetSite>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>
SiteSearchEngineServiceConnection::DeleteTargetSite(
    google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceConnection::DeleteTargetSite(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>
SiteSearchEngineServiceConnection::DeleteTargetSite(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::discoveryengine::v1::TargetSite>
SiteSearchEngineServiceConnection::ListTargetSites(
    google::cloud::discoveryengine::v1::
        ListTargetSitesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::discoveryengine::v1::TargetSite>>();
}

future<StatusOr<
    google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchResponse>>
SiteSearchEngineServiceConnection::EnableAdvancedSiteSearch(
    google::cloud::discoveryengine::v1::
        EnableAdvancedSiteSearchRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceConnection::EnableAdvancedSiteSearch(
    NoAwaitTag, google::cloud::discoveryengine::v1::
                    EnableAdvancedSiteSearchRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchResponse>>
SiteSearchEngineServiceConnection::EnableAdvancedSiteSearch(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchResponse>>
SiteSearchEngineServiceConnection::DisableAdvancedSiteSearch(
    google::cloud::discoveryengine::v1::
        DisableAdvancedSiteSearchRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceConnection::DisableAdvancedSiteSearch(
    NoAwaitTag, google::cloud::discoveryengine::v1::
                    DisableAdvancedSiteSearchRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchResponse>>
SiteSearchEngineServiceConnection::DisableAdvancedSiteSearch(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::RecrawlUrisResponse>>
SiteSearchEngineServiceConnection::RecrawlUris(
    google::cloud::discoveryengine::v1::RecrawlUrisRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::RecrawlUrisResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceConnection::RecrawlUris(
    NoAwaitTag, google::cloud::discoveryengine::v1::RecrawlUrisRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::RecrawlUrisResponse>>
SiteSearchEngineServiceConnection::RecrawlUris(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::RecrawlUrisResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesResponse>>
SiteSearchEngineServiceConnection::BatchVerifyTargetSites(
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::discoveryengine::v1::BatchVerifyTargetSitesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceConnection::BatchVerifyTargetSites(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesResponse>>
SiteSearchEngineServiceConnection::BatchVerifyTargetSites(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::discoveryengine::v1::BatchVerifyTargetSitesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::discoveryengine::v1::TargetSite>
SiteSearchEngineServiceConnection::FetchDomainVerificationStatus(
    google::cloud::discoveryengine::v1::
        FetchDomainVerificationStatusRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::discoveryengine::v1::TargetSite>>();
}

std::shared_ptr<SiteSearchEngineServiceConnection>
MakeSiteSearchEngineServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 SiteSearchEngineServicePolicyOptionList>(
      options, __func__);
  options = discoveryengine_v1_internal::SiteSearchEngineServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub =
      discoveryengine_v1_internal::CreateDefaultSiteSearchEngineServiceStub(
          std::move(auth), options);
  return discoveryengine_v1_internal::
      MakeSiteSearchEngineServiceTracingConnection(
          std::make_shared<discoveryengine_v1_internal::
                               SiteSearchEngineServiceConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
