// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/site_search_engine_service.proto

#include "google/cloud/discoveryengine/v1/internal/site_search_engine_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SiteSearchEngineServiceTracingConnection::
    SiteSearchEngineServiceTracingConnection(
        std::shared_ptr<discoveryengine_v1::SiteSearchEngineServiceConnection>
            child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::discoveryengine::v1::SiteSearchEngine>
SiteSearchEngineServiceTracingConnection::GetSiteSearchEngine(
    google::cloud::discoveryengine::v1::GetSiteSearchEngineRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "GetSiteSearchEngine");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSiteSearchEngine(request));
}

future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
SiteSearchEngineServiceTracingConnection::CreateTargetSite(
    google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "CreateTargetSite");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateTargetSite(request));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingConnection::CreateTargetSite(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::CreateTargetSiteRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "CreateTargetSite");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateTargetSite(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
SiteSearchEngineServiceTracingConnection::CreateTargetSite(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "CreateTargetSite");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateTargetSite(operation));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesResponse>>
SiteSearchEngineServiceTracingConnection::BatchCreateTargetSites(
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "BatchCreateTargetSites");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchCreateTargetSites(request));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingConnection::BatchCreateTargetSites(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "BatchCreateTargetSites");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->BatchCreateTargetSites(NoAwaitTag{}, request));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::BatchCreateTargetSitesResponse>>
SiteSearchEngineServiceTracingConnection::BatchCreateTargetSites(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "BatchCreateTargetSites");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchCreateTargetSites(operation));
}

StatusOr<google::cloud::discoveryengine::v1::TargetSite>
SiteSearchEngineServiceTracingConnection::GetTargetSite(
    google::cloud::discoveryengine::v1::GetTargetSiteRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::GetTargetSite");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTargetSite(request));
}

future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
SiteSearchEngineServiceTracingConnection::UpdateTargetSite(
    google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "UpdateTargetSite");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateTargetSite(request));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingConnection::UpdateTargetSite(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::UpdateTargetSiteRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "UpdateTargetSite");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateTargetSite(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::discoveryengine::v1::TargetSite>>
SiteSearchEngineServiceTracingConnection::UpdateTargetSite(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "UpdateTargetSite");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateTargetSite(operation));
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>
SiteSearchEngineServiceTracingConnection::DeleteTargetSite(
    google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "DeleteTargetSite");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteTargetSite(request));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingConnection::DeleteTargetSite(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::DeleteTargetSiteRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "DeleteTargetSite");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteTargetSite(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteTargetSiteMetadata>>
SiteSearchEngineServiceTracingConnection::DeleteTargetSite(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "DeleteTargetSite");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteTargetSite(operation));
}

StreamRange<google::cloud::discoveryengine::v1::TargetSite>
SiteSearchEngineServiceTracingConnection::ListTargetSites(
    google::cloud::discoveryengine::v1::ListTargetSitesRequest request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::ListTargetSites");
  internal::OTelScope scope(span);
  auto sr = child_->ListTargetSites(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::discoveryengine::v1::TargetSite>(std::move(span),
                                                      std::move(sr));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchResponse>>
SiteSearchEngineServiceTracingConnection::EnableAdvancedSiteSearch(
    google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "EnableAdvancedSiteSearch");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->EnableAdvancedSiteSearch(request));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingConnection::EnableAdvancedSiteSearch(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "EnableAdvancedSiteSearch");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->EnableAdvancedSiteSearch(NoAwaitTag{}, request));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::EnableAdvancedSiteSearchResponse>>
SiteSearchEngineServiceTracingConnection::EnableAdvancedSiteSearch(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "EnableAdvancedSiteSearch");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->EnableAdvancedSiteSearch(operation));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchResponse>>
SiteSearchEngineServiceTracingConnection::DisableAdvancedSiteSearch(
    google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "DisableAdvancedSiteSearch");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DisableAdvancedSiteSearch(request));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingConnection::DisableAdvancedSiteSearch(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "DisableAdvancedSiteSearch");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DisableAdvancedSiteSearch(NoAwaitTag{}, request));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::DisableAdvancedSiteSearchResponse>>
SiteSearchEngineServiceTracingConnection::DisableAdvancedSiteSearch(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "DisableAdvancedSiteSearch");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DisableAdvancedSiteSearch(operation));
}

future<StatusOr<google::cloud::discoveryengine::v1::RecrawlUrisResponse>>
SiteSearchEngineServiceTracingConnection::RecrawlUris(
    google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::RecrawlUris");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RecrawlUris(request));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingConnection::RecrawlUris(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::RecrawlUrisRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::RecrawlUris");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->RecrawlUris(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::discoveryengine::v1::RecrawlUrisResponse>>
SiteSearchEngineServiceTracingConnection::RecrawlUris(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::RecrawlUris");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RecrawlUris(operation));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesResponse>>
SiteSearchEngineServiceTracingConnection::BatchVerifyTargetSites(
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "BatchVerifyTargetSites");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchVerifyTargetSites(request));
}

StatusOr<google::longrunning::Operation>
SiteSearchEngineServiceTracingConnection::BatchVerifyTargetSites(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "BatchVerifyTargetSites");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->BatchVerifyTargetSites(NoAwaitTag{}, request));
}

future<StatusOr<
    google::cloud::discoveryengine::v1::BatchVerifyTargetSitesResponse>>
SiteSearchEngineServiceTracingConnection::BatchVerifyTargetSites(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "BatchVerifyTargetSites");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchVerifyTargetSites(operation));
}

StreamRange<google::cloud::discoveryengine::v1::TargetSite>
SiteSearchEngineServiceTracingConnection::FetchDomainVerificationStatus(
    google::cloud::discoveryengine::v1::FetchDomainVerificationStatusRequest
        request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::SiteSearchEngineServiceConnection::"
      "FetchDomainVerificationStatus");
  internal::OTelScope scope(span);
  auto sr = child_->FetchDomainVerificationStatus(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::discoveryengine::v1::TargetSite>(std::move(span),
                                                      std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<discoveryengine_v1::SiteSearchEngineServiceConnection>
MakeSiteSearchEngineServiceTracingConnection(
    std::shared_ptr<discoveryengine_v1::SiteSearchEngineServiceConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<SiteSearchEngineServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google
