// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/data_store_service.proto

#include "google/cloud/discoveryengine/v1/internal/data_store_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DataStoreServiceTracingConnection::DataStoreServiceTracingConnection(
    std::shared_ptr<discoveryengine_v1::DataStoreServiceConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::discoveryengine::v1::DataStore>>
DataStoreServiceTracingConnection::CreateDataStore(
    google::cloud::discoveryengine::v1::CreateDataStoreRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DataStoreServiceConnection::CreateDataStore");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateDataStore(request));
}

StatusOr<google::longrunning::Operation>
DataStoreServiceTracingConnection::CreateDataStore(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::CreateDataStoreRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DataStoreServiceConnection::CreateDataStore");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateDataStore(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::discoveryengine::v1::DataStore>>
DataStoreServiceTracingConnection::CreateDataStore(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DataStoreServiceConnection::CreateDataStore");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateDataStore(operation));
}

StatusOr<google::cloud::discoveryengine::v1::DataStore>
DataStoreServiceTracingConnection::GetDataStore(
    google::cloud::discoveryengine::v1::GetDataStoreRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DataStoreServiceConnection::GetDataStore");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDataStore(request));
}

StreamRange<google::cloud::discoveryengine::v1::DataStore>
DataStoreServiceTracingConnection::ListDataStores(
    google::cloud::discoveryengine::v1::ListDataStoresRequest request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DataStoreServiceConnection::ListDataStores");
  internal::OTelScope scope(span);
  auto sr = child_->ListDataStores(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::discoveryengine::v1::DataStore>(std::move(span),
                                                     std::move(sr));
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteDataStoreMetadata>>
DataStoreServiceTracingConnection::DeleteDataStore(
    google::cloud::discoveryengine::v1::DeleteDataStoreRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DataStoreServiceConnection::DeleteDataStore");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteDataStore(request));
}

StatusOr<google::longrunning::Operation>
DataStoreServiceTracingConnection::DeleteDataStore(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::DeleteDataStoreRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DataStoreServiceConnection::DeleteDataStore");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteDataStore(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteDataStoreMetadata>>
DataStoreServiceTracingConnection::DeleteDataStore(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DataStoreServiceConnection::DeleteDataStore");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteDataStore(operation));
}

StatusOr<google::cloud::discoveryengine::v1::DataStore>
DataStoreServiceTracingConnection::UpdateDataStore(
    google::cloud::discoveryengine::v1::UpdateDataStoreRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DataStoreServiceConnection::UpdateDataStore");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateDataStore(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<discoveryengine_v1::DataStoreServiceConnection>
MakeDataStoreServiceTracingConnection(
    std::shared_ptr<discoveryengine_v1::DataStoreServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<DataStoreServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google
