// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/data_store_service.proto

#include "google/cloud/discoveryengine/v1/data_store_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataStoreServiceClient::DataStoreServiceClient(
    std::shared_ptr<DataStoreServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DataStoreServiceClient::~DataStoreServiceClient() = default;

future<StatusOr<google::cloud::discoveryengine::v1::DataStore>>
DataStoreServiceClient::CreateDataStore(
    std::string const& parent,
    google::cloud::discoveryengine::v1::DataStore const& data_store,
    std::string const& data_store_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::CreateDataStoreRequest request;
  request.set_parent(parent);
  *request.mutable_data_store() = data_store;
  request.set_data_store_id(data_store_id);
  return connection_->CreateDataStore(request);
}

StatusOr<google::longrunning::Operation>
DataStoreServiceClient::CreateDataStore(
    NoAwaitTag, std::string const& parent,
    google::cloud::discoveryengine::v1::DataStore const& data_store,
    std::string const& data_store_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::CreateDataStoreRequest request;
  request.set_parent(parent);
  *request.mutable_data_store() = data_store;
  request.set_data_store_id(data_store_id);
  return connection_->CreateDataStore(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::discoveryengine::v1::DataStore>>
DataStoreServiceClient::CreateDataStore(
    google::cloud::discoveryengine::v1::CreateDataStoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataStore(request);
}

StatusOr<google::longrunning::Operation>
DataStoreServiceClient::CreateDataStore(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::CreateDataStoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataStore(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::discoveryengine::v1::DataStore>>
DataStoreServiceClient::CreateDataStore(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataStore(operation);
}

StatusOr<google::cloud::discoveryengine::v1::DataStore>
DataStoreServiceClient::GetDataStore(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::GetDataStoreRequest request;
  request.set_name(name);
  return connection_->GetDataStore(request);
}

StatusOr<google::cloud::discoveryengine::v1::DataStore>
DataStoreServiceClient::GetDataStore(
    google::cloud::discoveryengine::v1::GetDataStoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDataStore(request);
}

StreamRange<google::cloud::discoveryengine::v1::DataStore>
DataStoreServiceClient::ListDataStores(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::ListDataStoresRequest request;
  request.set_parent(parent);
  return connection_->ListDataStores(request);
}

StreamRange<google::cloud::discoveryengine::v1::DataStore>
DataStoreServiceClient::ListDataStores(
    google::cloud::discoveryengine::v1::ListDataStoresRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDataStores(std::move(request));
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteDataStoreMetadata>>
DataStoreServiceClient::DeleteDataStore(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::DeleteDataStoreRequest request;
  request.set_name(name);
  return connection_->DeleteDataStore(request);
}

StatusOr<google::longrunning::Operation>
DataStoreServiceClient::DeleteDataStore(NoAwaitTag, std::string const& name,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::DeleteDataStoreRequest request;
  request.set_name(name);
  return connection_->DeleteDataStore(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteDataStoreMetadata>>
DataStoreServiceClient::DeleteDataStore(
    google::cloud::discoveryengine::v1::DeleteDataStoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataStore(request);
}

StatusOr<google::longrunning::Operation>
DataStoreServiceClient::DeleteDataStore(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::DeleteDataStoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataStore(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteDataStoreMetadata>>
DataStoreServiceClient::DeleteDataStore(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataStore(operation);
}

StatusOr<google::cloud::discoveryengine::v1::DataStore>
DataStoreServiceClient::UpdateDataStore(
    google::cloud::discoveryengine::v1::DataStore const& data_store,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::discoveryengine::v1::UpdateDataStoreRequest request;
  *request.mutable_data_store() = data_store;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDataStore(request);
}

StatusOr<google::cloud::discoveryengine::v1::DataStore>
DataStoreServiceClient::UpdateDataStore(
    google::cloud::discoveryengine::v1::UpdateDataStoreRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataStore(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
