// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/intent.proto

#include "google/cloud/dialogflow_es/internal/intents_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dialogflow/v2/intent.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IntentsMetadata::IntentsMetadata(
    std::shared_ptr<IntentsStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::dialogflow::v2::ListIntentsResponse>
IntentsMetadata::ListIntents(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::v2::ListIntentsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListIntents(context, options, request);
}

StatusOr<google::cloud::dialogflow::v2::Intent> IntentsMetadata::GetIntent(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::v2::GetIntentRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetIntent(context, options, request);
}

StatusOr<google::cloud::dialogflow::v2::Intent> IntentsMetadata::CreateIntent(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::v2::CreateIntentRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateIntent(context, options, request);
}

StatusOr<google::cloud::dialogflow::v2::Intent> IntentsMetadata::UpdateIntent(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::v2::UpdateIntentRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("intent.name=",
                           internal::UrlEncode(request.intent().name())));
  return child_->UpdateIntent(context, options, request);
}

Status IntentsMetadata::DeleteIntent(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::v2::DeleteIntentRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteIntent(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
IntentsMetadata::AsyncBatchUpdateIntents(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dialogflow::v2::BatchUpdateIntentsRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncBatchUpdateIntents(cq, std::move(context),
                                         std::move(options), request);
}

StatusOr<google::longrunning::Operation> IntentsMetadata::BatchUpdateIntents(
    grpc::ClientContext& context, Options options,
    google::cloud::dialogflow::v2::BatchUpdateIntentsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->BatchUpdateIntents(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
IntentsMetadata::AsyncBatchDeleteIntents(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dialogflow::v2::BatchDeleteIntentsRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncBatchDeleteIntents(cq, std::move(context),
                                         std::move(options), request);
}

StatusOr<google::longrunning::Operation> IntentsMetadata::BatchDeleteIntents(
    grpc::ClientContext& context, Options options,
    google::cloud::dialogflow::v2::BatchDeleteIntentsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->BatchDeleteIntents(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
IntentsMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> IntentsMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void IntentsMetadata::SetMetadata(grpc::ClientContext& context,
                                  Options const& options,
                                  std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void IntentsMetadata::SetMetadata(grpc::ClientContext& context,
                                  Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
