// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/flow.proto

#include "google/cloud/dialogflow_cx/internal/flows_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dialogflow/cx/v3/flow.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FlowsMetadata::FlowsMetadata(
    std::shared_ptr<FlowsStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::dialogflow::cx::v3::Flow> FlowsMetadata::CreateFlow(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::CreateFlowRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateFlow(context, options, request);
}

Status FlowsMetadata::DeleteFlow(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::DeleteFlowRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteFlow(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::ListFlowsResponse>
FlowsMetadata::ListFlows(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::ListFlowsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListFlows(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Flow> FlowsMetadata::GetFlow(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::GetFlowRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetFlow(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Flow> FlowsMetadata::UpdateFlow(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::UpdateFlowRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("flow.name=", internal::UrlEncode(request.flow().name())));
  return child_->UpdateFlow(context, options, request);
}

future<StatusOr<google::longrunning::Operation>> FlowsMetadata::AsyncTrainFlow(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dialogflow::cx::v3::TrainFlowRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncTrainFlow(cq, std::move(context), std::move(options),
                                request);
}

StatusOr<google::longrunning::Operation> FlowsMetadata::TrainFlow(
    grpc::ClientContext& context, Options options,
    google::cloud::dialogflow::cx::v3::TrainFlowRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->TrainFlow(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::FlowValidationResult>
FlowsMetadata::ValidateFlow(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::ValidateFlowRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ValidateFlow(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::FlowValidationResult>
FlowsMetadata::GetFlowValidationResult(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::GetFlowValidationResultRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetFlowValidationResult(context, options, request);
}

future<StatusOr<google::longrunning::Operation>> FlowsMetadata::AsyncImportFlow(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dialogflow::cx::v3::ImportFlowRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncImportFlow(cq, std::move(context), std::move(options),
                                 request);
}

StatusOr<google::longrunning::Operation> FlowsMetadata::ImportFlow(
    grpc::ClientContext& context, Options options,
    google::cloud::dialogflow::cx::v3::ImportFlowRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ImportFlow(context, options, request);
}

future<StatusOr<google::longrunning::Operation>> FlowsMetadata::AsyncExportFlow(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dialogflow::cx::v3::ExportFlowRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncExportFlow(cq, std::move(context), std::move(options),
                                 request);
}

StatusOr<google::longrunning::Operation> FlowsMetadata::ExportFlow(
    grpc::ClientContext& context, Options options,
    google::cloud::dialogflow::cx::v3::ExportFlowRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ExportFlow(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
FlowsMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> FlowsMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void FlowsMetadata::SetMetadata(grpc::ClientContext& context,
                                Options const& options,
                                std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void FlowsMetadata::SetMetadata(grpc::ClientContext& context,
                                Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
