// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: grafeas/v1/grafeas.proto

#include "google/cloud/containeranalysis/v1/grafeas_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace containeranalysis_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

GrafeasConnectionIdempotencyPolicy::~GrafeasConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<GrafeasConnectionIdempotencyPolicy>
GrafeasConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<GrafeasConnectionIdempotencyPolicy>(*this);
}

Idempotency GrafeasConnectionIdempotencyPolicy::GetOccurrence(
    grafeas::v1::GetOccurrenceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GrafeasConnectionIdempotencyPolicy::ListOccurrences(
    grafeas::v1::ListOccurrencesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency GrafeasConnectionIdempotencyPolicy::DeleteOccurrence(
    grafeas::v1::DeleteOccurrenceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GrafeasConnectionIdempotencyPolicy::CreateOccurrence(
    grafeas::v1::CreateOccurrenceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GrafeasConnectionIdempotencyPolicy::BatchCreateOccurrences(
    grafeas::v1::BatchCreateOccurrencesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GrafeasConnectionIdempotencyPolicy::UpdateOccurrence(
    grafeas::v1::UpdateOccurrenceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GrafeasConnectionIdempotencyPolicy::GetOccurrenceNote(
    grafeas::v1::GetOccurrenceNoteRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GrafeasConnectionIdempotencyPolicy::GetNote(
    grafeas::v1::GetNoteRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GrafeasConnectionIdempotencyPolicy::ListNotes(
    grafeas::v1::ListNotesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency GrafeasConnectionIdempotencyPolicy::DeleteNote(
    grafeas::v1::DeleteNoteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GrafeasConnectionIdempotencyPolicy::CreateNote(
    grafeas::v1::CreateNoteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GrafeasConnectionIdempotencyPolicy::BatchCreateNotes(
    grafeas::v1::BatchCreateNotesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GrafeasConnectionIdempotencyPolicy::UpdateNote(
    grafeas::v1::UpdateNoteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GrafeasConnectionIdempotencyPolicy::ListNoteOccurrences(
    grafeas::v1::ListNoteOccurrencesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<GrafeasConnectionIdempotencyPolicy>
MakeDefaultGrafeasConnectionIdempotencyPolicy() {
  return std::make_unique<GrafeasConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace containeranalysis_v1
}  // namespace cloud
}  // namespace google
