// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/target_ssl_proxies/v1/target_ssl_proxies.proto

#include "google/cloud/compute/target_ssl_proxies/v1/internal/target_ssl_proxies_rest_metadata_decorator.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/rest_set_metadata.h"
#include "google/cloud/status_or.h"
#include "absl/strings/str_format.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_target_ssl_proxies_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TargetSslProxiesRestMetadata::TargetSslProxiesRestMetadata(
    std::shared_ptr<TargetSslProxiesRestStub> child,
    std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetSslProxiesRestMetadata::AsyncDeleteTargetSslProxy(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        DeleteTargetSslProxyRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncDeleteTargetSslProxy(cq, std::move(rest_context),
                                           std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetSslProxiesRestMetadata::DeleteTargetSslProxy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        DeleteTargetSslProxyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->DeleteTargetSslProxy(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::TargetSslProxy>
TargetSslProxiesRestMetadata::GetTargetSslProxy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        GetTargetSslProxyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetTargetSslProxy(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetSslProxiesRestMetadata::AsyncInsertTargetSslProxy(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        InsertTargetSslProxyRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncInsertTargetSslProxy(cq, std::move(rest_context),
                                           std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetSslProxiesRestMetadata::InsertTargetSslProxy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        InsertTargetSslProxyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->InsertTargetSslProxy(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::TargetSslProxyList>
TargetSslProxiesRestMetadata::ListTargetSslProxies(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        ListTargetSslProxiesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListTargetSslProxies(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetSslProxiesRestMetadata::AsyncSetBackendService(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        SetBackendServiceRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncSetBackendService(cq, std::move(rest_context),
                                        std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetSslProxiesRestMetadata::SetBackendService(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        SetBackendServiceRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetBackendService(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetSslProxiesRestMetadata::AsyncSetCertificateMap(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        SetCertificateMapRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncSetCertificateMap(cq, std::move(rest_context),
                                        std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetSslProxiesRestMetadata::SetCertificateMap(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        SetCertificateMapRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetCertificateMap(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetSslProxiesRestMetadata::AsyncSetProxyHeader(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        SetProxyHeaderRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncSetProxyHeader(cq, std::move(rest_context),
                                     std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetSslProxiesRestMetadata::SetProxyHeader(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        SetProxyHeaderRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetProxyHeader(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetSslProxiesRestMetadata::AsyncSetSslCertificates(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        SetSslCertificatesRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncSetSslCertificates(cq, std::move(rest_context),
                                         std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetSslProxiesRestMetadata::SetSslCertificates(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        SetSslCertificatesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetSslCertificates(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetSslProxiesRestMetadata::AsyncSetSslPolicy(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        SetSslPolicyRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncSetSslPolicy(cq, std::move(rest_context),
                                   std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
TargetSslProxiesRestMetadata::SetSslPolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::target_ssl_proxies::v1::
        SetSslPolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetSslPolicy(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetSslProxiesRestMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::global_operations::v1::
        GetOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncGetOperation(cq, std::move(rest_context),
                                   std::move(options), request);
}

future<Status> TargetSslProxiesRestMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::global_operations::v1::
        DeleteOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCancelOperation(cq, std::move(rest_context),
                                      std::move(options), request);
}

void TargetSslProxiesRestMetadata::SetMetadata(
    rest_internal::RestContext& rest_context, Options const& options,
    std::vector<std::string> const& params) {
  google::cloud::rest_internal::SetMetadata(rest_context, options, params,
                                            api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_target_ssl_proxies_v1_internal
}  // namespace cloud
}  // namespace google
