// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/ssl_policies/v1/ssl_policies.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SSL_POLICIES_V1_SSL_POLICIES_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SSL_POLICIES_V1_SSL_POLICIES_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/ssl_policies/v1/ssl_policies.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_ssl_policies_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SslPoliciesConnectionIdempotencyPolicy {
 public:
  virtual ~SslPoliciesConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<SslPoliciesConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency AggregatedListSslPolicies(
      google::cloud::cpp::compute::ssl_policies::v1::
          AggregatedListSslPoliciesRequest request);

  virtual google::cloud::Idempotency DeleteSslPolicy(
      google::cloud::cpp::compute::ssl_policies::v1::
          DeleteSslPolicyRequest const& request);

  virtual google::cloud::Idempotency GetSslPolicy(
      google::cloud::cpp::compute::ssl_policies::v1::GetSslPolicyRequest const&
          request);

  virtual google::cloud::Idempotency InsertSslPolicy(
      google::cloud::cpp::compute::ssl_policies::v1::
          InsertSslPolicyRequest const& request);

  virtual google::cloud::Idempotency ListSslPolicies(
      google::cloud::cpp::compute::ssl_policies::v1::ListSslPoliciesRequest
          request);

  virtual google::cloud::Idempotency ListAvailableFeatures(
      google::cloud::cpp::compute::ssl_policies::v1::
          ListAvailableFeaturesRequest const& request);

  virtual google::cloud::Idempotency PatchSslPolicy(
      google::cloud::cpp::compute::ssl_policies::v1::
          PatchSslPolicyRequest const& request);
};

std::unique_ptr<SslPoliciesConnectionIdempotencyPolicy>
MakeDefaultSslPoliciesConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_ssl_policies_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SSL_POLICIES_V1_SSL_POLICIES_CONNECTION_IDEMPOTENCY_POLICY_H
