// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/projects/v1/projects.proto

#include "google/cloud/compute/projects/v1/projects_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_projects_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ProjectsConnectionIdempotencyPolicy::~ProjectsConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<ProjectsConnectionIdempotencyPolicy>
ProjectsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ProjectsConnectionIdempotencyPolicy>(*this);
}

Idempotency ProjectsConnectionIdempotencyPolicy::DisableXpnHost(
    google::cloud::cpp::compute::projects::v1::DisableXpnHostRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProjectsConnectionIdempotencyPolicy::DisableXpnResource(
    google::cloud::cpp::compute::projects::v1::
        DisableXpnResourceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProjectsConnectionIdempotencyPolicy::EnableXpnHost(
    google::cloud::cpp::compute::projects::v1::EnableXpnHostRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProjectsConnectionIdempotencyPolicy::EnableXpnResource(
    google::cloud::cpp::compute::projects::v1::
        EnableXpnResourceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProjectsConnectionIdempotencyPolicy::GetProject(
    google::cloud::cpp::compute::projects::v1::GetProjectRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ProjectsConnectionIdempotencyPolicy::GetXpnHost(
    google::cloud::cpp::compute::projects::v1::GetXpnHostRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ProjectsConnectionIdempotencyPolicy::GetXpnResources(
    google::cloud::cpp::compute::projects::v1::GetXpnResourcesRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ProjectsConnectionIdempotencyPolicy::ListXpnHosts(
    google::cloud::cpp::compute::projects::v1::ListXpnHostsRequest) {  // NOLINT
  return Idempotency::kNonIdempotent;
}

Idempotency ProjectsConnectionIdempotencyPolicy::MoveDisk(
    google::cloud::cpp::compute::projects::v1::MoveDiskRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProjectsConnectionIdempotencyPolicy::MoveInstance(
    google::cloud::cpp::compute::projects::v1::MoveInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProjectsConnectionIdempotencyPolicy::SetCloudArmorTier(
    google::cloud::cpp::compute::projects::v1::
        SetCloudArmorTierRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProjectsConnectionIdempotencyPolicy::SetCommonInstanceMetadata(
    google::cloud::cpp::compute::projects::v1::
        SetCommonInstanceMetadataRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProjectsConnectionIdempotencyPolicy::SetDefaultNetworkTier(
    google::cloud::cpp::compute::projects::v1::
        SetDefaultNetworkTierRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProjectsConnectionIdempotencyPolicy::SetUsageExportBucket(
    google::cloud::cpp::compute::projects::v1::
        SetUsageExportBucketRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<ProjectsConnectionIdempotencyPolicy>
MakeDefaultProjectsConnectionIdempotencyPolicy() {
  return std::make_unique<ProjectsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_projects_v1
}  // namespace cloud
}  // namespace google
