// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/networks/v1/networks.proto

#include "google/cloud/compute/networks/v1/internal/networks_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_networks_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

NetworksTracingConnection::NetworksTracingConnection(
    std::shared_ptr<compute_networks_v1::NetworksConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksTracingConnection::AddPeering(
    google::cloud::cpp::compute::networks::v1::AddPeeringRequest const&
        request) {
  auto span =
      internal::MakeSpan("compute_networks_v1::NetworksConnection::AddPeering");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AddPeering(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NetworksTracingConnection::AddPeering(
    NoAwaitTag,
    google::cloud::cpp::compute::networks::v1::AddPeeringRequest const&
        request) {
  auto span =
      internal::MakeSpan("compute_networks_v1::NetworksConnection::AddPeering");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->AddPeering(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksTracingConnection::AddPeering(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span =
      internal::MakeSpan("compute_networks_v1::NetworksConnection::AddPeering");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AddPeering(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksTracingConnection::DeleteNetwork(
    google::cloud::cpp::compute::networks::v1::DeleteNetworkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::DeleteNetwork");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteNetwork(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NetworksTracingConnection::DeleteNetwork(
    NoAwaitTag,
    google::cloud::cpp::compute::networks::v1::DeleteNetworkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::DeleteNetwork");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteNetwork(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksTracingConnection::DeleteNetwork(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::DeleteNetwork");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteNetwork(operation));
}

StatusOr<google::cloud::cpp::compute::v1::Network>
NetworksTracingConnection::GetNetwork(
    google::cloud::cpp::compute::networks::v1::GetNetworkRequest const&
        request) {
  auto span =
      internal::MakeSpan("compute_networks_v1::NetworksConnection::GetNetwork");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNetwork(request));
}

StatusOr<google::cloud::cpp::compute::v1::NetworksGetEffectiveFirewallsResponse>
NetworksTracingConnection::GetEffectiveFirewalls(
    google::cloud::cpp::compute::networks::v1::
        GetEffectiveFirewallsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::GetEffectiveFirewalls");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEffectiveFirewalls(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksTracingConnection::InsertNetwork(
    google::cloud::cpp::compute::networks::v1::InsertNetworkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::InsertNetwork");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InsertNetwork(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NetworksTracingConnection::InsertNetwork(
    NoAwaitTag,
    google::cloud::cpp::compute::networks::v1::InsertNetworkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::InsertNetwork");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->InsertNetwork(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksTracingConnection::InsertNetwork(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::InsertNetwork");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InsertNetwork(operation));
}

StreamRange<google::cloud::cpp::compute::v1::Network>
NetworksTracingConnection::ListNetworks(
    google::cloud::cpp::compute::networks::v1::ListNetworksRequest request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::ListNetworks");
  internal::OTelScope scope(span);
  auto sr = child_->ListNetworks(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::Network>(std::move(span), std::move(sr));
}

StreamRange<google::cloud::cpp::compute::v1::ExchangedPeeringRoute>
NetworksTracingConnection::ListPeeringRoutes(
    google::cloud::cpp::compute::networks::v1::ListPeeringRoutesRequest
        request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::ListPeeringRoutes");
  internal::OTelScope scope(span);
  auto sr = child_->ListPeeringRoutes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::ExchangedPeeringRoute>(std::move(span),
                                                              std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksTracingConnection::PatchNetwork(
    google::cloud::cpp::compute::networks::v1::PatchNetworkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::PatchNetwork");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PatchNetwork(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NetworksTracingConnection::PatchNetwork(
    NoAwaitTag,
    google::cloud::cpp::compute::networks::v1::PatchNetworkRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::PatchNetwork");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->PatchNetwork(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksTracingConnection::PatchNetwork(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::PatchNetwork");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PatchNetwork(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksTracingConnection::RemovePeering(
    google::cloud::cpp::compute::networks::v1::RemovePeeringRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::RemovePeering");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RemovePeering(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NetworksTracingConnection::RemovePeering(
    NoAwaitTag,
    google::cloud::cpp::compute::networks::v1::RemovePeeringRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::RemovePeering");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->RemovePeering(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksTracingConnection::RemovePeering(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::RemovePeering");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RemovePeering(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksTracingConnection::SwitchToCustomMode(
    google::cloud::cpp::compute::networks::v1::SwitchToCustomModeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::SwitchToCustomMode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->SwitchToCustomMode(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NetworksTracingConnection::SwitchToCustomMode(
    NoAwaitTag,
    google::cloud::cpp::compute::networks::v1::SwitchToCustomModeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::SwitchToCustomMode");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->SwitchToCustomMode(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksTracingConnection::SwitchToCustomMode(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::SwitchToCustomMode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->SwitchToCustomMode(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksTracingConnection::UpdatePeering(
    google::cloud::cpp::compute::networks::v1::UpdatePeeringRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::UpdatePeering");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdatePeering(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NetworksTracingConnection::UpdatePeering(
    NoAwaitTag,
    google::cloud::cpp::compute::networks::v1::UpdatePeeringRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::UpdatePeering");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdatePeering(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworksTracingConnection::UpdatePeering(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_networks_v1::NetworksConnection::UpdatePeering");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdatePeering(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_networks_v1::NetworksConnection>
MakeNetworksTracingConnection(
    std::shared_ptr<compute_networks_v1::NetworksConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<NetworksTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_networks_v1_internal
}  // namespace cloud
}  // namespace google
