// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/backend_services/v1/backend_services.proto

#include "google/cloud/compute/backend_services/v1/backend_services_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_backend_services_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BackendServicesClient::BackendServicesClient(
    std::shared_ptr<BackendServicesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
BackendServicesClient::~BackendServicesClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::AddSignedUrlKey(
    std::string const& project, std::string const& backend_service,
    google::cloud::cpp::compute::v1::SignedUrlKey const&
        signed_url_key_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::AddSignedUrlKeyRequest
      request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  *request.mutable_signed_url_key_resource() = signed_url_key_resource;
  return connection_->AddSignedUrlKey(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::AddSignedUrlKey(
    NoAwaitTag, std::string const& project, std::string const& backend_service,
    google::cloud::cpp::compute::v1::SignedUrlKey const&
        signed_url_key_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::AddSignedUrlKeyRequest
      request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  *request.mutable_signed_url_key_resource() = signed_url_key_resource;
  return connection_->AddSignedUrlKey(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::AddSignedUrlKey(
    google::cloud::cpp::compute::backend_services::v1::
        AddSignedUrlKeyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddSignedUrlKey(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::AddSignedUrlKey(
    NoAwaitTag,
    google::cloud::cpp::compute::backend_services::v1::
        AddSignedUrlKeyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddSignedUrlKey(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::AddSignedUrlKey(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddSignedUrlKey(operation);
}

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::BackendServicesScopedList>>
BackendServicesClient::AggregatedListBackendServices(std::string const& project,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::
      AggregatedListBackendServicesRequest request;
  request.set_project(project);
  return connection_->AggregatedListBackendServices(request);
}

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::BackendServicesScopedList>>
BackendServicesClient::AggregatedListBackendServices(
    google::cloud::cpp::compute::backend_services::v1::
        AggregatedListBackendServicesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListBackendServices(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::DeleteBackendService(std::string const& project,
                                            std::string const& backend_service,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::DeleteBackendServiceRequest
      request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  return connection_->DeleteBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::DeleteBackendService(NoAwaitTag,
                                            std::string const& project,
                                            std::string const& backend_service,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::DeleteBackendServiceRequest
      request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  return connection_->DeleteBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::DeleteBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        DeleteBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::DeleteBackendService(
    NoAwaitTag,
    google::cloud::cpp::compute::backend_services::v1::
        DeleteBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::DeleteBackendService(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBackendService(operation);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::DeleteSignedUrlKey(std::string const& project,
                                          std::string const& backend_service,
                                          std::string const& key_name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::DeleteSignedUrlKeyRequest
      request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  request.set_key_name(key_name);
  return connection_->DeleteSignedUrlKey(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::DeleteSignedUrlKey(NoAwaitTag,
                                          std::string const& project,
                                          std::string const& backend_service,
                                          std::string const& key_name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::DeleteSignedUrlKeyRequest
      request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  request.set_key_name(key_name);
  return connection_->DeleteSignedUrlKey(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::DeleteSignedUrlKey(
    google::cloud::cpp::compute::backend_services::v1::
        DeleteSignedUrlKeyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSignedUrlKey(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::DeleteSignedUrlKey(
    NoAwaitTag,
    google::cloud::cpp::compute::backend_services::v1::
        DeleteSignedUrlKeyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSignedUrlKey(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::DeleteSignedUrlKey(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSignedUrlKey(operation);
}

StatusOr<google::cloud::cpp::compute::v1::BackendService>
BackendServicesClient::GetBackendService(std::string const& project,
                                         std::string const& backend_service,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::GetBackendServiceRequest
      request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  return connection_->GetBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::BackendService>
BackendServicesClient::GetBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        GetBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::BackendServiceGroupHealth>
BackendServicesClient::GetHealth(
    std::string const& project, std::string const& backend_service,
    google::cloud::cpp::compute::v1::ResourceGroupReference const&
        resource_group_reference_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::GetHealthRequest request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  *request.mutable_resource_group_reference_resource() =
      resource_group_reference_resource;
  return connection_->GetHealth(request);
}

StatusOr<google::cloud::cpp::compute::v1::BackendServiceGroupHealth>
BackendServicesClient::GetHealth(
    google::cloud::cpp::compute::backend_services::v1::GetHealthRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetHealth(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
BackendServicesClient::GetIamPolicy(std::string const& project,
                                    std::string const& resource, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::GetIamPolicyRequest
      request;
  request.set_project(project);
  request.set_resource(resource);
  return connection_->GetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
BackendServicesClient::GetIamPolicy(
    google::cloud::cpp::compute::backend_services::v1::
        GetIamPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::InsertBackendService(
    std::string const& project,
    google::cloud::cpp::compute::v1::BackendService const&
        backend_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::InsertBackendServiceRequest
      request;
  request.set_project(project);
  *request.mutable_backend_service_resource() = backend_service_resource;
  return connection_->InsertBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::InsertBackendService(
    NoAwaitTag, std::string const& project,
    google::cloud::cpp::compute::v1::BackendService const&
        backend_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::InsertBackendServiceRequest
      request;
  request.set_project(project);
  *request.mutable_backend_service_resource() = backend_service_resource;
  return connection_->InsertBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::InsertBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        InsertBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::InsertBackendService(
    NoAwaitTag,
    google::cloud::cpp::compute::backend_services::v1::
        InsertBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::InsertBackendService(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertBackendService(operation);
}

StreamRange<google::cloud::cpp::compute::v1::BackendService>
BackendServicesClient::ListBackendServices(std::string const& project,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::ListBackendServicesRequest
      request;
  request.set_project(project);
  return connection_->ListBackendServices(request);
}

StreamRange<google::cloud::cpp::compute::v1::BackendService>
BackendServicesClient::ListBackendServices(
    google::cloud::cpp::compute::backend_services::v1::
        ListBackendServicesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListBackendServices(std::move(request));
}

StreamRange<google::cloud::cpp::compute::v1::BackendService>
BackendServicesClient::ListUsable(std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::ListUsableRequest request;
  request.set_project(project);
  return connection_->ListUsable(request);
}

StreamRange<google::cloud::cpp::compute::v1::BackendService>
BackendServicesClient::ListUsable(
    google::cloud::cpp::compute::backend_services::v1::ListUsableRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListUsable(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::PatchBackendService(
    std::string const& project, std::string const& backend_service,
    google::cloud::cpp::compute::v1::BackendService const&
        backend_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::PatchBackendServiceRequest
      request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  *request.mutable_backend_service_resource() = backend_service_resource;
  return connection_->PatchBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::PatchBackendService(
    NoAwaitTag, std::string const& project, std::string const& backend_service,
    google::cloud::cpp::compute::v1::BackendService const&
        backend_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::PatchBackendServiceRequest
      request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  *request.mutable_backend_service_resource() = backend_service_resource;
  return connection_->PatchBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::PatchBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        PatchBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::PatchBackendService(
    NoAwaitTag,
    google::cloud::cpp::compute::backend_services::v1::
        PatchBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::PatchBackendService(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchBackendService(operation);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::SetEdgeSecurityPolicy(
    std::string const& project, std::string const& backend_service,
    google::cloud::cpp::compute::v1::SecurityPolicyReference const&
        security_policy_reference_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::
      SetEdgeSecurityPolicyRequest request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  *request.mutable_security_policy_reference_resource() =
      security_policy_reference_resource;
  return connection_->SetEdgeSecurityPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::SetEdgeSecurityPolicy(
    NoAwaitTag, std::string const& project, std::string const& backend_service,
    google::cloud::cpp::compute::v1::SecurityPolicyReference const&
        security_policy_reference_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::
      SetEdgeSecurityPolicyRequest request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  *request.mutable_security_policy_reference_resource() =
      security_policy_reference_resource;
  return connection_->SetEdgeSecurityPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::SetEdgeSecurityPolicy(
    google::cloud::cpp::compute::backend_services::v1::
        SetEdgeSecurityPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetEdgeSecurityPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::SetEdgeSecurityPolicy(
    NoAwaitTag,
    google::cloud::cpp::compute::backend_services::v1::
        SetEdgeSecurityPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetEdgeSecurityPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::SetEdgeSecurityPolicy(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetEdgeSecurityPolicy(operation);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
BackendServicesClient::SetIamPolicy(
    std::string const& project, std::string const& resource,
    google::cloud::cpp::compute::v1::GlobalSetPolicyRequest const&
        global_set_policy_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::SetIamPolicyRequest
      request;
  request.set_project(project);
  request.set_resource(resource);
  *request.mutable_global_set_policy_request_resource() =
      global_set_policy_request_resource;
  return connection_->SetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
BackendServicesClient::SetIamPolicy(
    google::cloud::cpp::compute::backend_services::v1::
        SetIamPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::SetSecurityPolicy(
    std::string const& project, std::string const& backend_service,
    google::cloud::cpp::compute::v1::SecurityPolicyReference const&
        security_policy_reference_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::SetSecurityPolicyRequest
      request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  *request.mutable_security_policy_reference_resource() =
      security_policy_reference_resource;
  return connection_->SetSecurityPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::SetSecurityPolicy(
    NoAwaitTag, std::string const& project, std::string const& backend_service,
    google::cloud::cpp::compute::v1::SecurityPolicyReference const&
        security_policy_reference_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::SetSecurityPolicyRequest
      request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  *request.mutable_security_policy_reference_resource() =
      security_policy_reference_resource;
  return connection_->SetSecurityPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::SetSecurityPolicy(
    google::cloud::cpp::compute::backend_services::v1::
        SetSecurityPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetSecurityPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::SetSecurityPolicy(
    NoAwaitTag,
    google::cloud::cpp::compute::backend_services::v1::
        SetSecurityPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetSecurityPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::SetSecurityPolicy(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetSecurityPolicy(operation);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
BackendServicesClient::TestIamPermissions(
    std::string const& project, std::string const& resource,
    google::cloud::cpp::compute::v1::TestPermissionsRequest const&
        test_permissions_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::TestIamPermissionsRequest
      request;
  request.set_project(project);
  request.set_resource(resource);
  *request.mutable_test_permissions_request_resource() =
      test_permissions_request_resource;
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
BackendServicesClient::TestIamPermissions(
    google::cloud::cpp::compute::backend_services::v1::
        TestIamPermissionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::UpdateBackendService(
    std::string const& project, std::string const& backend_service,
    google::cloud::cpp::compute::v1::BackendService const&
        backend_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::UpdateBackendServiceRequest
      request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  *request.mutable_backend_service_resource() = backend_service_resource;
  return connection_->UpdateBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::UpdateBackendService(
    NoAwaitTag, std::string const& project, std::string const& backend_service,
    google::cloud::cpp::compute::v1::BackendService const&
        backend_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::backend_services::v1::UpdateBackendServiceRequest
      request;
  request.set_project(project);
  request.set_backend_service(backend_service);
  *request.mutable_backend_service_resource() = backend_service_resource;
  return connection_->UpdateBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::UpdateBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        UpdateBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
BackendServicesClient::UpdateBackendService(
    NoAwaitTag,
    google::cloud::cpp::compute::backend_services::v1::
        UpdateBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesClient::UpdateBackendService(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBackendService(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_backend_services_v1
}  // namespace cloud
}  // namespace google
