// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/core.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_INTERNAL_CLOUD_CONTROLS_PARTNER_CORE_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_INTERNAL_CLOUD_CONTROLS_PARTNER_CORE_STUB_H

#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/cloudcontrolspartner/v1/core.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class CloudControlsPartnerCoreStub {
 public:
  virtual ~CloudControlsPartnerCoreStub() = 0;

  virtual StatusOr<google::cloud::cloudcontrolspartner::v1::Workload>
  GetWorkload(grpc::ClientContext& context, Options const& options,
              google::cloud::cloudcontrolspartner::v1::GetWorkloadRequest const&
                  request) = 0;

  virtual StatusOr<
      google::cloud::cloudcontrolspartner::v1::ListWorkloadsResponse>
  ListWorkloads(
      grpc::ClientContext& context, Options const& options,
      google::cloud::cloudcontrolspartner::v1::ListWorkloadsRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::cloudcontrolspartner::v1::Customer>
  GetCustomer(grpc::ClientContext& context, Options const& options,
              google::cloud::cloudcontrolspartner::v1::GetCustomerRequest const&
                  request) = 0;

  virtual StatusOr<
      google::cloud::cloudcontrolspartner::v1::ListCustomersResponse>
  ListCustomers(
      grpc::ClientContext& context, Options const& options,
      google::cloud::cloudcontrolspartner::v1::ListCustomersRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::cloudcontrolspartner::v1::EkmConnections>
  GetEkmConnections(
      grpc::ClientContext& context, Options const& options,
      google::cloud::cloudcontrolspartner::v1::GetEkmConnectionsRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::cloudcontrolspartner::v1::PartnerPermissions>
  GetPartnerPermissions(grpc::ClientContext& context, Options const& options,
                        google::cloud::cloudcontrolspartner::v1::
                            GetPartnerPermissionsRequest const& request) = 0;

  virtual StatusOr<google::cloud::cloudcontrolspartner::v1::
                       ListAccessApprovalRequestsResponse>
  ListAccessApprovalRequests(
      grpc::ClientContext& context, Options const& options,
      google::cloud::cloudcontrolspartner::v1::
          ListAccessApprovalRequestsRequest const& request) = 0;

  virtual StatusOr<google::cloud::cloudcontrolspartner::v1::Partner> GetPartner(
      grpc::ClientContext& context, Options const& options,
      google::cloud::cloudcontrolspartner::v1::GetPartnerRequest const&
          request) = 0;
};

class DefaultCloudControlsPartnerCoreStub
    : public CloudControlsPartnerCoreStub {
 public:
  explicit DefaultCloudControlsPartnerCoreStub(
      std::unique_ptr<google::cloud::cloudcontrolspartner::v1::
                          CloudControlsPartnerCore::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::cloud::cloudcontrolspartner::v1::Workload> GetWorkload(
      grpc::ClientContext& context, Options const& options,
      google::cloud::cloudcontrolspartner::v1::GetWorkloadRequest const&
          request) override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::ListWorkloadsResponse>
  ListWorkloads(
      grpc::ClientContext& context, Options const& options,
      google::cloud::cloudcontrolspartner::v1::ListWorkloadsRequest const&
          request) override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::Customer> GetCustomer(
      grpc::ClientContext& context, Options const& options,
      google::cloud::cloudcontrolspartner::v1::GetCustomerRequest const&
          request) override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::ListCustomersResponse>
  ListCustomers(
      grpc::ClientContext& context, Options const& options,
      google::cloud::cloudcontrolspartner::v1::ListCustomersRequest const&
          request) override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::EkmConnections>
  GetEkmConnections(
      grpc::ClientContext& context, Options const& options,
      google::cloud::cloudcontrolspartner::v1::GetEkmConnectionsRequest const&
          request) override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::PartnerPermissions>
  GetPartnerPermissions(
      grpc::ClientContext& context, Options const& options,
      google::cloud::cloudcontrolspartner::v1::
          GetPartnerPermissionsRequest const& request) override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::
               ListAccessApprovalRequestsResponse>
  ListAccessApprovalRequests(
      grpc::ClientContext& context, Options const& options,
      google::cloud::cloudcontrolspartner::v1::
          ListAccessApprovalRequestsRequest const& request) override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::Partner> GetPartner(
      grpc::ClientContext& context, Options const& options,
      google::cloud::cloudcontrolspartner::v1::GetPartnerRequest const& request)
      override;

 private:
  std::unique_ptr<google::cloud::cloudcontrolspartner::v1::
                      CloudControlsPartnerCore::StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_INTERNAL_CLOUD_CONTROLS_PARTNER_CORE_STUB_H
