// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/row_access_policy.proto

#include "google/cloud/bigquerycontrol/v2/internal/row_access_policy_rest_connection_impl.h"
#include "google/cloud/bigquerycontrol/v2/internal/row_access_policy_rest_stub_factory.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/rest_retry_loop.h"
#include "google/cloud/rest_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RowAccessPolicyServiceRestConnectionImpl::
    RowAccessPolicyServiceRestConnectionImpl(
        std::unique_ptr<google::cloud::BackgroundThreads> background,
        std::shared_ptr<
            bigquerycontrol_v2_internal::RowAccessPolicyServiceRestStub>
            stub,
        Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), RowAccessPolicyServiceConnection::options())) {}

StreamRange<google::cloud::bigquery::v2::RowAccessPolicy>
RowAccessPolicyServiceRestConnectionImpl::ListRowAccessPolicies(
    google::cloud::bigquery::v2::ListRowAccessPoliciesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListRowAccessPolicies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::bigquery::v2::RowAccessPolicy>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           bigquerycontrol_v2::RowAccessPolicyServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::bigquery::v2::ListRowAccessPoliciesRequest const& r) {
        return google::cloud::rest_internal::RestRetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                rest_internal::RestContext& rest_context,
                Options const& options,
                google::cloud::bigquery::v2::ListRowAccessPoliciesRequest const&
                    request) {
              return stub->ListRowAccessPolicies(rest_context, options,
                                                 request);
            },
            options, r, function_name);
      },
      [](google::cloud::bigquery::v2::ListRowAccessPoliciesResponse r) {
        std::vector<google::cloud::bigquery::v2::RowAccessPolicy> result(
            r.row_access_policies().size());
        auto& messages = *r.mutable_row_access_policies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2_internal
}  // namespace cloud
}  // namespace google
