// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/dataset.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_DATASET_REST_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_DATASET_REST_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/internal/rest_client.h"
#include "google/cloud/internal/rest_context.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/bigquery/v2/dataset.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DatasetServiceRestStub {
 public:
  virtual ~DatasetServiceRestStub() = default;

  virtual StatusOr<google::cloud::bigquery::v2::Dataset> GetDataset(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::GetDatasetRequest const& request) = 0;

  virtual StatusOr<google::cloud::bigquery::v2::Dataset> InsertDataset(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::InsertDatasetRequest const& request) = 0;

  virtual StatusOr<google::cloud::bigquery::v2::Dataset> PatchDataset(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::UpdateOrPatchDatasetRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::bigquery::v2::Dataset> UpdateDataset(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::UpdateOrPatchDatasetRequest const&
          request) = 0;

  virtual Status DeleteDataset(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::DeleteDatasetRequest const& request) = 0;

  virtual StatusOr<google::cloud::bigquery::v2::DatasetList> ListDatasets(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::ListDatasetsRequest const& request) = 0;

  virtual StatusOr<google::cloud::bigquery::v2::Dataset> UndeleteDataset(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::UndeleteDatasetRequest const& request) = 0;
};

class DefaultDatasetServiceRestStub : public DatasetServiceRestStub {
 public:
  ~DefaultDatasetServiceRestStub() override = default;

  explicit DefaultDatasetServiceRestStub(Options options);
  DefaultDatasetServiceRestStub(
      std::shared_ptr<rest_internal::RestClient> service, Options options);

  StatusOr<google::cloud::bigquery::v2::Dataset> GetDataset(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::GetDatasetRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::Dataset> InsertDataset(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::InsertDatasetRequest const& request)
      override;

  StatusOr<google::cloud::bigquery::v2::Dataset> PatchDataset(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::UpdateOrPatchDatasetRequest const& request)
      override;

  StatusOr<google::cloud::bigquery::v2::Dataset> UpdateDataset(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::UpdateOrPatchDatasetRequest const& request)
      override;

  Status DeleteDataset(google::cloud::rest_internal::RestContext& rest_context,
                       Options const& options,
                       google::cloud::bigquery::v2::DeleteDatasetRequest const&
                           request) override;

  StatusOr<google::cloud::bigquery::v2::DatasetList> ListDatasets(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::ListDatasetsRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::Dataset> UndeleteDataset(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::UndeleteDatasetRequest const& request)
      override;

 private:
  std::shared_ptr<rest_internal::RestClient> service_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_DATASET_REST_STUB_H
