// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/batch/v1/batch.proto

#include "google/cloud/batch/v1/batch_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace batch_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BatchServiceClient::BatchServiceClient(
    std::shared_ptr<BatchServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
BatchServiceClient::~BatchServiceClient() = default;

StatusOr<google::cloud::batch::v1::Job> BatchServiceClient::CreateJob(
    std::string const& parent, google::cloud::batch::v1::Job const& job,
    std::string const& job_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::batch::v1::CreateJobRequest request;
  request.set_parent(parent);
  *request.mutable_job() = job;
  request.set_job_id(job_id);
  return connection_->CreateJob(request);
}

StatusOr<google::cloud::batch::v1::Job> BatchServiceClient::CreateJob(
    google::cloud::batch::v1::CreateJobRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateJob(request);
}

StatusOr<google::cloud::batch::v1::Job> BatchServiceClient::GetJob(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::batch::v1::GetJobRequest request;
  request.set_name(name);
  return connection_->GetJob(request);
}

StatusOr<google::cloud::batch::v1::Job> BatchServiceClient::GetJob(
    google::cloud::batch::v1::GetJobRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetJob(request);
}

future<StatusOr<google::cloud::batch::v1::OperationMetadata>>
BatchServiceClient::DeleteJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::batch::v1::DeleteJobRequest request;
  request.set_name(name);
  return connection_->DeleteJob(request);
}

StatusOr<google::longrunning::Operation> BatchServiceClient::DeleteJob(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::batch::v1::DeleteJobRequest request;
  request.set_name(name);
  return connection_->DeleteJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::batch::v1::OperationMetadata>>
BatchServiceClient::DeleteJob(
    google::cloud::batch::v1::DeleteJobRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteJob(request);
}

StatusOr<google::longrunning::Operation> BatchServiceClient::DeleteJob(
    NoAwaitTag, google::cloud::batch::v1::DeleteJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::batch::v1::OperationMetadata>>
BatchServiceClient::DeleteJob(google::longrunning::Operation const& operation,
                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteJob(operation);
}

StreamRange<google::cloud::batch::v1::Job> BatchServiceClient::ListJobs(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::batch::v1::ListJobsRequest request;
  request.set_parent(parent);
  return connection_->ListJobs(request);
}

StreamRange<google::cloud::batch::v1::Job> BatchServiceClient::ListJobs(
    google::cloud::batch::v1::ListJobsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListJobs(std::move(request));
}

StatusOr<google::cloud::batch::v1::Task> BatchServiceClient::GetTask(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::batch::v1::GetTaskRequest request;
  request.set_name(name);
  return connection_->GetTask(request);
}

StatusOr<google::cloud::batch::v1::Task> BatchServiceClient::GetTask(
    google::cloud::batch::v1::GetTaskRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTask(request);
}

StreamRange<google::cloud::batch::v1::Task> BatchServiceClient::ListTasks(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::batch::v1::ListTasksRequest request;
  request.set_parent(parent);
  return connection_->ListTasks(request);
}

StreamRange<google::cloud::batch::v1::Task> BatchServiceClient::ListTasks(
    google::cloud::batch::v1::ListTasksRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTasks(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace batch_v1
}  // namespace cloud
}  // namespace google
