// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INSTANCES_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INSTANCES_CLIENT_H

#include "google/cloud/appengine/v1/instances_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace appengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Manages instances of a version.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class InstancesClient {
 public:
  explicit InstancesClient(std::shared_ptr<InstancesConnection> connection,
                           Options opts = {});
  ~InstancesClient();

  ///@{
  /// @name Copy and move support
  InstancesClient(InstancesClient const&) = default;
  InstancesClient& operator=(InstancesClient const&) = default;
  InstancesClient(InstancesClient&&) = default;
  InstancesClient& operator=(InstancesClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(InstancesClient const& a, InstancesClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(InstancesClient const& a, InstancesClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists the instances of a version.
  ///
  /// Tip: To aggregate details about instances over time, see the
  /// [Stackdriver Monitoring API](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.appengine.v1.ListInstancesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.appengine.v1.Instance], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.appengine.v1.Instance]: @googleapis_reference_link{google/appengine/v1/instance.proto#L33}
  /// [google.appengine.v1.ListInstancesRequest]: @googleapis_reference_link{google/appengine/v1/appengine.proto#L492}
  ///
  // clang-format on
  StreamRange<google::appengine::v1::Instance> ListInstances(
      google::appengine::v1::ListInstancesRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets instance information.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.appengine.v1.GetInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.appengine.v1.Instance])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.appengine.v1.GetInstanceRequest]: @googleapis_reference_link{google/appengine/v1/appengine.proto#L514}
  /// [google.appengine.v1.Instance]: @googleapis_reference_link{google/appengine/v1/instance.proto#L33}
  ///
  // clang-format on
  StatusOr<google::appengine::v1::Instance> GetInstance(
      google::appengine::v1::GetInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Stops a running instance.
  ///
  /// The instance might be automatically recreated based on the scaling settings
  /// of the version. For more information, see "How Instances are Managed"
  /// ([standard environment](https://cloud.google.com/appengine/docs/standard/python/how-instances-are-managed) |
  /// [flexible environment](https://cloud.google.com/appengine/docs/flexible/python/how-instances-are-managed)).
  ///
  /// To ensure that instances are not re-created and avoid getting billed, you
  /// can stop all instances within the target version by changing the serving
  /// status of the version to `STOPPED` with the
  /// [`apps.services.versions.patch`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions/patch)
  /// method.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.appengine.v1.DeleteInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.appengine.v1.OperationMetadataV1] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.appengine.v1.DeleteInstanceRequest]: @googleapis_reference_link{google/appengine/v1/appengine.proto#L521}
  /// [google.appengine.v1.OperationMetadataV1]: @googleapis_reference_link{google/appengine/v1/operation.proto#L30}
  ///
  // clang-format on
  future<StatusOr<google::appengine::v1::OperationMetadataV1>> DeleteInstance(
      google::appengine::v1::DeleteInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteInstance(
      NoAwaitTag, google::appengine::v1::DeleteInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteInstance
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::appengine::v1::OperationMetadataV1>> DeleteInstance(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Enables debugging on a VM instance. This allows you to use the SSH
  /// command to connect to the virtual machine where the instance lives.
  /// While in "debug mode", the instance continues to serve live traffic.
  /// You should delete the instance when you are done debugging and then
  /// allow the system to take over and determine if another instance
  /// should be started.
  ///
  /// Only applicable for instances in App Engine flexible environment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.appengine.v1.DebugInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.appengine.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.appengine.v1.DebugInstanceRequest]: @googleapis_reference_link{google/appengine/v1/appengine.proto#L528}
  /// [google.appengine.v1.Instance]: @googleapis_reference_link{google/appengine/v1/instance.proto#L33}
  ///
  // clang-format on
  future<StatusOr<google::appengine::v1::Instance>> DebugInstance(
      google::appengine::v1::DebugInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DebugInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DebugInstance(
      NoAwaitTag, google::appengine::v1::DebugInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DebugInstance
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::appengine::v1::Instance>> DebugInstance(
      google::longrunning::Operation const& operation, Options opts = {});

 private:
  std::shared_ptr<InstancesConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INSTANCES_CLIENT_H
