// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/schedule_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_SCHEDULE_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_SCHEDULE_TRACING_CONNECTION_H

#include "google/cloud/aiplatform/v1/schedule_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ScheduleServiceTracingConnection
    : public aiplatform_v1::ScheduleServiceConnection {
 public:
  ~ScheduleServiceTracingConnection() override = default;

  explicit ScheduleServiceTracingConnection(
      std::shared_ptr<aiplatform_v1::ScheduleServiceConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::aiplatform::v1::Schedule> CreateSchedule(
      google::cloud::aiplatform::v1::CreateScheduleRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteSchedule(google::cloud::aiplatform::v1::DeleteScheduleRequest const&
                     request) override;

  StatusOr<google::longrunning::Operation> DeleteSchedule(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteScheduleRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteSchedule(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::Schedule> GetSchedule(
      google::cloud::aiplatform::v1::GetScheduleRequest const& request)
      override;

  StreamRange<google::cloud::aiplatform::v1::Schedule> ListSchedules(
      google::cloud::aiplatform::v1::ListSchedulesRequest request) override;

  Status PauseSchedule(
      google::cloud::aiplatform::v1::PauseScheduleRequest const& request)
      override;

  Status ResumeSchedule(
      google::cloud::aiplatform::v1::ResumeScheduleRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::Schedule> UpdateSchedule(
      google::cloud::aiplatform::v1::UpdateScheduleRequest const& request)
      override;

 private:
  std::shared_ptr<aiplatform_v1::ScheduleServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<aiplatform_v1::ScheduleServiceConnection>
MakeScheduleServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::ScheduleServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_SCHEDULE_TRACING_CONNECTION_H
