// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/featurestore_online_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_FEATURESTORE_ONLINE_SERVING_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_FEATURESTORE_ONLINE_SERVING_CLIENT_H

#include "google/cloud/aiplatform/v1/featurestore_online_serving_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// A service for serving online feature values.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class FeaturestoreOnlineServingServiceClient {
 public:
  explicit FeaturestoreOnlineServingServiceClient(
      std::shared_ptr<FeaturestoreOnlineServingServiceConnection> connection,
      Options opts = {});
  ~FeaturestoreOnlineServingServiceClient();

  ///@{
  /// @name Copy and move support
  FeaturestoreOnlineServingServiceClient(
      FeaturestoreOnlineServingServiceClient const&) = default;
  FeaturestoreOnlineServingServiceClient& operator=(
      FeaturestoreOnlineServingServiceClient const&) = default;
  FeaturestoreOnlineServingServiceClient(
      FeaturestoreOnlineServingServiceClient&&) = default;
  FeaturestoreOnlineServingServiceClient& operator=(
      FeaturestoreOnlineServingServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(FeaturestoreOnlineServingServiceClient const& a,
                         FeaturestoreOnlineServingServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(FeaturestoreOnlineServingServiceClient const& a,
                         FeaturestoreOnlineServingServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Reads Feature values of a specific entity of an EntityType. For reading
  /// feature values of multiple entities of an EntityType, please use
  /// StreamingReadFeatureValues.
  ///
  /// @param entity_type  Required. The resource name of the EntityType for the entity being read.
  ///  Value format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`.
  ///  For example, for a machine learning model predicting user clicks on a
  ///  website, an EntityType ID could be `user`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ReadFeatureValuesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ReadFeatureValuesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_online_service.proto#L121}
  /// [google.cloud.aiplatform.v1.ReadFeatureValuesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_online_service.proto#L145}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::ReadFeatureValuesResponse>
  ReadFeatureValues(std::string const& entity_type, Options opts = {});

  // clang-format off
  ///
  /// Reads Feature values of a specific entity of an EntityType. For reading
  /// feature values of multiple entities of an EntityType, please use
  /// StreamingReadFeatureValues.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ReadFeatureValuesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ReadFeatureValuesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ReadFeatureValuesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_online_service.proto#L121}
  /// [google.cloud.aiplatform.v1.ReadFeatureValuesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_online_service.proto#L145}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::ReadFeatureValuesResponse>
  ReadFeatureValues(
      google::cloud::aiplatform::v1::ReadFeatureValuesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Reads Feature values for multiple entities. Depending on their size, data
  /// for different entities may be broken
  /// up across multiple responses.
  ///
  /// @param entity_type  Required. The resource name of the entities' type.
  ///  Value format:
  ///  `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`.
  ///  For example,
  ///  for a machine learning model predicting user clicks on a website, an
  ///  EntityType ID could be `user`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ReadFeatureValuesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ReadFeatureValuesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_online_service.proto#L145}
  /// [google.cloud.aiplatform.v1.StreamingReadFeatureValuesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_online_service.proto#L210}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::ReadFeatureValuesResponse>
  StreamingReadFeatureValues(std::string const& entity_type, Options opts = {});

  // clang-format off
  ///
  /// Reads Feature values for multiple entities. Depending on their size, data
  /// for different entities may be broken
  /// up across multiple responses.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.StreamingReadFeatureValuesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ReadFeatureValuesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ReadFeatureValuesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_online_service.proto#L145}
  /// [google.cloud.aiplatform.v1.StreamingReadFeatureValuesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_online_service.proto#L210}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::ReadFeatureValuesResponse>
  StreamingReadFeatureValues(
      google::cloud::aiplatform::v1::StreamingReadFeatureValuesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Writes Feature values of one or more entities of an EntityType.
  ///
  /// The Feature values are merged into existing entities if any. The Feature
  /// values to be written must have timestamp within the online storage
  /// retention.
  ///
  /// @param entity_type  Required. The resource name of the EntityType for the entities being
  ///  written. Value format:
  ///  `projects/{project}/locations/{location}/featurestores/
  ///  {featurestore}/entityTypes/{entityType}`. For example,
  ///  for a machine learning model predicting user clicks on a website, an
  ///  EntityType ID could be `user`.
  /// @param payloads  Required. The entities to be written. Up to 100,000 feature values can be
  ///  written across all `payloads`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.WriteFeatureValuesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.WriteFeatureValuesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_online_service.proto#L82}
  /// [google.cloud.aiplatform.v1.WriteFeatureValuesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_online_service.proto#L117}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::WriteFeatureValuesResponse>
  WriteFeatureValues(
      std::string const& entity_type,
      std::vector<
          google::cloud::aiplatform::v1::WriteFeatureValuesPayload> const&
          payloads,
      Options opts = {});

  // clang-format off
  ///
  /// Writes Feature values of one or more entities of an EntityType.
  ///
  /// The Feature values are merged into existing entities if any. The Feature
  /// values to be written must have timestamp within the online storage
  /// retention.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.WriteFeatureValuesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.WriteFeatureValuesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.WriteFeatureValuesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_online_service.proto#L82}
  /// [google.cloud.aiplatform.v1.WriteFeatureValuesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/featurestore_online_service.proto#L117}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::WriteFeatureValuesResponse>
  WriteFeatureValues(
      google::cloud::aiplatform::v1::WriteFeatureValuesRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<FeaturestoreOnlineServingServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_FEATURESTORE_ONLINE_SERVING_CLIENT_H
