// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test.proto

#include "generator/integration_tests/golden/v1/internal/golden_thing_admin_rest_metadata_decorator.h"
#include "absl/strings/str_format.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/rest_set_metadata.h"
#include "google/cloud/internal/routing_matcher.h"
#include "google/cloud/status_or.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GoldenThingAdminRestMetadata::GoldenThingAdminRestMetadata(
    std::shared_ptr<GoldenThingAdminRestStub> child,
    std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::test::admin::database::v1::ListDatabasesResponse>
GoldenThingAdminRestMetadata::ListDatabases(
    rest_internal::RestContext& rest_context,
    Options const& options, google::test::admin::database::v1::ListDatabasesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListDatabases(rest_context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
GoldenThingAdminRestMetadata::AsyncCreateDatabase(
      CompletionQueue& cq,
      std::unique_ptr<rest_internal::RestContext> rest_context,
      google::cloud::internal::ImmutableOptions options,
      google::test::admin::database::v1::CreateDatabaseRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCreateDatabase(
      cq, std::move(rest_context), std::move(options), request);
}

StatusOr<google::longrunning::Operation>
GoldenThingAdminRestMetadata::CreateDatabase(
    rest_internal::RestContext& rest_context,
    Options const& options, google::test::admin::database::v1::CreateDatabaseRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->CreateDatabase(rest_context, options, request);
}

StatusOr<google::test::admin::database::v1::Database>
GoldenThingAdminRestMetadata::GetDatabase(
    rest_internal::RestContext& rest_context,
    Options const& options, google::test::admin::database::v1::GetDatabaseRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetDatabase(rest_context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
GoldenThingAdminRestMetadata::AsyncUpdateDatabaseDdl(
      CompletionQueue& cq,
      std::unique_ptr<rest_internal::RestContext> rest_context,
      google::cloud::internal::ImmutableOptions options,
      google::test::admin::database::v1::UpdateDatabaseDdlRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncUpdateDatabaseDdl(
      cq, std::move(rest_context), std::move(options), request);
}

StatusOr<google::longrunning::Operation>
GoldenThingAdminRestMetadata::UpdateDatabaseDdl(
    rest_internal::RestContext& rest_context,
    Options const& options, google::test::admin::database::v1::UpdateDatabaseDdlRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->UpdateDatabaseDdl(rest_context, options, request);
}

Status
GoldenThingAdminRestMetadata::DropDatabase(
    rest_internal::RestContext& rest_context,
    Options const& options, google::test::admin::database::v1::DropDatabaseRequest const& request) {
  std::vector<std::string> params;
  params.reserve(3);

  static auto* project_matcher = []{
    return new google::cloud::internal::RoutingMatcher<google::test::admin::database::v1::DropDatabaseRequest>{
      "project=", {
      {[](google::test::admin::database::v1::DropDatabaseRequest const& request) -> std::string const& {
        return request.database();
      },
      std::regex{"(projects/[^/]+)/instances/[^/]+/databases/[^/]+", std::regex::optimize}},
      }};
  }();
  project_matcher->AppendParam(request, params);

  static auto* instance_matcher = []{
    return new google::cloud::internal::RoutingMatcher<google::test::admin::database::v1::DropDatabaseRequest>{
      "instance=", {
      {[](google::test::admin::database::v1::DropDatabaseRequest const& request) -> std::string const& {
        return request.database();
      },
      std::regex{"projects/[^/]+/(instances/[^/]+)/databases/[^/]+", std::regex::optimize}},
      }};
  }();
  instance_matcher->AppendParam(request, params);

  static auto* database_matcher = []{
    return new google::cloud::internal::RoutingMatcher<google::test::admin::database::v1::DropDatabaseRequest>{
      "database=", {
      {[](google::test::admin::database::v1::DropDatabaseRequest const& request) -> std::string const& {
        return request.database();
      },
      std::regex{"projects/[^/]+/instances/[^/]+/(databases/[^/]+)", std::regex::optimize}},
      }};
  }();
  database_matcher->AppendParam(request, params);

  SetMetadata(rest_context, options, params);

  return child_->DropDatabase(rest_context, options, request);
}

StatusOr<google::test::admin::database::v1::GetDatabaseDdlResponse>
GoldenThingAdminRestMetadata::GetDatabaseDdl(
    rest_internal::RestContext& rest_context,
    Options const& options, google::test::admin::database::v1::GetDatabaseDdlRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetDatabaseDdl(rest_context, options, request);
}

StatusOr<google::iam::v1::Policy>
GoldenThingAdminRestMetadata::SetIamPolicy(
    rest_internal::RestContext& rest_context,
    Options const& options, google::iam::v1::SetIamPolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetIamPolicy(rest_context, options, request);
}

StatusOr<google::iam::v1::Policy>
GoldenThingAdminRestMetadata::GetIamPolicy(
    rest_internal::RestContext& rest_context,
    Options const& options, google::iam::v1::GetIamPolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetIamPolicy(rest_context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
GoldenThingAdminRestMetadata::TestIamPermissions(
    rest_internal::RestContext& rest_context,
    Options const& options, google::iam::v1::TestIamPermissionsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->TestIamPermissions(rest_context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
GoldenThingAdminRestMetadata::AsyncCreateBackup(
      CompletionQueue& cq,
      std::unique_ptr<rest_internal::RestContext> rest_context,
      google::cloud::internal::ImmutableOptions options,
      google::test::admin::database::v1::CreateBackupRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCreateBackup(
      cq, std::move(rest_context), std::move(options), request);
}

StatusOr<google::longrunning::Operation>
GoldenThingAdminRestMetadata::CreateBackup(
    rest_internal::RestContext& rest_context,
    Options const& options, google::test::admin::database::v1::CreateBackupRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->CreateBackup(rest_context, options, request);
}

StatusOr<google::test::admin::database::v1::Backup>
GoldenThingAdminRestMetadata::GetBackup(
    rest_internal::RestContext& rest_context,
    Options const& options, google::test::admin::database::v1::GetBackupRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetBackup(rest_context, options, request);
}

StatusOr<google::test::admin::database::v1::Backup>
GoldenThingAdminRestMetadata::UpdateBackup(
    rest_internal::RestContext& rest_context,
    Options const& options, google::test::admin::database::v1::UpdateBackupRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->UpdateBackup(rest_context, options, request);
}

Status
GoldenThingAdminRestMetadata::DeleteBackup(
    rest_internal::RestContext& rest_context,
    Options const& options, google::test::admin::database::v1::DeleteBackupRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->DeleteBackup(rest_context, options, request);
}

StatusOr<google::test::admin::database::v1::ListBackupsResponse>
GoldenThingAdminRestMetadata::ListBackups(
    rest_internal::RestContext& rest_context,
    Options const& options, google::test::admin::database::v1::ListBackupsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListBackups(rest_context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
GoldenThingAdminRestMetadata::AsyncRestoreDatabase(
      CompletionQueue& cq,
      std::unique_ptr<rest_internal::RestContext> rest_context,
      google::cloud::internal::ImmutableOptions options,
      google::test::admin::database::v1::RestoreDatabaseRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncRestoreDatabase(
      cq, std::move(rest_context), std::move(options), request);
}

StatusOr<google::longrunning::Operation>
GoldenThingAdminRestMetadata::RestoreDatabase(
    rest_internal::RestContext& rest_context,
    Options const& options, google::test::admin::database::v1::RestoreDatabaseRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->RestoreDatabase(rest_context, options, request);
}

StatusOr<google::test::admin::database::v1::ListDatabaseOperationsResponse>
GoldenThingAdminRestMetadata::ListDatabaseOperations(
    rest_internal::RestContext& rest_context,
    Options const& options, google::test::admin::database::v1::ListDatabaseOperationsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListDatabaseOperations(rest_context, options, request);
}

StatusOr<google::test::admin::database::v1::ListBackupOperationsResponse>
GoldenThingAdminRestMetadata::ListBackupOperations(
    rest_internal::RestContext& rest_context,
    Options const& options, google::test::admin::database::v1::ListBackupOperationsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListBackupOperations(rest_context, options, request);
}

future<StatusOr<google::test::admin::database::v1::Database>>
GoldenThingAdminRestMetadata::AsyncGetDatabase(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::test::admin::database::v1::GetDatabaseRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncGetDatabase(
      cq, std::move(rest_context), std::move(options), request);
}

future<Status>
GoldenThingAdminRestMetadata::AsyncDropDatabase(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::test::admin::database::v1::DropDatabaseRequest const& request) {
  std::vector<std::string> params;
  params.reserve(3);

  static auto* project_matcher = []{
    return new google::cloud::internal::RoutingMatcher<google::test::admin::database::v1::DropDatabaseRequest>{
      "project=", {
      {[](google::test::admin::database::v1::DropDatabaseRequest const& request) -> std::string const& {
        return request.database();
      },
      std::regex{"(projects/[^/]+)/instances/[^/]+/databases/[^/]+", std::regex::optimize}},
      }};
  }();
  project_matcher->AppendParam(request, params);

  static auto* instance_matcher = []{
    return new google::cloud::internal::RoutingMatcher<google::test::admin::database::v1::DropDatabaseRequest>{
      "instance=", {
      {[](google::test::admin::database::v1::DropDatabaseRequest const& request) -> std::string const& {
        return request.database();
      },
      std::regex{"projects/[^/]+/(instances/[^/]+)/databases/[^/]+", std::regex::optimize}},
      }};
  }();
  instance_matcher->AppendParam(request, params);

  static auto* database_matcher = []{
    return new google::cloud::internal::RoutingMatcher<google::test::admin::database::v1::DropDatabaseRequest>{
      "database=", {
      {[](google::test::admin::database::v1::DropDatabaseRequest const& request) -> std::string const& {
        return request.database();
      },
      std::regex{"projects/[^/]+/instances/[^/]+/(databases/[^/]+)", std::regex::optimize}},
      }};
  }();
  database_matcher->AppendParam(request, params);

  SetMetadata(*rest_context, *options, params);

  return child_->AsyncDropDatabase(
      cq, std::move(rest_context), std::move(options), request);
}

future<StatusOr<google::longrunning::Operation>>
GoldenThingAdminRestMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncGetOperation(
      cq, std::move(rest_context), std::move(options), request);
}

future<Status>
GoldenThingAdminRestMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCancelOperation(
      cq, std::move(rest_context), std::move(options), request);
}

void GoldenThingAdminRestMetadata::SetMetadata(
      rest_internal::RestContext& rest_context,
      Options const& options, std::vector<std::string> const& params) {
  google::cloud::rest_internal::SetMetadata(
      rest_context, options, params, api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google
