/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#ifndef __SBP2_LOGOUT_H__
#define __SBP2_LOGOUT_H__


#include <glib.h>

#include <libsbp2/sbp2pointer.h>


typedef struct _SBP2LogoutORB SBP2LogoutORB;

struct _SBP2LogoutORB
{
  guint32     reserved1;
  guint32     reserved2;
  guint32     reserved3;
  guint32     reserved4;
#if G_BYTE_ORDER == G_BIG_ENDIAN
  guint       notify    : 1;
  guint       req_fmt   : 2;
  guint       reserved5 : 9;
  guint       function  : 4;
  guint       login_ID  : 16;
#else
  guint       login_ID  : 16;
  guint       function  : 4;
  guint       reserved5 : 9;
  guint       req_fmt   : 2;
  guint       notify    : 1;
#endif
  guint32     reserved6;
  SBP2Pointer status_FIFO;
};


#endif /* __SBP2_LOGOUT_H__ */
