/*
 * This file is part of the ESO Common Pipeline Library
 * Copyright (C) 2001-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef ER_JSON_H
#define ER_JSON_H

#include "cpl.h"

CPL_BEGIN_DECLS


cpl_error_code er_frameset_to_json(const cpl_frameset * frameset, 
                                   const char* json_file);
cpl_error_code er_frameset_to_text(const cpl_frameset * frameset, 
                                   const char* text_file);
cpl_error_code er_recipe_parameterlist_to_json(const cpl_parameterlist * plist,
                                               const char * recipe_name,
                                               const char * json_file);
char * er_json_escape_string(const char * str);

CPL_END_DECLS
#endif
