/*----------------------------------------------------------------------------------------
  Module header file for: pr module
----------------------------------------------------------------------------------------*/
#ifndef PRDATABASE_H

#define PRDATABASE_H

#if defined __cplusplus
extern "C" {
#endif

#ifndef DD_UTIL_H
#include "ddutil.h"
#endif

/* Class reference definitions */

#if defined(DD_DEBUG) && !defined(DD_NOSTRICT)
typedef struct _struct_prRoot{char val;} *prRoot;
#define prRootNull ((prRoot)(UINT8_MAX))
#define prRoot2Index(Root) ((uint32)((Root) - (prRoot)(0)))
#define prRoot2ValidIndex(Root) ((uint32)(prValidRoot(Root) - (prRoot)(0)))
#define prIndex2Root(xRoot) ((prRoot)((xRoot) + (prRoot)(0)))
typedef struct _struct_prNode{char val;} *prNode;
#define prNodeNull ((prNode)(UINT32_MAX))
#define prNode2Index(Node) ((uint32)((Node) - (prNode)(0)))
#define prNode2ValidIndex(Node) ((uint32)(prValidNode(Node) - (prNode)(0)))
#define prIndex2Node(xNode) ((prNode)((xNode) + (prNode)(0)))
#else
typedef uint8 prRoot;
#define prRootNull UINT8_MAX
#define prRoot2Index(Root) (Root)
#define prRoot2ValidIndex(Root) (prValidRoot(Root))
#define prIndex2Root(xRoot) ((xRoot))
typedef uint32 prNode;
#define prNodeNull UINT32_MAX
#define prNode2Index(Node) (Node)
#define prNode2ValidIndex(Node) (prValidNode(Node))
#define prIndex2Node(xNode) ((xNode))
#endif

/* Validate macros */
#if defined(DD_DEBUG)
#define prValidRoot(Root) (utLikely((uint32)((Root) - (prRoot)0) < \
    prRootData.usedRoot)? (Root) : (utExit("Invalid Root"), (prRoot)0))
#define prValidNode(Node) (utLikely((uint32)((Node) - (prNode)0) < \
    prRootData.usedNode)? (Node) : (utExit("Invalid Node"), (prNode)0))
#else
#define prValidRoot(Root) (Root)
#define prValidNode(Node) (Node)
#endif

/*----------------------------------------------------------------------------------------
  Fields for class Root.
----------------------------------------------------------------------------------------*/
struct prRootFields {
    uint32 *NodeIndex;
    uint32 *NumNode;
    prNode *Node;
    uint32 *UsedNode;
    prRoot *FreeList;
};
extern struct prRootFields prRoots;

#define prRootGetNodeIndex(_Root) (prRoots.NodeIndex[prRoot2ValidIndex(_Root)])
#define prRootSetNodeIndex(_Root, value) ( \
    (void)utRecordField(prModuleID, 0, prRoot2ValidIndex(_Root), true), \
    (prRoots.NodeIndex)[prRoot2ValidIndex(_Root)] = (value), \
    (void)utRecordField(prModuleID, 0, prRoot2ValidIndex(_Root), false))
#define prRootGetNumNode(_Root) (prRoots.NumNode[prRoot2ValidIndex(_Root)])
#define prRootSetNumNode(_Root, value) ( \
    (void)utRecordField(prModuleID, 1, prRoot2ValidIndex(_Root), true), \
    (prRoots.NumNode)[prRoot2ValidIndex(_Root)] = (value), \
    (void)utRecordField(prModuleID, 1, prRoot2ValidIndex(_Root), false))
#if defined(DD_DEBUG)
#define prRootCheckNodeIndex(Root, x) ((uint8)(x) < prRootGetNumNode(Root)? (x) : \
    (utAssert(false),(x)))
#else
#define prRootCheckNodeIndex(Root, x) (x)
#endif
#define prRootGetiNode(_Root, x) ((prRoots.Node)[ \
    prRootGetNodeIndex(_Root) + prRootCheckNodeIndex(_Root, (x))])
#define prRootGetNodes(Root) (prRoots.Node + prRootGetNodeIndex(Root))
#define prRootSetNode(Root, valuePtr, numNode) (prRootResizeNodes(Root, numNode),  \
    (void)utRecordArray(prModuleID, 2, prRootGetNodeIndex(Root), prRootGetNumNode(Root), true), \
    memcpy(prRootGetNodes(Root), valuePtr, \
    numNode*sizeof(prNode)), \
    (void)utRecordArray(prModuleID, 2, prRootGetNodeIndex(Root), prRootGetNumNode(Root), false))
#define prRootSetiNode(Root, x, value) ( \
    (void)utRecordField(prModuleID, 2, prRootGetNodeIndex(Root) + (x), true), \
    (prRoots.Node)[ \
    prRootGetNodeIndex(Root) + prRootCheckNodeIndex(Root, (x))] = (value), \
    (void)utRecordField(prModuleID, 2, prRootGetNodeIndex(Root) + (x), false))
#define prRootGetUsedNode(_Root) (prRoots.UsedNode[prRoot2ValidIndex(_Root)])
#define prRootSetUsedNode(_Root, value) ( \
    (void)utRecordField(prModuleID, 3, prRoot2ValidIndex(_Root), true), \
    (prRoots.UsedNode)[prRoot2ValidIndex(_Root)] = (value), \
    (void)utRecordField(prModuleID, 3, prRoot2ValidIndex(_Root), false))
#define prRootGetFreeList(_Root) (prRoots.FreeList[prRoot2ValidIndex(_Root)])
#define prRootSetFreeList(_Root, value) ( \
    (void)utRecordField(prModuleID, 4, prRoot2ValidIndex(_Root), true), \
    (prRoots.FreeList)[prRoot2ValidIndex(_Root)] = (value), \
    (void)utRecordField(prModuleID, 4, prRoot2ValidIndex(_Root), false))
#define prForeachRootNode(pVar, cVar) { \
    uint32 _xNode; \
    for(_xNode = 0; _xNode < prRootGetUsedNode(pVar); _xNode++) { \
        cVar = prRootGetiNode(pVar, _xNode); \
        if(cVar != prNodeNull) {
#define prEndRootNode }}}
#define prRootSetConstructorCallback(func) (prRootConstructorCallback = (func))
#define prRootGetConstructorCallback() (prRootConstructorCallback)
#define prFirstRoot() (prRootData.usedRoot == 0? prRootNull : prIndex2Root(0))
#define prLastRoot() (prRootData.usedRoot == 0? prRootNull : \
    prIndex2Root(prRootData.usedRoot - 1))
#define prNextRoot(Root) (prRoot2ValidIndex(Root) + 1 == prRootData.usedRoot? prRootNull : \
    (Root) + 1)
#define prPrevRoot(Root) (prRoot2ValidIndex(Root) == 0? prRootNull : (Root) - 1)
#define prForeachRoot(var) \
    for(var = prIndex2Root(0); prRoot2Index(var) != prRootData.usedRoot; var++)
#define prEndRoot
#define prRootFreeAll() (prSetUsedRoot(0), prSetUsedRootNode(0))
#define prRootAllocRaw() ( \
    prRootData.usedRoot == prRootData.allocatedRoot && (prRootAllocMore(), true), \
    prTemp_.Root = prIndex2Root(prRootData.usedRoot), \
    prSetUsedRoot(prUsedRoot() + 1), \
    prTemp_.Root)
#define prRootAlloc() ( \
    prRootData.usedRoot == prRootData.allocatedRoot && (prRootAllocMore(), true), \
    prTemp_.Root = prIndex2Root(prRootData.usedRoot), \
    prSetUsedRoot(prUsedRoot() + 1), \
    prRootSetNodeIndex(prTemp_.Root, 0), \
    prRootSetNumNode(prTemp_.Root, 0), \
    prRootSetNumNode(prTemp_.Root, 0), \
    prRootSetUsedNode(prTemp_.Root, 0), \
    prRootSetFreeList(prTemp_.Root, prRootNull), \
    prRootConstructorCallback != NULL && (prRootConstructorCallback(prTemp_.Root), true), \
    prTemp_.Root)

void prRootAllocMore(void);
void prRootCopyProps(prRoot prOldRoot, prRoot prNewRoot);
void prRootAllocNodes(prRoot Root, uint32 numNodes);
void prRootResizeNodes(prRoot Root, uint32 numNodes);
void prRootFreeNodes(prRoot Root);
void prCompactRootNodes(void);
void prRootInsertNode(prRoot Root, uint32 x, prNode _Node);
void prRootAppendNode(prRoot Root, prNode _Node);
void prRootRemoveNode(prRoot Root, prNode _Node);
static void prRootSwapNode(prRoot Root, uint32 x, uint32 y);
static void prRootHeapDownNode(prRoot Root, uint32 arg_x);
static void prRootHeapUpNode(prRoot Root, uint32 arg_x);
void prRootImproveNode(prNode Node);
void prRootPushNode(prRoot Root, prNode Node);
prNode prRootPeekNode(prRoot Root);
prNode prRootPopNode(prRoot Root);
int prRootCompareNode(prNode a, prNode b);

/*----------------------------------------------------------------------------------------
  Fields for class Node.
----------------------------------------------------------------------------------------*/
struct prNodeFields {
    utSym *Sym;
    prRoot *Root;
    uint32 *RootIndex;
    prNode *FreeList;
};
extern struct prNodeFields prNodes;

#define prNodeGetSym(_Node) (prNodes.Sym[prNode2ValidIndex(_Node)])
#define prNodeSetSym(_Node, value) ( \
    (void)utRecordField(prModuleID, 5, prNode2ValidIndex(_Node), true), \
    (prNodes.Sym)[prNode2ValidIndex(_Node)] = (value), \
    (void)utRecordField(prModuleID, 5, prNode2ValidIndex(_Node), false))
#define prNodeGetRoot(_Node) (prNodes.Root[prNode2ValidIndex(_Node)])
#define prNodeSetRoot(_Node, value) ( \
    (void)utRecordField(prModuleID, 6, prNode2ValidIndex(_Node), true), \
    (prNodes.Root)[prNode2ValidIndex(_Node)] = (value), \
    (void)utRecordField(prModuleID, 6, prNode2ValidIndex(_Node), false))
#define prNodeGetRootIndex(_Node) (prNodes.RootIndex[prNode2ValidIndex(_Node)])
#define prNodeSetRootIndex(_Node, value) ( \
    (void)utRecordField(prModuleID, 7, prNode2ValidIndex(_Node), true), \
    (prNodes.RootIndex)[prNode2ValidIndex(_Node)] = (value), \
    (void)utRecordField(prModuleID, 7, prNode2ValidIndex(_Node), false))
#define prNodeGetFreeList(_Node) (prNodes.FreeList[prNode2ValidIndex(_Node)])
#define prNodeSetFreeList(_Node, value) ( \
    (void)utRecordField(prModuleID, 8, prNode2ValidIndex(_Node), true), \
    (prNodes.FreeList)[prNode2ValidIndex(_Node)] = (value), \
    (void)utRecordField(prModuleID, 8, prNode2ValidIndex(_Node), false))
#define prNodeSetConstructorCallback(func) (prNodeConstructorCallback = (func))
#define prNodeGetConstructorCallback() (prNodeConstructorCallback)
#define prNodeSetDestructorCallback(func) (prNodeDestructorCallback = (func))
#define prNodeGetDestructorCallback() (prNodeDestructorCallback)
#define prNodeNextFree(_Node) (((prNode *)(void *)(prNodes.FreeList))[prNode2ValidIndex(_Node)])
#define prNodeSetNextFree(_Node, value) ( \
    (void)utRecordField(prModuleID, 8, prNode2ValidIndex(Node), true), \
    ((prNode *)(void *)(prNodes.FreeList)) \
    [prNode2ValidIndex(_Node)] = (value), \
    (void)utRecordField(prModuleID, 8, prNode2ValidIndex(Node), false))
#define prNodeAllocRaw() ( \
    prRootData.firstFreeNode != prNodeNull? \
        (prTemp_.Node = prRootData.firstFreeNode, \
        prSetFirstFreeNode(prNodeNextFree(prTemp_.Node)), true) \
    : (prRootData.usedNode == prRootData.allocatedNode && (prNodeAllocMore(), true), \
        prTemp_.Node = prIndex2Node(prRootData.usedNode), \
        prSetUsedNode(prUsedNode() + 1)), \
    prTemp_.Node)
#define prNodeAlloc() ( \
    prRootData.firstFreeNode != prNodeNull? \
        (prTemp_.Node = prRootData.firstFreeNode, \
        prSetFirstFreeNode(prNodeNextFree(prTemp_.Node)), true) \
    : (prRootData.usedNode == prRootData.allocatedNode && (prNodeAllocMore(), true), \
        prTemp_.Node = prIndex2Node(prRootData.usedNode), \
        prSetUsedNode(prUsedNode() + 1)), \
    prNodeSetSym(prTemp_.Node, utSymNull), \
    prNodeSetRoot(prTemp_.Node, prRootNull), \
    prNodeSetRootIndex(prTemp_.Node, 0), \
    prNodeSetFreeList(prTemp_.Node, prNodeNull), \
    prNodeConstructorCallback != NULL && (prNodeConstructorCallback(prTemp_.Node), true), \
    prTemp_.Node)

#define prNodeFree(Node) (prNodeSetNextFree(Node, prRootData.firstFreeNode), \
    prSetFirstFreeNode(Node))
void prNodeDestroy(prNode Node);
void prNodeAllocMore(void);
void prNodeCopyProps(prNode prOldNode, prNode prNewNode);

/*----------------------------------------------------------------------------------------
  Temp Union structure - Macro temp variables, use only one
----------------------------------------------------------------------------------------*/
union prTempType_ {
    prRoot Root;
    prNode Node;
};

extern union prTempType_ prTemp_;

/*----------------------------------------------------------------------------------------
  Constructor/Destructor hooks.
----------------------------------------------------------------------------------------*/
extern void(*prRootConstructorCallback)(prRoot);
extern void(*prNodeConstructorCallback)(prNode);
extern void(*prNodeDestructorCallback)(prNode);

/*----------------------------------------------------------------------------------------
  Root structure
----------------------------------------------------------------------------------------*/
struct prRootType_ {
    uint32 hash; /* This depends only on the structure of the database */
    uint8 usedRoot, allocatedRoot;
    uint32 usedRootNode, allocatedRootNode, freeRootNode;
    prNode firstFreeNode;
    uint32 usedNode, allocatedNode;
};
extern struct prRootType_ prRootData;

#define prHash() (prRootData.hash)
#define prUsedRoot() prRootData.usedRoot
#define prAllocatedRoot() prRootData.allocatedRoot
#define prSetUsedRoot(value) ( \
    (void)utRecordGlobal(prModuleID, 1, &prRootData.usedRoot, true), \
    prRootData.usedRoot = (value), \
    (void)utRecordGlobal(prModuleID, 1, &prRootData.usedRoot, false))
#define prSetAllocatedRoot(value) ( \
    (void)utRecordGlobal(prModuleID, 1, &prRootData.allocatedRoot, true), \
    prRootData.allocatedRoot = (value), \
    (void)utRecordGlobal(prModuleID, 1, &prRootData.allocatedRoot, false))
#define prUsedRootNode() prRootData.usedRootNode
#define prAllocatedRootNode() prRootData.allocatedRootNode
#define prFreeRootNode() prRootData.freeRootNode
#define prSetUsedRootNode(value) ( \
    (void)utRecordGlobal(prModuleID, sizeof(uint32), &prRootData.usedRootNode, true), \
    prRootData.usedRootNode = (value), \
    (void)utRecordGlobal(prModuleID, sizeof(uint32), &prRootData.usedRootNode, false))
#define prSetAllocatedRootNode(value) ( \
    (void)utRecordGlobal(prModuleID, sizeof(uint32), &prRootData.allocatedRootNode, true), \
    prRootData.allocatedRootNode = (value), \
    (void)utRecordGlobal(prModuleID, sizeof(uint32), &prRootData.allocatedRootNode, false))
#define prSetFreeRootNode(value) ( \
    (void)utRecordGlobal(prModuleID, sizeof(uint32), &prRootData.freeRootNode, true), \
    prRootData.freeRootNode = (value), \
    (void)utRecordGlobal(prModuleID, sizeof(uint32), &prRootData.freeRootNode, false))
#define prFirstFreeNode() prRootData.firstFreeNode
#define prSetFirstFreeNode(value) ( \
    (void)utRecordGlobal(prModuleID, 4, &prRootData.firstFreeNode, true), \
    prRootData.firstFreeNode = (value), \
    (void)utRecordGlobal(prModuleID, 4, &prRootData.firstFreeNode, false))
#define prUsedNode() prRootData.usedNode
#define prAllocatedNode() prRootData.allocatedNode
#define prSetUsedNode(value) ( \
    (void)utRecordGlobal(prModuleID, 4, &prRootData.usedNode, true), \
    prRootData.usedNode = (value), \
    (void)utRecordGlobal(prModuleID, 4, &prRootData.usedNode, false))
#define prSetAllocatedNode(value) ( \
    (void)utRecordGlobal(prModuleID, 4, &prRootData.allocatedNode, true), \
    prRootData.allocatedNode = (value), \
    (void)utRecordGlobal(prModuleID, 4, &prRootData.allocatedNode, false))

extern uint8 prModuleID;
void prDatabaseStart(void);
void prDatabaseStop(void);
#if defined __cplusplus
}
#endif

#endif
