package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PrepareUpload invokes the vs.PrepareUpload API synchronously
func (client *Client) PrepareUpload(request *PrepareUploadRequest) (response *PrepareUploadResponse, err error) {
	response = CreatePrepareUploadResponse()
	err = client.DoAction(request, response)
	return
}

// PrepareUploadWithChan invokes the vs.PrepareUpload API asynchronously
func (client *Client) PrepareUploadWithChan(request *PrepareUploadRequest) (<-chan *PrepareUploadResponse, <-chan error) {
	responseChan := make(chan *PrepareUploadResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PrepareUpload(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PrepareUploadWithCallback invokes the vs.PrepareUpload API asynchronously
func (client *Client) PrepareUploadWithCallback(request *PrepareUploadRequest, callback func(response *PrepareUploadResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PrepareUploadResponse
		var err error
		defer close(result)
		response, err = client.PrepareUpload(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PrepareUploadRequest is the request struct for api PrepareUpload
type PrepareUploadRequest struct {
	*requests.RpcRequest
	BucketName   string           `position:"Query" name:"BucketName"`
	ClientIp     string           `position:"Query" name:"ClientIp"`
	ShowLog      string           `position:"Query" name:"ShowLog"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	AdditionType string           `position:"Query" name:"AdditionType"`
}

// PrepareUploadResponse is the response struct for api PrepareUpload
type PrepareUploadResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	BucketName   string `json:"BucketName" xml:"BucketName"`
	Endpoint     string `json:"Endpoint" xml:"Endpoint"`
	AdditionInfo string `json:"AdditionInfo" xml:"AdditionInfo"`
}

// CreatePrepareUploadRequest creates a request to invoke PrepareUpload API
func CreatePrepareUploadRequest() (request *PrepareUploadRequest) {
	request = &PrepareUploadRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "PrepareUpload", "", "")
	request.Method = requests.POST
	return
}

// CreatePrepareUploadResponse creates a response to parse from PrepareUpload response
func CreatePrepareUploadResponse() (response *PrepareUploadResponse) {
	response = &PrepareUploadResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
