package videoenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFaceVideoTemplate invokes the videoenhan.QueryFaceVideoTemplate API synchronously
func (client *Client) QueryFaceVideoTemplate(request *QueryFaceVideoTemplateRequest) (response *QueryFaceVideoTemplateResponse, err error) {
	response = CreateQueryFaceVideoTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFaceVideoTemplateWithChan invokes the videoenhan.QueryFaceVideoTemplate API asynchronously
func (client *Client) QueryFaceVideoTemplateWithChan(request *QueryFaceVideoTemplateRequest) (<-chan *QueryFaceVideoTemplateResponse, <-chan error) {
	responseChan := make(chan *QueryFaceVideoTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFaceVideoTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFaceVideoTemplateWithCallback invokes the videoenhan.QueryFaceVideoTemplate API asynchronously
func (client *Client) QueryFaceVideoTemplateWithCallback(request *QueryFaceVideoTemplateRequest, callback func(response *QueryFaceVideoTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFaceVideoTemplateResponse
		var err error
		defer close(result)
		response, err = client.QueryFaceVideoTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFaceVideoTemplateRequest is the request struct for api QueryFaceVideoTemplate
type QueryFaceVideoTemplateRequest struct {
	*requests.RpcRequest
	UserId     string `position:"Query" name:"UserId"`
	TemplateId string `position:"Query" name:"TemplateId"`
}

// QueryFaceVideoTemplateResponse is the response struct for api QueryFaceVideoTemplate
type QueryFaceVideoTemplateResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryFaceVideoTemplateRequest creates a request to invoke QueryFaceVideoTemplate API
func CreateQueryFaceVideoTemplateRequest() (request *QueryFaceVideoTemplateRequest) {
	request = &QueryFaceVideoTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videoenhan", "2020-03-20", "QueryFaceVideoTemplate", "videoenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryFaceVideoTemplateResponse creates a response to parse from QueryFaceVideoTemplate response
func CreateQueryFaceVideoTemplateResponse() (response *QueryFaceVideoTemplateResponse) {
	response = &QueryFaceVideoTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
