package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubscribeSpaceEvent invokes the vcs.SubscribeSpaceEvent API synchronously
func (client *Client) SubscribeSpaceEvent(request *SubscribeSpaceEventRequest) (response *SubscribeSpaceEventResponse, err error) {
	response = CreateSubscribeSpaceEventResponse()
	err = client.DoAction(request, response)
	return
}

// SubscribeSpaceEventWithChan invokes the vcs.SubscribeSpaceEvent API asynchronously
func (client *Client) SubscribeSpaceEventWithChan(request *SubscribeSpaceEventRequest) (<-chan *SubscribeSpaceEventResponse, <-chan error) {
	responseChan := make(chan *SubscribeSpaceEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubscribeSpaceEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubscribeSpaceEventWithCallback invokes the vcs.SubscribeSpaceEvent API asynchronously
func (client *Client) SubscribeSpaceEventWithCallback(request *SubscribeSpaceEventRequest, callback func(response *SubscribeSpaceEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubscribeSpaceEventResponse
		var err error
		defer close(result)
		response, err = client.SubscribeSpaceEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubscribeSpaceEventRequest is the request struct for api SubscribeSpaceEvent
type SubscribeSpaceEventRequest struct {
	*requests.RpcRequest
	PushConfig string `position:"Query" name:"PushConfig"`
	SpaceId    string `position:"Query" name:"SpaceId"`
}

// SubscribeSpaceEventResponse is the response struct for api SubscribeSpaceEvent
type SubscribeSpaceEventResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSubscribeSpaceEventRequest creates a request to invoke SubscribeSpaceEvent API
func CreateSubscribeSpaceEventRequest() (request *SubscribeSpaceEventRequest) {
	request = &SubscribeSpaceEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "SubscribeSpaceEvent", "", "")
	request.Method = requests.POST
	return
}

// CreateSubscribeSpaceEventResponse creates a response to parse from SubscribeSpaceEvent response
func CreateSubscribeSpaceEventResponse() (response *SubscribeSpaceEventResponse) {
	response = &SubscribeSpaceEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
