package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateVpcEndpointServiceResourceAttribute invokes the privatelink.UpdateVpcEndpointServiceResourceAttribute API synchronously
func (client *Client) UpdateVpcEndpointServiceResourceAttribute(request *UpdateVpcEndpointServiceResourceAttributeRequest) (response *UpdateVpcEndpointServiceResourceAttributeResponse, err error) {
	response = CreateUpdateVpcEndpointServiceResourceAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateVpcEndpointServiceResourceAttributeWithChan invokes the privatelink.UpdateVpcEndpointServiceResourceAttribute API asynchronously
func (client *Client) UpdateVpcEndpointServiceResourceAttributeWithChan(request *UpdateVpcEndpointServiceResourceAttributeRequest) (<-chan *UpdateVpcEndpointServiceResourceAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateVpcEndpointServiceResourceAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateVpcEndpointServiceResourceAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateVpcEndpointServiceResourceAttributeWithCallback invokes the privatelink.UpdateVpcEndpointServiceResourceAttribute API asynchronously
func (client *Client) UpdateVpcEndpointServiceResourceAttributeWithCallback(request *UpdateVpcEndpointServiceResourceAttributeRequest, callback func(response *UpdateVpcEndpointServiceResourceAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateVpcEndpointServiceResourceAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateVpcEndpointServiceResourceAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateVpcEndpointServiceResourceAttributeRequest is the request struct for api UpdateVpcEndpointServiceResourceAttribute
type UpdateVpcEndpointServiceResourceAttributeRequest struct {
	*requests.RpcRequest
	ClientToken          string           `position:"Query" name:"ClientToken"`
	AutoAllocatedEnabled requests.Boolean `position:"Query" name:"AutoAllocatedEnabled"`
	ResourceId           string           `position:"Query" name:"ResourceId"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceType         string           `position:"Query" name:"ResourceType"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
	ServiceId            string           `position:"Query" name:"ServiceId"`
}

// UpdateVpcEndpointServiceResourceAttributeResponse is the response struct for api UpdateVpcEndpointServiceResourceAttribute
type UpdateVpcEndpointServiceResourceAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateVpcEndpointServiceResourceAttributeRequest creates a request to invoke UpdateVpcEndpointServiceResourceAttribute API
func CreateUpdateVpcEndpointServiceResourceAttributeRequest() (request *UpdateVpcEndpointServiceResourceAttributeRequest) {
	request = &UpdateVpcEndpointServiceResourceAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "UpdateVpcEndpointServiceResourceAttribute", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateVpcEndpointServiceResourceAttributeResponse creates a response to parse from UpdateVpcEndpointServiceResourceAttribute response
func CreateUpdateVpcEndpointServiceResourceAttributeResponse() (response *UpdateVpcEndpointServiceResourceAttributeResponse) {
	response = &UpdateVpcEndpointServiceResourceAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
