package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGatewayOnlineRecords invokes the linkwan.ListGatewayOnlineRecords API synchronously
func (client *Client) ListGatewayOnlineRecords(request *ListGatewayOnlineRecordsRequest) (response *ListGatewayOnlineRecordsResponse, err error) {
	response = CreateListGatewayOnlineRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// ListGatewayOnlineRecordsWithChan invokes the linkwan.ListGatewayOnlineRecords API asynchronously
func (client *Client) ListGatewayOnlineRecordsWithChan(request *ListGatewayOnlineRecordsRequest) (<-chan *ListGatewayOnlineRecordsResponse, <-chan error) {
	responseChan := make(chan *ListGatewayOnlineRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGatewayOnlineRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGatewayOnlineRecordsWithCallback invokes the linkwan.ListGatewayOnlineRecords API asynchronously
func (client *Client) ListGatewayOnlineRecordsWithCallback(request *ListGatewayOnlineRecordsRequest, callback func(response *ListGatewayOnlineRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGatewayOnlineRecordsResponse
		var err error
		defer close(result)
		response, err = client.ListGatewayOnlineRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGatewayOnlineRecordsRequest is the request struct for api ListGatewayOnlineRecords
type ListGatewayOnlineRecordsRequest struct {
	*requests.RpcRequest
	Limit        requests.Integer `position:"Query" name:"Limit"`
	OffSet       requests.Integer `position:"Query" name:"OffSet"`
	GwEui        string           `position:"Query" name:"GwEui"`
	Ascending    requests.Boolean `position:"Query" name:"Ascending"`
	ApiProduct   string           `position:"Body" name:"ApiProduct"`
	ApiRevision  string           `position:"Body" name:"ApiRevision"`
	SortingField string           `position:"Query" name:"SortingField"`
}

// ListGatewayOnlineRecordsResponse is the response struct for api ListGatewayOnlineRecords
type ListGatewayOnlineRecordsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListGatewayOnlineRecordsRequest creates a request to invoke ListGatewayOnlineRecords API
func CreateListGatewayOnlineRecordsRequest() (request *ListGatewayOnlineRecordsRequest) {
	request = &ListGatewayOnlineRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "ListGatewayOnlineRecords", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListGatewayOnlineRecordsResponse creates a response to parse from ListGatewayOnlineRecords response
func CreateListGatewayOnlineRecordsResponse() (response *ListGatewayOnlineRecordsResponse) {
	response = &ListGatewayOnlineRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
