package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceOnECSAttribute invokes the gpdb.DescribeDBInstanceOnECSAttribute API synchronously
func (client *Client) DescribeDBInstanceOnECSAttribute(request *DescribeDBInstanceOnECSAttributeRequest) (response *DescribeDBInstanceOnECSAttributeResponse, err error) {
	response = CreateDescribeDBInstanceOnECSAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceOnECSAttributeWithChan invokes the gpdb.DescribeDBInstanceOnECSAttribute API asynchronously
func (client *Client) DescribeDBInstanceOnECSAttributeWithChan(request *DescribeDBInstanceOnECSAttributeRequest) (<-chan *DescribeDBInstanceOnECSAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceOnECSAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceOnECSAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceOnECSAttributeWithCallback invokes the gpdb.DescribeDBInstanceOnECSAttribute API asynchronously
func (client *Client) DescribeDBInstanceOnECSAttributeWithCallback(request *DescribeDBInstanceOnECSAttributeRequest, callback func(response *DescribeDBInstanceOnECSAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceOnECSAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceOnECSAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceOnECSAttributeRequest is the request struct for api DescribeDBInstanceOnECSAttribute
type DescribeDBInstanceOnECSAttributeRequest struct {
	*requests.RpcRequest
	DBInstanceId string           `position:"Query" name:"DBInstanceId"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBInstanceOnECSAttributeResponse is the response struct for api DescribeDBInstanceOnECSAttribute
type DescribeDBInstanceOnECSAttributeResponse struct {
	*responses.BaseResponse
	RequestId string                                  `json:"RequestId" xml:"RequestId"`
	Items     ItemsInDescribeDBInstanceOnECSAttribute `json:"Items" xml:"Items"`
}

// CreateDescribeDBInstanceOnECSAttributeRequest creates a request to invoke DescribeDBInstanceOnECSAttribute API
func CreateDescribeDBInstanceOnECSAttributeRequest() (request *DescribeDBInstanceOnECSAttributeRequest) {
	request = &DescribeDBInstanceOnECSAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeDBInstanceOnECSAttribute", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInstanceOnECSAttributeResponse creates a response to parse from DescribeDBInstanceOnECSAttribute response
func CreateDescribeDBInstanceOnECSAttributeResponse() (response *DescribeDBInstanceOnECSAttributeResponse) {
	response = &DescribeDBInstanceOnECSAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
