package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterOperationHostTask invokes the emr.ListClusterOperationHostTask API synchronously
func (client *Client) ListClusterOperationHostTask(request *ListClusterOperationHostTaskRequest) (response *ListClusterOperationHostTaskResponse, err error) {
	response = CreateListClusterOperationHostTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterOperationHostTaskWithChan invokes the emr.ListClusterOperationHostTask API asynchronously
func (client *Client) ListClusterOperationHostTaskWithChan(request *ListClusterOperationHostTaskRequest) (<-chan *ListClusterOperationHostTaskResponse, <-chan error) {
	responseChan := make(chan *ListClusterOperationHostTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterOperationHostTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterOperationHostTaskWithCallback invokes the emr.ListClusterOperationHostTask API asynchronously
func (client *Client) ListClusterOperationHostTaskWithCallback(request *ListClusterOperationHostTaskRequest, callback func(response *ListClusterOperationHostTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterOperationHostTaskResponse
		var err error
		defer close(result)
		response, err = client.ListClusterOperationHostTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterOperationHostTaskRequest is the request struct for api ListClusterOperationHostTask
type ListClusterOperationHostTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostId          string           `position:"Query" name:"HostId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	OperationId     string           `position:"Query" name:"OperationId"`
	Status          string           `position:"Query" name:"Status"`
}

// ListClusterOperationHostTaskResponse is the response struct for api ListClusterOperationHostTask
type ListClusterOperationHostTaskResponse struct {
	*responses.BaseResponse
	RequestId                    string                       `json:"RequestId" xml:"RequestId"`
	TotalCount                   int                          `json:"TotalCount" xml:"TotalCount"`
	PageNumber                   int                          `json:"PageNumber" xml:"PageNumber"`
	PageSize                     int                          `json:"PageSize" xml:"PageSize"`
	ClusterOperationHostTaskList ClusterOperationHostTaskList `json:"ClusterOperationHostTaskList" xml:"ClusterOperationHostTaskList"`
}

// CreateListClusterOperationHostTaskRequest creates a request to invoke ListClusterOperationHostTask API
func CreateListClusterOperationHostTaskRequest() (request *ListClusterOperationHostTaskRequest) {
	request = &ListClusterOperationHostTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListClusterOperationHostTask", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListClusterOperationHostTaskResponse creates a response to parse from ListClusterOperationHostTask response
func CreateListClusterOperationHostTaskResponse() (response *ListClusterOperationHostTaskResponse) {
	response = &ListClusterOperationHostTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
