package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveMockRule invokes the edas.RemoveMockRule API synchronously
func (client *Client) RemoveMockRule(request *RemoveMockRuleRequest) (response *RemoveMockRuleResponse, err error) {
	response = CreateRemoveMockRuleResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveMockRuleWithChan invokes the edas.RemoveMockRule API asynchronously
func (client *Client) RemoveMockRuleWithChan(request *RemoveMockRuleRequest) (<-chan *RemoveMockRuleResponse, <-chan error) {
	responseChan := make(chan *RemoveMockRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveMockRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveMockRuleWithCallback invokes the edas.RemoveMockRule API asynchronously
func (client *Client) RemoveMockRuleWithCallback(request *RemoveMockRuleRequest, callback func(response *RemoveMockRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveMockRuleResponse
		var err error
		defer close(result)
		response, err = client.RemoveMockRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveMockRuleRequest is the request struct for api RemoveMockRule
type RemoveMockRuleRequest struct {
	*requests.RoaRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// RemoveMockRuleResponse is the response struct for api RemoveMockRule
type RemoveMockRuleResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	HttpCode  string `json:"HttpCode" xml:"HttpCode"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRemoveMockRuleRequest creates a request to invoke RemoveMockRule API
func CreateRemoveMockRuleRequest() (request *RemoveMockRuleRequest) {
	request = &RemoveMockRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "RemoveMockRule", "/pop/sp/api/mock/removeMockRule", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveMockRuleResponse creates a response to parse from RemoveMockRule response
func CreateRemoveMockRuleResponse() (response *RemoveMockRuleResponse) {
	response = &RemoveMockRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
