package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSubscription invokes the dyplsapi.UpdateSubscription API synchronously
func (client *Client) UpdateSubscription(request *UpdateSubscriptionRequest) (response *UpdateSubscriptionResponse, err error) {
	response = CreateUpdateSubscriptionResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSubscriptionWithChan invokes the dyplsapi.UpdateSubscription API asynchronously
func (client *Client) UpdateSubscriptionWithChan(request *UpdateSubscriptionRequest) (<-chan *UpdateSubscriptionResponse, <-chan error) {
	responseChan := make(chan *UpdateSubscriptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSubscription(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSubscriptionWithCallback invokes the dyplsapi.UpdateSubscription API asynchronously
func (client *Client) UpdateSubscriptionWithCallback(request *UpdateSubscriptionRequest, callback func(response *UpdateSubscriptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSubscriptionResponse
		var err error
		defer close(result)
		response, err = client.UpdateSubscription(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSubscriptionRequest is the request struct for api UpdateSubscription
type UpdateSubscriptionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CallDisplayType      requests.Integer `position:"Query" name:"CallDisplayType"`
	ProductType          string           `position:"Query" name:"ProductType"`
	SubsId               string           `position:"Query" name:"SubsId"`
	PhoneNoX             string           `position:"Query" name:"PhoneNoX"`
	RingConfig           string           `position:"Query" name:"RingConfig"`
	ASRStatus            requests.Boolean `position:"Query" name:"ASRStatus"`
	PhoneNoB             string           `position:"Query" name:"PhoneNoB"`
	PhoneNoA             string           `position:"Query" name:"PhoneNoA"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	GroupId              string           `position:"Query" name:"GroupId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
	Expiration           string           `position:"Query" name:"Expiration"`
	OutId                string           `position:"Query" name:"OutId"`
	IsRecordingEnabled   requests.Boolean `position:"Query" name:"IsRecordingEnabled"`
	OperateType          string           `position:"Query" name:"OperateType"`
	ASRModelId           string           `position:"Query" name:"ASRModelId"`
	CallRestrict         string           `position:"Query" name:"CallRestrict"`
}

// UpdateSubscriptionResponse is the response struct for api UpdateSubscription
type UpdateSubscriptionResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateSubscriptionRequest creates a request to invoke UpdateSubscription API
func CreateUpdateSubscriptionRequest() (request *UpdateSubscriptionRequest) {
	request = &UpdateSubscriptionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "UpdateSubscription", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateSubscriptionResponse creates a response to parse from UpdateSubscription response
func CreateUpdateSubscriptionResponse() (response *UpdateSubscriptionResponse) {
	response = &UpdateSubscriptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
