package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSynchronizationJobReplicatorCompare invokes the dts.DescribeSynchronizationJobReplicatorCompare API synchronously
func (client *Client) DescribeSynchronizationJobReplicatorCompare(request *DescribeSynchronizationJobReplicatorCompareRequest) (response *DescribeSynchronizationJobReplicatorCompareResponse, err error) {
	response = CreateDescribeSynchronizationJobReplicatorCompareResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSynchronizationJobReplicatorCompareWithChan invokes the dts.DescribeSynchronizationJobReplicatorCompare API asynchronously
func (client *Client) DescribeSynchronizationJobReplicatorCompareWithChan(request *DescribeSynchronizationJobReplicatorCompareRequest) (<-chan *DescribeSynchronizationJobReplicatorCompareResponse, <-chan error) {
	responseChan := make(chan *DescribeSynchronizationJobReplicatorCompareResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSynchronizationJobReplicatorCompare(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSynchronizationJobReplicatorCompareWithCallback invokes the dts.DescribeSynchronizationJobReplicatorCompare API asynchronously
func (client *Client) DescribeSynchronizationJobReplicatorCompareWithCallback(request *DescribeSynchronizationJobReplicatorCompareRequest, callback func(response *DescribeSynchronizationJobReplicatorCompareResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSynchronizationJobReplicatorCompareResponse
		var err error
		defer close(result)
		response, err = client.DescribeSynchronizationJobReplicatorCompare(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSynchronizationJobReplicatorCompareRequest is the request struct for api DescribeSynchronizationJobReplicatorCompare
type DescribeSynchronizationJobReplicatorCompareRequest struct {
	*requests.RpcRequest
	ClientToken              string `position:"Query" name:"ClientToken"`
	OwnerId                  string `position:"Query" name:"OwnerId"`
	SynchronizationJobId     string `position:"Query" name:"SynchronizationJobId"`
	AccountId                string `position:"Query" name:"AccountId"`
	SynchronizationDirection string `position:"Query" name:"SynchronizationDirection"`
}

// DescribeSynchronizationJobReplicatorCompareResponse is the response struct for api DescribeSynchronizationJobReplicatorCompare
type DescribeSynchronizationJobReplicatorCompareResponse struct {
	*responses.BaseResponse
	SynchronizationReplicatorCompareEnable bool   `json:"SynchronizationReplicatorCompareEnable" xml:"SynchronizationReplicatorCompareEnable"`
	RequestId                              string `json:"RequestId" xml:"RequestId"`
	ErrCode                                string `json:"ErrCode" xml:"ErrCode"`
	Success                                string `json:"Success" xml:"Success"`
	ErrMessage                             string `json:"ErrMessage" xml:"ErrMessage"`
}

// CreateDescribeSynchronizationJobReplicatorCompareRequest creates a request to invoke DescribeSynchronizationJobReplicatorCompare API
func CreateDescribeSynchronizationJobReplicatorCompareRequest() (request *DescribeSynchronizationJobReplicatorCompareRequest) {
	request = &DescribeSynchronizationJobReplicatorCompareRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeSynchronizationJobReplicatorCompare", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSynchronizationJobReplicatorCompareResponse creates a response to parse from DescribeSynchronizationJobReplicatorCompare response
func CreateDescribeSynchronizationJobReplicatorCompareResponse() (response *DescribeSynchronizationJobReplicatorCompareResponse) {
	response = &DescribeSynchronizationJobReplicatorCompareResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
