package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEtlJobLogs invokes the dts.DescribeEtlJobLogs API synchronously
func (client *Client) DescribeEtlJobLogs(request *DescribeEtlJobLogsRequest) (response *DescribeEtlJobLogsResponse, err error) {
	response = CreateDescribeEtlJobLogsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEtlJobLogsWithChan invokes the dts.DescribeEtlJobLogs API asynchronously
func (client *Client) DescribeEtlJobLogsWithChan(request *DescribeEtlJobLogsRequest) (<-chan *DescribeEtlJobLogsResponse, <-chan error) {
	responseChan := make(chan *DescribeEtlJobLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEtlJobLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEtlJobLogsWithCallback invokes the dts.DescribeEtlJobLogs API asynchronously
func (client *Client) DescribeEtlJobLogsWithCallback(request *DescribeEtlJobLogsRequest, callback func(response *DescribeEtlJobLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEtlJobLogsResponse
		var err error
		defer close(result)
		response, err = client.DescribeEtlJobLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEtlJobLogsRequest is the request struct for api DescribeEtlJobLogs
type DescribeEtlJobLogsRequest struct {
	*requests.RpcRequest
	DtsJobId string `position:"Query" name:"DtsJobId"`
}

// DescribeEtlJobLogsResponse is the response struct for api DescribeEtlJobLogs
type DescribeEtlJobLogsResponse struct {
	*responses.BaseResponse
	HttpStatusCode int             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	ErrCode        string          `json:"ErrCode" xml:"ErrCode"`
	Success        bool            `json:"Success" xml:"Success"`
	ErrMessage     string          `json:"ErrMessage" xml:"ErrMessage"`
	DynamicMessage string          `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode    string          `json:"DynamicCode" xml:"DynamicCode"`
	EtlRunningLogs []EtlRunningLog `json:"EtlRunningLogs" xml:"EtlRunningLogs"`
}

// CreateDescribeEtlJobLogsRequest creates a request to invoke DescribeEtlJobLogs API
func CreateDescribeEtlJobLogsRequest() (request *DescribeEtlJobLogsRequest) {
	request = &DescribeEtlJobLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeEtlJobLogs", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEtlJobLogsResponse creates a response to parse from DescribeEtlJobLogs response
func CreateDescribeEtlJobLogsResponse() (response *DescribeEtlJobLogsResponse) {
	response = &DescribeEtlJobLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
