package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveSingleTaskForUpdatingContactInfo invokes the domain.SaveSingleTaskForUpdatingContactInfo API synchronously
func (client *Client) SaveSingleTaskForUpdatingContactInfo(request *SaveSingleTaskForUpdatingContactInfoRequest) (response *SaveSingleTaskForUpdatingContactInfoResponse, err error) {
	response = CreateSaveSingleTaskForUpdatingContactInfoResponse()
	err = client.DoAction(request, response)
	return
}

// SaveSingleTaskForUpdatingContactInfoWithChan invokes the domain.SaveSingleTaskForUpdatingContactInfo API asynchronously
func (client *Client) SaveSingleTaskForUpdatingContactInfoWithChan(request *SaveSingleTaskForUpdatingContactInfoRequest) (<-chan *SaveSingleTaskForUpdatingContactInfoResponse, <-chan error) {
	responseChan := make(chan *SaveSingleTaskForUpdatingContactInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveSingleTaskForUpdatingContactInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveSingleTaskForUpdatingContactInfoWithCallback invokes the domain.SaveSingleTaskForUpdatingContactInfo API asynchronously
func (client *Client) SaveSingleTaskForUpdatingContactInfoWithCallback(request *SaveSingleTaskForUpdatingContactInfoRequest, callback func(response *SaveSingleTaskForUpdatingContactInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveSingleTaskForUpdatingContactInfoResponse
		var err error
		defer close(result)
		response, err = client.SaveSingleTaskForUpdatingContactInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveSingleTaskForUpdatingContactInfoRequest is the request struct for api SaveSingleTaskForUpdatingContactInfo
type SaveSingleTaskForUpdatingContactInfoRequest struct {
	*requests.RpcRequest
	ContactType         string           `position:"Query" name:"ContactType"`
	DomainName          string           `position:"Query" name:"DomainName"`
	RegistrantProfileId requests.Integer `position:"Query" name:"RegistrantProfileId"`
	AddTransferLock     requests.Boolean `position:"Query" name:"AddTransferLock"`
	InstanceId          string           `position:"Query" name:"InstanceId"`
	UserClientIp        string           `position:"Query" name:"UserClientIp"`
	Lang                string           `position:"Query" name:"Lang"`
}

// SaveSingleTaskForUpdatingContactInfoResponse is the response struct for api SaveSingleTaskForUpdatingContactInfo
type SaveSingleTaskForUpdatingContactInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskNo    string `json:"TaskNo" xml:"TaskNo"`
}

// CreateSaveSingleTaskForUpdatingContactInfoRequest creates a request to invoke SaveSingleTaskForUpdatingContactInfo API
func CreateSaveSingleTaskForUpdatingContactInfoRequest() (request *SaveSingleTaskForUpdatingContactInfoRequest) {
	request = &SaveSingleTaskForUpdatingContactInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "SaveSingleTaskForUpdatingContactInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveSingleTaskForUpdatingContactInfoResponse creates a response to parse from SaveSingleTaskForUpdatingContactInfo response
func CreateSaveSingleTaskForUpdatingContactInfoResponse() (response *SaveSingleTaskForUpdatingContactInfoResponse) {
	response = &SaveSingleTaskForUpdatingContactInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
