package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLogicTableRouteConfig invokes the dms_enterprise.AddLogicTableRouteConfig API synchronously
func (client *Client) AddLogicTableRouteConfig(request *AddLogicTableRouteConfigRequest) (response *AddLogicTableRouteConfigResponse, err error) {
	response = CreateAddLogicTableRouteConfigResponse()
	err = client.DoAction(request, response)
	return
}

// AddLogicTableRouteConfigWithChan invokes the dms_enterprise.AddLogicTableRouteConfig API asynchronously
func (client *Client) AddLogicTableRouteConfigWithChan(request *AddLogicTableRouteConfigRequest) (<-chan *AddLogicTableRouteConfigResponse, <-chan error) {
	responseChan := make(chan *AddLogicTableRouteConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLogicTableRouteConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLogicTableRouteConfigWithCallback invokes the dms_enterprise.AddLogicTableRouteConfig API asynchronously
func (client *Client) AddLogicTableRouteConfigWithCallback(request *AddLogicTableRouteConfigRequest, callback func(response *AddLogicTableRouteConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLogicTableRouteConfigResponse
		var err error
		defer close(result)
		response, err = client.AddLogicTableRouteConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLogicTableRouteConfigRequest is the request struct for api AddLogicTableRouteConfig
type AddLogicTableRouteConfigRequest struct {
	*requests.RpcRequest
	RouteKey  string           `position:"Query" name:"RouteKey"`
	Tid       requests.Integer `position:"Query" name:"Tid"`
	RouteExpr string           `position:"Query" name:"RouteExpr"`
	TableId   requests.Integer `position:"Query" name:"TableId"`
}

// AddLogicTableRouteConfigResponse is the response struct for api AddLogicTableRouteConfig
type AddLogicTableRouteConfigResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateAddLogicTableRouteConfigRequest creates a request to invoke AddLogicTableRouteConfig API
func CreateAddLogicTableRouteConfigRequest() (request *AddLogicTableRouteConfigRequest) {
	request = &AddLogicTableRouteConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "AddLogicTableRouteConfig", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddLogicTableRouteConfigResponse creates a response to parse from AddLogicTableRouteConfig response
func CreateAddLogicTableRouteConfigResponse() (response *AddLogicTableRouteConfigResponse) {
	response = &AddLogicTableRouteConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
