package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOrganizations invokes the codeup.ListOrganizations API synchronously
func (client *Client) ListOrganizations(request *ListOrganizationsRequest) (response *ListOrganizationsResponse, err error) {
	response = CreateListOrganizationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListOrganizationsWithChan invokes the codeup.ListOrganizations API asynchronously
func (client *Client) ListOrganizationsWithChan(request *ListOrganizationsRequest) (<-chan *ListOrganizationsResponse, <-chan error) {
	responseChan := make(chan *ListOrganizationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOrganizations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOrganizationsWithCallback invokes the codeup.ListOrganizations API asynchronously
func (client *Client) ListOrganizationsWithCallback(request *ListOrganizationsRequest, callback func(response *ListOrganizationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOrganizationsResponse
		var err error
		defer close(result)
		response, err = client.ListOrganizations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOrganizationsRequest is the request struct for api ListOrganizations
type ListOrganizationsRequest struct {
	*requests.RoaRequest
	AccessLevel    requests.Integer `position:"Query" name:"AccessLevel"`
	MinAccessLevel requests.Integer `position:"Query" name:"MinAccessLevel"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
}

// ListOrganizationsResponse is the response struct for api ListOrganizations
type ListOrganizationsResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	ErrorCode    string       `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool         `json:"Success" xml:"Success"`
	ErrorMessage string       `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       []ResultItem `json:"Result" xml:"Result"`
}

// CreateListOrganizationsRequest creates a request to invoke ListOrganizations API
func CreateListOrganizationsRequest() (request *ListOrganizationsRequest) {
	request = &ListOrganizationsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "ListOrganizations", "/api/v4/organization", "", "")
	request.Method = requests.GET
	return
}

// CreateListOrganizationsResponse creates a response to parse from ListOrganizations response
func CreateListOrganizationsResponse() (response *ListOrganizationsResponse) {
	response = &ListOrganizationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
