package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeContactPoints invokes the cassandra.DescribeContactPoints API synchronously
func (client *Client) DescribeContactPoints(request *DescribeContactPointsRequest) (response *DescribeContactPointsResponse, err error) {
	response = CreateDescribeContactPointsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeContactPointsWithChan invokes the cassandra.DescribeContactPoints API asynchronously
func (client *Client) DescribeContactPointsWithChan(request *DescribeContactPointsRequest) (<-chan *DescribeContactPointsResponse, <-chan error) {
	responseChan := make(chan *DescribeContactPointsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeContactPoints(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeContactPointsWithCallback invokes the cassandra.DescribeContactPoints API asynchronously
func (client *Client) DescribeContactPointsWithCallback(request *DescribeContactPointsRequest, callback func(response *DescribeContactPointsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeContactPointsResponse
		var err error
		defer close(result)
		response, err = client.DescribeContactPoints(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeContactPointsRequest is the request struct for api DescribeContactPoints
type DescribeContactPointsRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DescribeContactPointsResponse is the response struct for api DescribeContactPoints
type DescribeContactPointsResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ContactPoints ContactPoints `json:"ContactPoints" xml:"ContactPoints"`
}

// CreateDescribeContactPointsRequest creates a request to invoke DescribeContactPoints API
func CreateDescribeContactPointsRequest() (request *DescribeContactPointsRequest) {
	request = &DescribeContactPointsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "DescribeContactPoints", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeContactPointsResponse creates a response to parse from DescribeContactPoints response
func CreateDescribeContactPointsResponse() (response *DescribeContactPointsResponse) {
	response = &DescribeContactPointsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
