package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidatePdnsUdpIpSegment invokes the alidns.ValidatePdnsUdpIpSegment API synchronously
func (client *Client) ValidatePdnsUdpIpSegment(request *ValidatePdnsUdpIpSegmentRequest) (response *ValidatePdnsUdpIpSegmentResponse, err error) {
	response = CreateValidatePdnsUdpIpSegmentResponse()
	err = client.DoAction(request, response)
	return
}

// ValidatePdnsUdpIpSegmentWithChan invokes the alidns.ValidatePdnsUdpIpSegment API asynchronously
func (client *Client) ValidatePdnsUdpIpSegmentWithChan(request *ValidatePdnsUdpIpSegmentRequest) (<-chan *ValidatePdnsUdpIpSegmentResponse, <-chan error) {
	responseChan := make(chan *ValidatePdnsUdpIpSegmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidatePdnsUdpIpSegment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidatePdnsUdpIpSegmentWithCallback invokes the alidns.ValidatePdnsUdpIpSegment API asynchronously
func (client *Client) ValidatePdnsUdpIpSegmentWithCallback(request *ValidatePdnsUdpIpSegmentRequest, callback func(response *ValidatePdnsUdpIpSegmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidatePdnsUdpIpSegmentResponse
		var err error
		defer close(result)
		response, err = client.ValidatePdnsUdpIpSegment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidatePdnsUdpIpSegmentRequest is the request struct for api ValidatePdnsUdpIpSegment
type ValidatePdnsUdpIpSegmentRequest struct {
	*requests.RpcRequest
	Ip   string `position:"Query" name:"Ip"`
	Lang string `position:"Query" name:"Lang"`
}

// ValidatePdnsUdpIpSegmentResponse is the response struct for api ValidatePdnsUdpIpSegment
type ValidatePdnsUdpIpSegmentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateValidatePdnsUdpIpSegmentRequest creates a request to invoke ValidatePdnsUdpIpSegment API
func CreateValidatePdnsUdpIpSegmentRequest() (request *ValidatePdnsUdpIpSegmentRequest) {
	request = &ValidatePdnsUdpIpSegmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "ValidatePdnsUdpIpSegment", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateValidatePdnsUdpIpSegmentResponse creates a response to parse from ValidatePdnsUdpIpSegment response
func CreateValidatePdnsUdpIpSegmentResponse() (response *ValidatePdnsUdpIpSegmentResponse) {
	response = &ValidatePdnsUdpIpSegmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
