package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableDeletionProtection invokes the alb.EnableDeletionProtection API synchronously
func (client *Client) EnableDeletionProtection(request *EnableDeletionProtectionRequest) (response *EnableDeletionProtectionResponse, err error) {
	response = CreateEnableDeletionProtectionResponse()
	err = client.DoAction(request, response)
	return
}

// EnableDeletionProtectionWithChan invokes the alb.EnableDeletionProtection API asynchronously
func (client *Client) EnableDeletionProtectionWithChan(request *EnableDeletionProtectionRequest) (<-chan *EnableDeletionProtectionResponse, <-chan error) {
	responseChan := make(chan *EnableDeletionProtectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableDeletionProtection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableDeletionProtectionWithCallback invokes the alb.EnableDeletionProtection API asynchronously
func (client *Client) EnableDeletionProtectionWithCallback(request *EnableDeletionProtectionRequest, callback func(response *EnableDeletionProtectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableDeletionProtectionResponse
		var err error
		defer close(result)
		response, err = client.EnableDeletionProtection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableDeletionProtectionRequest is the request struct for api EnableDeletionProtection
type EnableDeletionProtectionRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Query" name:"ClientToken"`
	ResourceId  string           `position:"Query" name:"ResourceId"`
	DryRun      requests.Boolean `position:"Query" name:"DryRun"`
}

// EnableDeletionProtectionResponse is the response struct for api EnableDeletionProtection
type EnableDeletionProtectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableDeletionProtectionRequest creates a request to invoke EnableDeletionProtection API
func CreateEnableDeletionProtectionRequest() (request *EnableDeletionProtectionRequest) {
	request = &EnableDeletionProtectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "EnableDeletionProtection", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableDeletionProtectionResponse creates a response to parse from EnableDeletionProtection response
func CreateEnableDeletionProtectionResponse() (response *EnableDeletionProtectionResponse) {
	response = &EnableDeletionProtectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
