package artifactsapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/synapse/2019-06-01-preview/artifacts"
	"github.com/Azure/go-autorest/autorest"
)

// LinkedServiceClientAPI contains the set of methods on the LinkedServiceClient type.
type LinkedServiceClientAPI interface {
	CreateOrUpdateLinkedService(ctx context.Context, linkedServiceName string, linkedService artifacts.LinkedServiceResource, ifMatch string) (result artifacts.LinkedServiceResource, err error)
	DeleteLinkedService(ctx context.Context, linkedServiceName string) (result autorest.Response, err error)
	GetLinkedService(ctx context.Context, linkedServiceName string, ifNoneMatch string) (result artifacts.LinkedServiceResource, err error)
	GetLinkedServicesByWorkspace(ctx context.Context) (result artifacts.LinkedServiceListResponsePage, err error)
	GetLinkedServicesByWorkspaceComplete(ctx context.Context) (result artifacts.LinkedServiceListResponseIterator, err error)
}

var _ LinkedServiceClientAPI = (*artifacts.LinkedServiceClient)(nil)

// DatasetClientAPI contains the set of methods on the DatasetClient type.
type DatasetClientAPI interface {
	CreateOrUpdateDataset(ctx context.Context, datasetName string, dataset artifacts.DatasetResource, ifMatch string) (result artifacts.DatasetResource, err error)
	DeleteDataset(ctx context.Context, datasetName string) (result autorest.Response, err error)
	GetDataset(ctx context.Context, datasetName string, ifNoneMatch string) (result artifacts.DatasetResource, err error)
	GetDatasetsByWorkspace(ctx context.Context) (result artifacts.DatasetListResponsePage, err error)
	GetDatasetsByWorkspaceComplete(ctx context.Context) (result artifacts.DatasetListResponseIterator, err error)
}

var _ DatasetClientAPI = (*artifacts.DatasetClient)(nil)

// PipelineClientAPI contains the set of methods on the PipelineClient type.
type PipelineClientAPI interface {
	CreateOrUpdatePipeline(ctx context.Context, pipelineName string, pipeline artifacts.PipelineResource, ifMatch string) (result artifacts.PipelineResource, err error)
	CreatePipelineRun(ctx context.Context, pipelineName string, referencePipelineRunID string, isRecovery *bool, startActivityName string, parameters map[string]interface{}) (result artifacts.CreateRunResponse, err error)
	DeletePipeline(ctx context.Context, pipelineName string) (result autorest.Response, err error)
	GetPipeline(ctx context.Context, pipelineName string, ifNoneMatch string) (result artifacts.PipelineResource, err error)
	GetPipelinesByWorkspace(ctx context.Context) (result artifacts.PipelineListResponsePage, err error)
	GetPipelinesByWorkspaceComplete(ctx context.Context) (result artifacts.PipelineListResponseIterator, err error)
}

var _ PipelineClientAPI = (*artifacts.PipelineClient)(nil)

// PipelineRunClientAPI contains the set of methods on the PipelineRunClient type.
type PipelineRunClientAPI interface {
	CancelPipelineRun(ctx context.Context, runID string, isRecursive *bool) (result autorest.Response, err error)
	GetPipelineRun(ctx context.Context, runID string) (result artifacts.PipelineRun, err error)
	QueryActivityRuns(ctx context.Context, pipelineName string, runID string, filterParameters artifacts.RunFilterParameters) (result artifacts.ActivityRunsQueryResponse, err error)
	QueryPipelineRunsByWorkspace(ctx context.Context, filterParameters artifacts.RunFilterParameters) (result artifacts.PipelineRunsQueryResponse, err error)
}

var _ PipelineRunClientAPI = (*artifacts.PipelineRunClient)(nil)

// TriggerClientAPI contains the set of methods on the TriggerClient type.
type TriggerClientAPI interface {
	CreateOrUpdateTrigger(ctx context.Context, triggerName string, trigger artifacts.TriggerResource, ifMatch string) (result artifacts.TriggerResource, err error)
	DeleteTrigger(ctx context.Context, triggerName string) (result autorest.Response, err error)
	GetEventSubscriptionStatus(ctx context.Context, triggerName string) (result artifacts.TriggerSubscriptionOperationStatus, err error)
	GetTrigger(ctx context.Context, triggerName string, ifNoneMatch string) (result artifacts.TriggerResource, err error)
	GetTriggersByWorkspace(ctx context.Context) (result artifacts.TriggerListResponsePage, err error)
	GetTriggersByWorkspaceComplete(ctx context.Context) (result artifacts.TriggerListResponseIterator, err error)
	StartTrigger(ctx context.Context, triggerName string) (result artifacts.TriggerStartTriggerFuture, err error)
	StopTrigger(ctx context.Context, triggerName string) (result artifacts.TriggerStopTriggerFuture, err error)
	SubscribeTriggerToEvents(ctx context.Context, triggerName string) (result artifacts.TriggerSubscribeTriggerToEventsFuture, err error)
	UnsubscribeTriggerFromEvents(ctx context.Context, triggerName string) (result artifacts.TriggerUnsubscribeTriggerFromEventsFuture, err error)
}

var _ TriggerClientAPI = (*artifacts.TriggerClient)(nil)

// TriggerRunClientAPI contains the set of methods on the TriggerRunClient type.
type TriggerRunClientAPI interface {
	CancelTriggerInstance(ctx context.Context, triggerName string, runID string) (result autorest.Response, err error)
	QueryTriggerRunsByWorkspace(ctx context.Context, filterParameters artifacts.RunFilterParameters) (result artifacts.TriggerRunsQueryResponse, err error)
	RerunTriggerInstance(ctx context.Context, triggerName string, runID string) (result autorest.Response, err error)
}

var _ TriggerRunClientAPI = (*artifacts.TriggerRunClient)(nil)

// DataFlowClientAPI contains the set of methods on the DataFlowClient type.
type DataFlowClientAPI interface {
	CreateOrUpdateDataFlow(ctx context.Context, dataFlowName string, dataFlow artifacts.DataFlowResource, ifMatch string) (result artifacts.DataFlowResource, err error)
	DeleteDataFlow(ctx context.Context, dataFlowName string) (result autorest.Response, err error)
	GetDataFlow(ctx context.Context, dataFlowName string, ifNoneMatch string) (result artifacts.DataFlowResource, err error)
	GetDataFlowsByWorkspace(ctx context.Context) (result artifacts.DataFlowListResponsePage, err error)
	GetDataFlowsByWorkspaceComplete(ctx context.Context) (result artifacts.DataFlowListResponseIterator, err error)
}

var _ DataFlowClientAPI = (*artifacts.DataFlowClient)(nil)

// DataFlowDebugSessionClientAPI contains the set of methods on the DataFlowDebugSessionClient type.
type DataFlowDebugSessionClientAPI interface {
	AddDataFlow(ctx context.Context, request artifacts.DataFlowDebugPackage) (result artifacts.AddDataFlowToDebugSessionResponse, err error)
	CreateDataFlowDebugSession(ctx context.Context, request artifacts.CreateDataFlowDebugSessionRequest) (result artifacts.DataFlowDebugSessionCreateDataFlowDebugSessionFuture, err error)
	DeleteDataFlowDebugSession(ctx context.Context, request artifacts.DeleteDataFlowDebugSessionRequest) (result autorest.Response, err error)
	ExecuteCommand(ctx context.Context, request artifacts.DataFlowDebugCommandRequest) (result artifacts.DataFlowDebugSessionExecuteCommandFuture, err error)
	QueryDataFlowDebugSessionsByWorkspace(ctx context.Context) (result artifacts.QueryDataFlowDebugSessionsResponsePage, err error)
	QueryDataFlowDebugSessionsByWorkspaceComplete(ctx context.Context) (result artifacts.QueryDataFlowDebugSessionsResponseIterator, err error)
}

var _ DataFlowDebugSessionClientAPI = (*artifacts.DataFlowDebugSessionClient)(nil)

// SQLScriptClientAPI contains the set of methods on the SQLScriptClient type.
type SQLScriptClientAPI interface {
	CreateOrUpdateSQLScript(ctx context.Context, SQLScriptName string, SQLScript artifacts.SQLScriptResource, ifMatch string) (result artifacts.SQLScriptResource, err error)
	DeleteSQLScript(ctx context.Context, SQLScriptName string) (result autorest.Response, err error)
	GetSQLScript(ctx context.Context, SQLScriptName string, ifNoneMatch string) (result artifacts.SQLScriptResource, err error)
	GetSQLScriptsByWorkspace(ctx context.Context) (result artifacts.SQLScriptsListResponsePage, err error)
	GetSQLScriptsByWorkspaceComplete(ctx context.Context) (result artifacts.SQLScriptsListResponseIterator, err error)
}

var _ SQLScriptClientAPI = (*artifacts.SQLScriptClient)(nil)

// SparkJobDefinitionClientAPI contains the set of methods on the SparkJobDefinitionClient type.
type SparkJobDefinitionClientAPI interface {
	CreateOrUpdateSparkJobDefinition(ctx context.Context, sparkJobDefinitionName string, sparkJobDefinition artifacts.SparkJobDefinitionResource, ifMatch string) (result artifacts.SparkJobDefinitionResource, err error)
	DebugSparkJobDefinition(ctx context.Context, sparkJobDefinitionAzureResource artifacts.SparkJobDefinitionResource) (result artifacts.SparkJobDefinitionDebugSparkJobDefinitionFuture, err error)
	DeleteSparkJobDefinition(ctx context.Context, sparkJobDefinitionName string) (result autorest.Response, err error)
	ExecuteSparkJobDefinition(ctx context.Context, sparkJobDefinitionName string) (result artifacts.SparkJobDefinitionExecuteSparkJobDefinitionFuture, err error)
	GetSparkJobDefinition(ctx context.Context, sparkJobDefinitionName string, ifNoneMatch string) (result artifacts.SparkJobDefinitionResource, err error)
	GetSparkJobDefinitionsByWorkspace(ctx context.Context) (result artifacts.SparkJobDefinitionsListResponsePage, err error)
	GetSparkJobDefinitionsByWorkspaceComplete(ctx context.Context) (result artifacts.SparkJobDefinitionsListResponseIterator, err error)
}

var _ SparkJobDefinitionClientAPI = (*artifacts.SparkJobDefinitionClient)(nil)

// NotebookClientAPI contains the set of methods on the NotebookClient type.
type NotebookClientAPI interface {
	CreateOrUpdateNotebook(ctx context.Context, notebookName string, notebook artifacts.NotebookResource, ifMatch string) (result artifacts.NotebookResource, err error)
	DeleteNotebook(ctx context.Context, notebookName string) (result autorest.Response, err error)
	GetNotebook(ctx context.Context, notebookName string, ifNoneMatch string) (result artifacts.NotebookResource, err error)
	GetNotebooksByWorkspace(ctx context.Context) (result artifacts.NotebookListResponsePage, err error)
	GetNotebooksByWorkspaceComplete(ctx context.Context) (result artifacts.NotebookListResponseIterator, err error)
	GetNotebookSummaryByWorkSpace(ctx context.Context) (result artifacts.NotebookListResponsePage, err error)
	GetNotebookSummaryByWorkSpaceComplete(ctx context.Context) (result artifacts.NotebookListResponseIterator, err error)
}

var _ NotebookClientAPI = (*artifacts.NotebookClient)(nil)
