package hybridnetwork

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// VendorVirtualNetworkFunctionsClient is the client for the VendorVirtualNetworkFunctions methods of the Hybridnetwork
// service.
type VendorVirtualNetworkFunctionsClient struct {
	BaseClient
}

// NewVendorVirtualNetworkFunctionsClient creates an instance of the VendorVirtualNetworkFunctionsClient client.
func NewVendorVirtualNetworkFunctionsClient(subscriptionID string) VendorVirtualNetworkFunctionsClient {
	return NewVendorVirtualNetworkFunctionsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewVendorVirtualNetworkFunctionsClientWithBaseURI creates an instance of the VendorVirtualNetworkFunctionsClient
// client using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI
// (sovereign clouds, Azure stack).
func NewVendorVirtualNetworkFunctionsClientWithBaseURI(baseURI string, subscriptionID string) VendorVirtualNetworkFunctionsClient {
	return VendorVirtualNetworkFunctionsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate create or update a virtual network function.
// Parameters:
// locationName - the azure region where the virtual network function resource was created by customer.
// vendorName - the name of the vendor.
// serviceKey - the unique GUID for the virtual network function.
// parameters - parameters supplied to the update vendor virtual network function.
func (client VendorVirtualNetworkFunctionsClient) CreateOrUpdate(ctx context.Context, locationName string, vendorName string, serviceKey string, parameters VendorVirtualNetworkFunction) (result VendorVirtualNetworkFunctionsCreateOrUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorVirtualNetworkFunctionsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdatePreparer(ctx, locationName, vendorName, serviceKey, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorVirtualNetworkFunctionsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorVirtualNetworkFunctionsClient", "CreateOrUpdate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client VendorVirtualNetworkFunctionsClient) CreateOrUpdatePreparer(ctx context.Context, locationName string, vendorName string, serviceKey string, parameters VendorVirtualNetworkFunction) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":   autorest.Encode("path", locationName),
		"serviceKey":     autorest.Encode("path", serviceKey),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
		"vendorName":     autorest.Encode("path", vendorName),
	}

	const APIVersion = "2020-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.HybridNetwork/locations/{locationName}/vendors/{vendorName}/virtualNetworkFunctions/{serviceKey}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client VendorVirtualNetworkFunctionsClient) CreateOrUpdateSender(req *http.Request) (future VendorVirtualNetworkFunctionsCreateOrUpdateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client VendorVirtualNetworkFunctionsClient) CreateOrUpdateResponder(resp *http.Response) (result VendorVirtualNetworkFunction, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get gets information about the specified virtual network function.
// Parameters:
// locationName - the azure region where the virtual network function sub resource was created by customer.
// vendorName - the name of the vendor.
// serviceKey - the unique GUID for the virtual network function.
func (client VendorVirtualNetworkFunctionsClient) Get(ctx context.Context, locationName string, vendorName string, serviceKey string) (result VendorVirtualNetworkFunction, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorVirtualNetworkFunctionsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, locationName, vendorName, serviceKey)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorVirtualNetworkFunctionsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorVirtualNetworkFunctionsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorVirtualNetworkFunctionsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client VendorVirtualNetworkFunctionsClient) GetPreparer(ctx context.Context, locationName string, vendorName string, serviceKey string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":   autorest.Encode("path", locationName),
		"serviceKey":     autorest.Encode("path", serviceKey),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
		"vendorName":     autorest.Encode("path", vendorName),
	}

	const APIVersion = "2020-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.HybridNetwork/locations/{locationName}/vendors/{vendorName}/virtualNetworkFunctions/{serviceKey}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client VendorVirtualNetworkFunctionsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client VendorVirtualNetworkFunctionsClient) GetResponder(resp *http.Response) (result VendorVirtualNetworkFunction, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List list all the vendor virtual network function sub resources in an azure region. Filter by skuType, skuName,
// vendorProvisioningState
// Parameters:
// locationName - the azure region where the virtual network function resource was created by customer.
// vendorName - the name of the vendor.
// filter - the filter to apply on the operation. The properties you can use for eq (equals) are: skuType,
// skuName and vendorProvisioningState.
func (client VendorVirtualNetworkFunctionsClient) List(ctx context.Context, locationName string, vendorName string, filter string) (result VendorVirtualNetworkFunctionListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorVirtualNetworkFunctionsClient.List")
		defer func() {
			sc := -1
			if result.vvnflr.Response.Response != nil {
				sc = result.vvnflr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, locationName, vendorName, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorVirtualNetworkFunctionsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.vvnflr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorVirtualNetworkFunctionsClient", "List", resp, "Failure sending request")
		return
	}

	result.vvnflr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorVirtualNetworkFunctionsClient", "List", resp, "Failure responding to request")
	}
	if result.vvnflr.hasNextLink() && result.vvnflr.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListPreparer prepares the List request.
func (client VendorVirtualNetworkFunctionsClient) ListPreparer(ctx context.Context, locationName string, vendorName string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":   autorest.Encode("path", locationName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
		"vendorName":     autorest.Encode("path", vendorName),
	}

	const APIVersion = "2020-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.HybridNetwork/locations/{locationName}/vendors/{vendorName}/virtualNetworkFunctions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client VendorVirtualNetworkFunctionsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client VendorVirtualNetworkFunctionsClient) ListResponder(resp *http.Response) (result VendorVirtualNetworkFunctionListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client VendorVirtualNetworkFunctionsClient) listNextResults(ctx context.Context, lastResults VendorVirtualNetworkFunctionListResult) (result VendorVirtualNetworkFunctionListResult, err error) {
	req, err := lastResults.vendorVirtualNetworkFunctionListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "hybridnetwork.VendorVirtualNetworkFunctionsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "hybridnetwork.VendorVirtualNetworkFunctionsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorVirtualNetworkFunctionsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client VendorVirtualNetworkFunctionsClient) ListComplete(ctx context.Context, locationName string, vendorName string, filter string) (result VendorVirtualNetworkFunctionListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorVirtualNetworkFunctionsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, locationName, vendorName, filter)
	return
}
