package healthcareapis

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// Kind enumerates the values for kind.
type Kind string

const (
	// Fhir ...
	Fhir Kind = "fhir"
	// FhirR4 ...
	FhirR4 Kind = "fhir-R4"
	// FhirStu3 ...
	FhirStu3 Kind = "fhir-Stu3"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{Fhir, FhirR4, FhirStu3}
}

// OperationResultStatus enumerates the values for operation result status.
type OperationResultStatus string

const (
	// Canceled ...
	Canceled OperationResultStatus = "Canceled"
	// Failed ...
	Failed OperationResultStatus = "Failed"
	// Requested ...
	Requested OperationResultStatus = "Requested"
	// Running ...
	Running OperationResultStatus = "Running"
	// Succeeded ...
	Succeeded OperationResultStatus = "Succeeded"
)

// PossibleOperationResultStatusValues returns an array of possible values for the OperationResultStatus const type.
func PossibleOperationResultStatusValues() []OperationResultStatus {
	return []OperationResultStatus{Canceled, Failed, Requested, Running, Succeeded}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateAccepted ...
	ProvisioningStateAccepted ProvisioningState = "Accepted"
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateDeprovisioned ...
	ProvisioningStateDeprovisioned ProvisioningState = "Deprovisioned"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
	// ProvisioningStateVerifying ...
	ProvisioningStateVerifying ProvisioningState = "Verifying"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateAccepted, ProvisioningStateCanceled, ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateDeprovisioned, ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUpdating, ProvisioningStateVerifying}
}

// ServiceNameUnavailabilityReason enumerates the values for service name unavailability reason.
type ServiceNameUnavailabilityReason string

const (
	// AlreadyExists ...
	AlreadyExists ServiceNameUnavailabilityReason = "AlreadyExists"
	// Invalid ...
	Invalid ServiceNameUnavailabilityReason = "Invalid"
)

// PossibleServiceNameUnavailabilityReasonValues returns an array of possible values for the ServiceNameUnavailabilityReason const type.
func PossibleServiceNameUnavailabilityReasonValues() []ServiceNameUnavailabilityReason {
	return []ServiceNameUnavailabilityReason{AlreadyExists, Invalid}
}
