package cognitiveservices

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// KeyName enumerates the values for key name.
type KeyName string

const (
	// Key1 ...
	Key1 KeyName = "Key1"
	// Key2 ...
	Key2 KeyName = "Key2"
)

// PossibleKeyNameValues returns an array of possible values for the KeyName const type.
func PossibleKeyNameValues() []KeyName {
	return []KeyName{Key1, Key2}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// Academic ...
	Academic Kind = "Academic"
	// BingAutosuggest ...
	BingAutosuggest Kind = "Bing.Autosuggest"
	// BingSearch ...
	BingSearch Kind = "Bing.Search"
	// BingSpeech ...
	BingSpeech Kind = "Bing.Speech"
	// BingSpellCheck ...
	BingSpellCheck Kind = "Bing.SpellCheck"
	// ComputerVision ...
	ComputerVision Kind = "ComputerVision"
	// ContentModerator ...
	ContentModerator Kind = "ContentModerator"
	// Emotion ...
	Emotion Kind = "Emotion"
	// Face ...
	Face Kind = "Face"
	// LUIS ...
	LUIS Kind = "LUIS"
	// Recommendations ...
	Recommendations Kind = "Recommendations"
	// SpeakerRecognition ...
	SpeakerRecognition Kind = "SpeakerRecognition"
	// Speech ...
	Speech Kind = "Speech"
	// SpeechTranslation ...
	SpeechTranslation Kind = "SpeechTranslation"
	// TextAnalytics ...
	TextAnalytics Kind = "TextAnalytics"
	// TextTranslation ...
	TextTranslation Kind = "TextTranslation"
	// WebLM ...
	WebLM Kind = "WebLM"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{Academic, BingAutosuggest, BingSearch, BingSpeech, BingSpellCheck, ComputerVision, ContentModerator, Emotion, Face, LUIS, Recommendations, SpeakerRecognition, Speech, SpeechTranslation, TextAnalytics, TextTranslation, WebLM}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// ResolvingDNS ...
	ResolvingDNS ProvisioningState = "ResolvingDNS"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Creating, Failed, ResolvingDNS, Succeeded}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// F0 ...
	F0 SkuName = "F0"
	// P0 ...
	P0 SkuName = "P0"
	// P1 ...
	P1 SkuName = "P1"
	// P2 ...
	P2 SkuName = "P2"
	// S0 ...
	S0 SkuName = "S0"
	// S1 ...
	S1 SkuName = "S1"
	// S2 ...
	S2 SkuName = "S2"
	// S3 ...
	S3 SkuName = "S3"
	// S4 ...
	S4 SkuName = "S4"
	// S5 ...
	S5 SkuName = "S5"
	// S6 ...
	S6 SkuName = "S6"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{F0, P0, P1, P2, S0, S1, S2, S3, S4, S5, S6}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// Free ...
	Free SkuTier = "Free"
	// Premium ...
	Premium SkuTier = "Premium"
	// Standard ...
	Standard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{Free, Premium, Standard}
}
