package consumption

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"github.com/shopspring/decimal"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/consumption/mgmt/2018-08-31/consumption"

// Balance a balance resource.
type Balance struct {
	autorest.Response  `json:"-"`
	*BalanceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Balance.
func (b Balance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.BalanceProperties != nil {
		objectMap["properties"] = b.BalanceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Balance struct.
func (b *Balance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var balanceProperties BalanceProperties
				err = json.Unmarshal(*v, &balanceProperties)
				if err != nil {
					return err
				}
				b.BalanceProperties = &balanceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				b.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				b.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				b.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				b.Tags = tags
			}
		}
	}

	return nil
}

// BalanceProperties the properties of the balance.
type BalanceProperties struct {
	// Currency - READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string `json:"currency,omitempty"`
	// BeginningBalance - READ-ONLY; The beginning balance for the billing period.
	BeginningBalance *decimal.Decimal `json:"beginningBalance,omitempty"`
	// EndingBalance - READ-ONLY; The ending balance for the billing period (for open periods this will be updated daily).
	EndingBalance *decimal.Decimal `json:"endingBalance,omitempty"`
	// NewPurchases - READ-ONLY; Total new purchase amount.
	NewPurchases *decimal.Decimal `json:"newPurchases,omitempty"`
	// Adjustments - READ-ONLY; Total adjustment amount.
	Adjustments *decimal.Decimal `json:"adjustments,omitempty"`
	// Utilized - READ-ONLY; Total Commitment usage.
	Utilized *decimal.Decimal `json:"utilized,omitempty"`
	// ServiceOverage - READ-ONLY; Overage for Azure services.
	ServiceOverage *decimal.Decimal `json:"serviceOverage,omitempty"`
	// ChargesBilledSeparately - READ-ONLY; Charges Billed separately.
	ChargesBilledSeparately *decimal.Decimal `json:"chargesBilledSeparately,omitempty"`
	// TotalOverage - READ-ONLY; serviceOverage + chargesBilledSeparately.
	TotalOverage *decimal.Decimal `json:"totalOverage,omitempty"`
	// TotalUsage - READ-ONLY; Azure service commitment + total Overage.
	TotalUsage *decimal.Decimal `json:"totalUsage,omitempty"`
	// AzureMarketplaceServiceCharges - READ-ONLY; Total charges for Azure Marketplace.
	AzureMarketplaceServiceCharges *decimal.Decimal `json:"azureMarketplaceServiceCharges,omitempty"`
	// BillingFrequency - The billing frequency. Possible values include: 'Month', 'Quarter', 'Year'
	BillingFrequency BillingFrequency `json:"billingFrequency,omitempty"`
	// PriceHidden - READ-ONLY; Price is hidden or not.
	PriceHidden *bool `json:"priceHidden,omitempty"`
	// NewPurchasesDetails - READ-ONLY; List of new purchases.
	NewPurchasesDetails *[]BalancePropertiesNewPurchasesDetailsItem `json:"newPurchasesDetails,omitempty"`
	// AdjustmentDetails - READ-ONLY; List of Adjustments (Promo credit, SIE credit etc.).
	AdjustmentDetails *[]BalancePropertiesAdjustmentDetailsItem `json:"adjustmentDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for BalanceProperties.
func (bp BalanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bp.BillingFrequency != "" {
		objectMap["billingFrequency"] = bp.BillingFrequency
	}
	return json.Marshal(objectMap)
}

// BalancePropertiesAdjustmentDetailsItem ...
type BalancePropertiesAdjustmentDetailsItem struct {
	// Name - READ-ONLY; the name of new adjustment.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; the value of new adjustment.
	Value *decimal.Decimal `json:"value,omitempty"`
}

// BalancePropertiesNewPurchasesDetailsItem ...
type BalancePropertiesNewPurchasesDetailsItem struct {
	// Name - READ-ONLY; the name of new purchase.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; the value of new purchase.
	Value *decimal.Decimal `json:"value,omitempty"`
}

// Budget a budget resource.
type Budget struct {
	autorest.Response `json:"-"`
	*BudgetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ETag - eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for Budget.
func (b Budget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.BudgetProperties != nil {
		objectMap["properties"] = b.BudgetProperties
	}
	if b.ETag != nil {
		objectMap["eTag"] = b.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Budget struct.
func (b *Budget) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var budgetProperties BudgetProperties
				err = json.Unmarshal(*v, &budgetProperties)
				if err != nil {
					return err
				}
				b.BudgetProperties = &budgetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				b.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				b.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				b.Type = &typeVar
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				b.ETag = &eTag
			}
		}
	}

	return nil
}

// BudgetProperties the properties of the budget.
type BudgetProperties struct {
	// Category - The category of the budget, whether the budget tracks cost or usage. Possible values include: 'Cost', 'Usage'
	Category CategoryType `json:"category,omitempty"`
	// Amount - The total amount of cost to track with the budget
	Amount *decimal.Decimal `json:"amount,omitempty"`
	// TimeGrain - The time covered by a budget. Tracking of the amount will be reset based on the time grain. Possible values include: 'TimeGrainTypeMonthly', 'TimeGrainTypeQuarterly', 'TimeGrainTypeAnnually'
	TimeGrain TimeGrainType `json:"timeGrain,omitempty"`
	// TimePeriod - Has start and end date of the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than three months. Past start date should  be selected within the timegrain period. There are no restrictions on the end date.
	TimePeriod *BudgetTimePeriod `json:"timePeriod,omitempty"`
	// Filters - May be used to filter budgets by resource group, resource, or meter.
	Filters *Filters `json:"filters,omitempty"`
	// CurrentSpend - READ-ONLY; The current amount of cost which is being tracked for a budget.
	CurrentSpend *CurrentSpend `json:"currentSpend,omitempty"`
	// Notifications - Dictionary of notifications associated with the budget. Budget can have up to five notifications.
	Notifications map[string]*Notification `json:"notifications"`
}

// MarshalJSON is the custom marshaler for BudgetProperties.
func (bp BudgetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bp.Category != "" {
		objectMap["category"] = bp.Category
	}
	if bp.Amount != nil {
		objectMap["amount"] = bp.Amount
	}
	if bp.TimeGrain != "" {
		objectMap["timeGrain"] = bp.TimeGrain
	}
	if bp.TimePeriod != nil {
		objectMap["timePeriod"] = bp.TimePeriod
	}
	if bp.Filters != nil {
		objectMap["filters"] = bp.Filters
	}
	if bp.Notifications != nil {
		objectMap["notifications"] = bp.Notifications
	}
	return json.Marshal(objectMap)
}

// BudgetsListResult result of listing budgets. It contains a list of available budgets in the scope provided.
type BudgetsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of budgets.
	Value *[]Budget `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BudgetsListResultIterator provides access to a complete listing of Budget values.
type BudgetsListResultIterator struct {
	i    int
	page BudgetsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BudgetsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BudgetsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BudgetsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BudgetsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BudgetsListResultIterator) Response() BudgetsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BudgetsListResultIterator) Value() Budget {
	if !iter.page.NotDone() {
		return Budget{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BudgetsListResultIterator type.
func NewBudgetsListResultIterator(page BudgetsListResultPage) BudgetsListResultIterator {
	return BudgetsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (blr BudgetsListResult) IsEmpty() bool {
	return blr.Value == nil || len(*blr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (blr BudgetsListResult) hasNextLink() bool {
	return blr.NextLink != nil && len(*blr.NextLink) != 0
}

// budgetsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (blr BudgetsListResult) budgetsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !blr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(blr.NextLink)))
}

// BudgetsListResultPage contains a page of Budget values.
type BudgetsListResultPage struct {
	fn  func(context.Context, BudgetsListResult) (BudgetsListResult, error)
	blr BudgetsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BudgetsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BudgetsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.blr)
		if err != nil {
			return err
		}
		page.blr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BudgetsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BudgetsListResultPage) NotDone() bool {
	return !page.blr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BudgetsListResultPage) Response() BudgetsListResult {
	return page.blr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BudgetsListResultPage) Values() []Budget {
	if page.blr.IsEmpty() {
		return nil
	}
	return *page.blr.Value
}

// Creates a new instance of the BudgetsListResultPage type.
func NewBudgetsListResultPage(getNextPage func(context.Context, BudgetsListResult) (BudgetsListResult, error)) BudgetsListResultPage {
	return BudgetsListResultPage{fn: getNextPage}
}

// BudgetTimePeriod the start and end date for a budget.
type BudgetTimePeriod struct {
	// StartDate - The start date for the budget.
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - The end date for the budget. If not provided, we default this to 10 years from the start date.
	EndDate *date.Time `json:"endDate,omitempty"`
}

// ChargesListResult result of listing charge summary.
type ChargesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of charge summary
	Value *[]ChargeSummary `json:"value,omitempty"`
}

// ChargeSummary a charge summary resource.
type ChargeSummary struct {
	autorest.Response        `json:"-"`
	*ChargeSummaryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ChargeSummary.
func (cs ChargeSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cs.ChargeSummaryProperties != nil {
		objectMap["properties"] = cs.ChargeSummaryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ChargeSummary struct.
func (cs *ChargeSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var chargeSummaryProperties ChargeSummaryProperties
				err = json.Unmarshal(*v, &chargeSummaryProperties)
				if err != nil {
					return err
				}
				cs.ChargeSummaryProperties = &chargeSummaryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cs.Tags = tags
			}
		}
	}

	return nil
}

// ChargeSummaryProperties the properties of the charge summary.
type ChargeSummaryProperties struct {
	// BillingPeriodID - READ-ONLY; The id of the billing period resource that the charge belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty"`
	// UsageStart - READ-ONLY; Usage start date.
	UsageStart *string `json:"usageStart,omitempty"`
	// UsageEnd - READ-ONLY;  Usage end date.
	UsageEnd *string `json:"usageEnd,omitempty"`
	// AzureCharges - READ-ONLY; Azure Charges.
	AzureCharges *decimal.Decimal `json:"azureCharges,omitempty"`
	// ChargesBilledSeparately - READ-ONLY; Charges Billed separately.
	ChargesBilledSeparately *decimal.Decimal `json:"chargesBilledSeparately,omitempty"`
	// MarketplaceCharges - READ-ONLY; Marketplace Charges.
	MarketplaceCharges *decimal.Decimal `json:"marketplaceCharges,omitempty"`
	// Currency - READ-ONLY; Currency Code
	Currency *string `json:"currency,omitempty"`
}

// CurrentSpend the current amount of cost which is being tracked for a budget.
type CurrentSpend struct {
	// Amount - READ-ONLY; The total amount of cost which is being tracked by the budget.
	Amount *decimal.Decimal `json:"amount,omitempty"`
	// Unit - READ-ONLY; The unit of measure for the budget amount.
	Unit *string `json:"unit,omitempty"`
}

// ErrorDetails the details of the error.
type ErrorDetails struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse error response indicates that the service is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponse struct {
	// Error - The details of the error.
	Error *ErrorDetails `json:"error,omitempty"`
}

// Filters may be used to filter budgets by resource group, resource, or meter.
type Filters struct {
	// ResourceGroups - The list of filters on resource groups, allowed at subscription level only.
	ResourceGroups *[]string `json:"resourceGroups,omitempty"`
	// Resources - The list of filters on resources.
	Resources *[]string `json:"resources,omitempty"`
	// Meters - The list of filters on meters (GUID), mandatory for budgets of usage category.
	Meters *[]uuid.UUID `json:"meters,omitempty"`
	// Tags - The dictionary of filters on tags.
	Tags map[string][]string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Filters.
func (f Filters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if f.ResourceGroups != nil {
		objectMap["resourceGroups"] = f.ResourceGroups
	}
	if f.Resources != nil {
		objectMap["resources"] = f.Resources
	}
	if f.Meters != nil {
		objectMap["meters"] = f.Meters
	}
	if f.Tags != nil {
		objectMap["tags"] = f.Tags
	}
	return json.Marshal(objectMap)
}

// Forecast a forecast resource.
type Forecast struct {
	*ForecastProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Forecast.
func (f Forecast) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if f.ForecastProperties != nil {
		objectMap["properties"] = f.ForecastProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Forecast struct.
func (f *Forecast) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var forecastProperties ForecastProperties
				err = json.Unmarshal(*v, &forecastProperties)
				if err != nil {
					return err
				}
				f.ForecastProperties = &forecastProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				f.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				f.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				f.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				f.Tags = tags
			}
		}
	}

	return nil
}

// ForecastProperties the properties of the forecast charge.
type ForecastProperties struct {
	// UsageDate - READ-ONLY; The usage date of the forecast.
	UsageDate *string `json:"usageDate,omitempty"`
	// Grain - The granularity of forecast. Possible values include: 'Daily', 'Monthly', 'Yearly'
	Grain Grain `json:"grain,omitempty"`
	// Charge - READ-ONLY; The amount of charge
	Charge *decimal.Decimal `json:"charge,omitempty"`
	// Currency - READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string `json:"currency,omitempty"`
	// ChargeType - The type of the charge. Could be actual or forecast. Possible values include: 'ChargeTypeActual', 'ChargeTypeForecast'
	ChargeType ChargeType `json:"chargeType,omitempty"`
	// ConfidenceLevels - READ-ONLY; The details about the forecast confidence levels. This is populated only when chargeType is Forecast.
	ConfidenceLevels *[]ForecastPropertiesConfidenceLevelsItem `json:"confidenceLevels,omitempty"`
}

// MarshalJSON is the custom marshaler for ForecastProperties.
func (fp ForecastProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fp.Grain != "" {
		objectMap["grain"] = fp.Grain
	}
	if fp.ChargeType != "" {
		objectMap["chargeType"] = fp.ChargeType
	}
	return json.Marshal(objectMap)
}

// ForecastPropertiesConfidenceLevelsItem ...
type ForecastPropertiesConfidenceLevelsItem struct {
	// Percentage - READ-ONLY; The percentage level of the confidence
	Percentage *decimal.Decimal `json:"percentage,omitempty"`
	// Bound - The boundary of the percentage, values could be 'Upper' or 'Lower'. Possible values include: 'Upper', 'Lower'
	Bound Bound `json:"bound,omitempty"`
	// Value - READ-ONLY; The amount of forecast within the percentage level
	Value *decimal.Decimal `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ForecastPropertiesConfidenceLevelsItem.
func (fpLi ForecastPropertiesConfidenceLevelsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fpLi.Bound != "" {
		objectMap["bound"] = fpLi.Bound
	}
	return json.Marshal(objectMap)
}

// ForecastsListResult result of listing forecasts. It contains a list of available forecasts.
type ForecastsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of forecasts.
	Value *[]Forecast `json:"value,omitempty"`
}

// ManagementGroupAggregatedCostProperties the properties of the Management Group Aggregated Cost.
type ManagementGroupAggregatedCostProperties struct {
	// BillingPeriodID - READ-ONLY; The id of the billing period resource that the aggregated cost belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty"`
	// UsageStart - READ-ONLY; The start of the date time range covered by aggregated cost.
	UsageStart *date.Time `json:"usageStart,omitempty"`
	// UsageEnd - READ-ONLY; The end of the date time range covered by the aggregated cost.
	UsageEnd *date.Time `json:"usageEnd,omitempty"`
	// AzureCharges - READ-ONLY; Azure Charges.
	AzureCharges *decimal.Decimal `json:"azureCharges,omitempty"`
	// MarketplaceCharges - READ-ONLY; Marketplace Charges.
	MarketplaceCharges *decimal.Decimal `json:"marketplaceCharges,omitempty"`
	// ChargesBilledSeparately - READ-ONLY; Charges Billed Separately.
	ChargesBilledSeparately *decimal.Decimal `json:"chargesBilledSeparately,omitempty"`
	// Currency - READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string `json:"currency,omitempty"`
	// Children - Children of a management group
	Children *[]ManagementGroupAggregatedCostResult `json:"children,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementGroupAggregatedCostProperties.
func (mgacp ManagementGroupAggregatedCostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mgacp.Children != nil {
		objectMap["children"] = mgacp.Children
	}
	return json.Marshal(objectMap)
}

// ManagementGroupAggregatedCostResult a management group aggregated cost resource.
type ManagementGroupAggregatedCostResult struct {
	autorest.Response                        `json:"-"`
	*ManagementGroupAggregatedCostProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagementGroupAggregatedCostResult.
func (mgacr ManagementGroupAggregatedCostResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mgacr.ManagementGroupAggregatedCostProperties != nil {
		objectMap["properties"] = mgacr.ManagementGroupAggregatedCostProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagementGroupAggregatedCostResult struct.
func (mgacr *ManagementGroupAggregatedCostResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managementGroupAggregatedCostProperties ManagementGroupAggregatedCostProperties
				err = json.Unmarshal(*v, &managementGroupAggregatedCostProperties)
				if err != nil {
					return err
				}
				mgacr.ManagementGroupAggregatedCostProperties = &managementGroupAggregatedCostProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mgacr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mgacr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mgacr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mgacr.Tags = tags
			}
		}
	}

	return nil
}

// Marketplace an marketplace resource.
type Marketplace struct {
	*MarketplaceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Marketplace.
func (mVar Marketplace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.MarketplaceProperties != nil {
		objectMap["properties"] = mVar.MarketplaceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Marketplace struct.
func (mVar *Marketplace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var marketplaceProperties MarketplaceProperties
				err = json.Unmarshal(*v, &marketplaceProperties)
				if err != nil {
					return err
				}
				mVar.MarketplaceProperties = &marketplaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mVar.Tags = tags
			}
		}
	}

	return nil
}

// MarketplaceProperties the properties of the marketplace usage detail.
type MarketplaceProperties struct {
	// BillingPeriodID - READ-ONLY; The id of the billing period resource that the usage belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty"`
	// UsageStart - READ-ONLY; The start of the date time range covered by the usage detail.
	UsageStart *date.Time `json:"usageStart,omitempty"`
	// UsageEnd - READ-ONLY; The end of the date time range covered by the usage detail.
	UsageEnd *date.Time `json:"usageEnd,omitempty"`
	// ResourceRate - READ-ONLY; The marketplace resource rate.
	ResourceRate *decimal.Decimal `json:"resourceRate,omitempty"`
	// OfferName - READ-ONLY; The type of offer.
	OfferName *string `json:"offerName,omitempty"`
	// ResourceGroup - READ-ONLY; The name of resource group.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// OrderNumber - READ-ONLY; The order number.
	OrderNumber *string `json:"orderNumber,omitempty"`
	// InstanceName - READ-ONLY; The name of the resource instance that the usage is about.
	InstanceName *string `json:"instanceName,omitempty"`
	// InstanceID - READ-ONLY; The uri of the resource instance that the usage is about.
	InstanceID *string `json:"instanceId,omitempty"`
	// Currency - READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string `json:"currency,omitempty"`
	// ConsumedQuantity - READ-ONLY; The quantity of usage.
	ConsumedQuantity *decimal.Decimal `json:"consumedQuantity,omitempty"`
	// UnitOfMeasure - READ-ONLY; The unit of measure.
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty"`
	// PretaxCost - READ-ONLY; The amount of cost before tax.
	PretaxCost *decimal.Decimal `json:"pretaxCost,omitempty"`
	// IsEstimated - READ-ONLY; The estimated usage is subject to change.
	IsEstimated *bool `json:"isEstimated,omitempty"`
	// MeterID - READ-ONLY; The meter id (GUID).
	MeterID *uuid.UUID `json:"meterId,omitempty"`
	// SubscriptionGUID - READ-ONLY; Subscription guid.
	SubscriptionGUID *uuid.UUID `json:"subscriptionGuid,omitempty"`
	// SubscriptionName - READ-ONLY; Subscription name.
	SubscriptionName *string `json:"subscriptionName,omitempty"`
	// AccountName - READ-ONLY; Account name.
	AccountName *string `json:"accountName,omitempty"`
	// DepartmentName - READ-ONLY; Department name.
	DepartmentName *string `json:"departmentName,omitempty"`
	// ConsumedService - READ-ONLY; Consumed service name.
	ConsumedService *string `json:"consumedService,omitempty"`
	// CostCenter - READ-ONLY; The cost center of this department if it is a department and a costcenter exists
	CostCenter *string `json:"costCenter,omitempty"`
	// AdditionalProperties - READ-ONLY; Additional details of this usage item. By default this is not populated, unless it's specified in $expand.
	AdditionalProperties *string `json:"additionalProperties,omitempty"`
	// PublisherName - READ-ONLY; The name of publisher.
	PublisherName *string `json:"publisherName,omitempty"`
	// PlanName - READ-ONLY; The name of plan.
	PlanName *string `json:"planName,omitempty"`
	// IsRecurringCharge - READ-ONLY; Flag indicating whether this is a recurring charge or not.
	IsRecurringCharge *bool `json:"isRecurringCharge,omitempty"`
}

// MarketplacesListResult result of listing marketplaces. It contains a list of available marketplaces in
// reverse chronological order by billing period.
type MarketplacesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of marketplaces.
	Value *[]Marketplace `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarketplacesListResultIterator provides access to a complete listing of Marketplace values.
type MarketplacesListResultIterator struct {
	i    int
	page MarketplacesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MarketplacesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MarketplacesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MarketplacesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MarketplacesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MarketplacesListResultIterator) Response() MarketplacesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MarketplacesListResultIterator) Value() Marketplace {
	if !iter.page.NotDone() {
		return Marketplace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MarketplacesListResultIterator type.
func NewMarketplacesListResultIterator(page MarketplacesListResultPage) MarketplacesListResultIterator {
	return MarketplacesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mlr MarketplacesListResult) IsEmpty() bool {
	return mlr.Value == nil || len(*mlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mlr MarketplacesListResult) hasNextLink() bool {
	return mlr.NextLink != nil && len(*mlr.NextLink) != 0
}

// marketplacesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mlr MarketplacesListResult) marketplacesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mlr.NextLink)))
}

// MarketplacesListResultPage contains a page of Marketplace values.
type MarketplacesListResultPage struct {
	fn  func(context.Context, MarketplacesListResult) (MarketplacesListResult, error)
	mlr MarketplacesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MarketplacesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MarketplacesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mlr)
		if err != nil {
			return err
		}
		page.mlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MarketplacesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MarketplacesListResultPage) NotDone() bool {
	return !page.mlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MarketplacesListResultPage) Response() MarketplacesListResult {
	return page.mlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MarketplacesListResultPage) Values() []Marketplace {
	if page.mlr.IsEmpty() {
		return nil
	}
	return *page.mlr.Value
}

// Creates a new instance of the MarketplacesListResultPage type.
func NewMarketplacesListResultPage(getNextPage func(context.Context, MarketplacesListResult) (MarketplacesListResult, error)) MarketplacesListResultPage {
	return MarketplacesListResultPage{fn: getNextPage}
}

// MeterDetails the properties of the meter detail.
type MeterDetails struct {
	// MeterName - READ-ONLY; The name of the meter, within the given meter category
	MeterName *string `json:"meterName,omitempty"`
	// MeterCategory - READ-ONLY; The category of the meter, for example, 'Cloud services', 'Networking', etc..
	MeterCategory *string `json:"meterCategory,omitempty"`
	// MeterSubCategory - READ-ONLY; The subcategory of the meter, for example, 'A6 Cloud services', 'ExpressRoute (IXP)', etc..
	MeterSubCategory *string `json:"meterSubCategory,omitempty"`
	// Unit - READ-ONLY; The unit in which the meter consumption is charged, for example, 'Hours', 'GB', etc.
	Unit *string `json:"unit,omitempty"`
	// MeterLocation - READ-ONLY; The location in which the Azure service is available.
	MeterLocation *string `json:"meterLocation,omitempty"`
	// TotalIncludedQuantity - READ-ONLY; The total included quantity associated with the offer.
	TotalIncludedQuantity *decimal.Decimal `json:"totalIncludedQuantity,omitempty"`
	// PretaxStandardRate - READ-ONLY; The pretax listing price.
	PretaxStandardRate *decimal.Decimal `json:"pretaxStandardRate,omitempty"`
	// ServiceName - READ-ONLY; The name of the service.
	ServiceName *string `json:"serviceName,omitempty"`
	// ServiceTier - READ-ONLY; The service tier.
	ServiceTier *string `json:"serviceTier,omitempty"`
}

// Notification the notification associated with a budget.
type Notification struct {
	// Enabled - The notification is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// Operator - The comparison operator. Possible values include: 'EqualTo', 'GreaterThan', 'GreaterThanOrEqualTo'
	Operator OperatorType `json:"operator,omitempty"`
	// Threshold - Threshold value associated with a notification. Notification is sent when the cost exceeded the threshold. It is always percent and has to be between 0 and 1000.
	Threshold *decimal.Decimal `json:"threshold,omitempty"`
	// ContactEmails - Email addresses to send the budget notification to when the threshold is exceeded.
	ContactEmails *[]string `json:"contactEmails,omitempty"`
	// ContactRoles - Contact roles to send the budget notification to when the threshold is exceeded.
	ContactRoles *[]string `json:"contactRoles,omitempty"`
	// ContactGroups - Action groups to send the budget notification to when the threshold is exceeded.
	ContactGroups *[]string `json:"contactGroups,omitempty"`
}

// Operation a Consumption REST API operation.
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.Consumption.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed: UsageDetail, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of listing consumption operations. It contains a list of operations and a URL
// link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of consumption operations supported by the Microsoft.Consumption resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// PriceSheetModel price sheet result. It contains the pricesheet associated with billing period
type PriceSheetModel struct {
	// Pricesheets - READ-ONLY; Price sheet
	Pricesheets *[]PriceSheetProperties `json:"pricesheets,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PriceSheetProperties the properties of the price sheet.
type PriceSheetProperties struct {
	// BillingPeriodID - READ-ONLY; The id of the billing period resource that the usage belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty"`
	// MeterID - READ-ONLY; The meter id (GUID)
	MeterID *uuid.UUID `json:"meterId,omitempty"`
	// MeterDetails - READ-ONLY; The details about the meter. By default this is not populated, unless it's specified in $expand.
	MeterDetails *MeterDetails `json:"meterDetails,omitempty"`
	// UnitOfMeasure - READ-ONLY; Unit of measure
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty"`
	// IncludedQuantity - READ-ONLY; Included quality for an offer
	IncludedQuantity *decimal.Decimal `json:"includedQuantity,omitempty"`
	// PartNumber - READ-ONLY; Part Number
	PartNumber *string `json:"partNumber,omitempty"`
	// UnitPrice - READ-ONLY; Unit Price
	UnitPrice *decimal.Decimal `json:"unitPrice,omitempty"`
	// CurrencyCode - READ-ONLY; Currency Code
	CurrencyCode *string `json:"currencyCode,omitempty"`
	// OfferID - READ-ONLY; Offer Id
	OfferID *string `json:"offerId,omitempty"`
}

// PriceSheetResult an pricesheet resource.
type PriceSheetResult struct {
	autorest.Response `json:"-"`
	*PriceSheetModel  `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PriceSheetResult.
func (psr PriceSheetResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if psr.PriceSheetModel != nil {
		objectMap["properties"] = psr.PriceSheetModel
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PriceSheetResult struct.
func (psr *PriceSheetResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var priceSheetModel PriceSheetModel
				err = json.Unmarshal(*v, &priceSheetModel)
				if err != nil {
					return err
				}
				psr.PriceSheetModel = &priceSheetModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				psr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				psr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				psr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				psr.Tags = tags
			}
		}
	}

	return nil
}

// ProxyResource the Resource model definition.
type ProxyResource struct {
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ETag - eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pr.ETag != nil {
		objectMap["eTag"] = pr.ETag
	}
	return json.Marshal(objectMap)
}

// ReservationDetail reservation detail resource.
type ReservationDetail struct {
	*ReservationDetailProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ReservationDetail.
func (rd ReservationDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.ReservationDetailProperties != nil {
		objectMap["properties"] = rd.ReservationDetailProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReservationDetail struct.
func (rd *ReservationDetail) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var reservationDetailProperties ReservationDetailProperties
				err = json.Unmarshal(*v, &reservationDetailProperties)
				if err != nil {
					return err
				}
				rd.ReservationDetailProperties = &reservationDetailProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rd.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rd.Tags = tags
			}
		}
	}

	return nil
}

// ReservationDetailProperties the properties of the reservation detail.
type ReservationDetailProperties struct {
	// ReservationOrderID - READ-ONLY; The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents a single purchase transaction. A reservation order contains reservations. The reservation order specifies the VM size and region for the reservations.
	ReservationOrderID *string `json:"reservationOrderId,omitempty"`
	// ReservationID - READ-ONLY; The reservation ID is the identifier of a reservation within a reservation order. Each reservation is the grouping for applying the benefit scope and also specifies the number of instances to which the reservation benefit can be applied to.
	ReservationID *string `json:"reservationId,omitempty"`
	// SkuName - READ-ONLY; This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records.
	SkuName *string `json:"skuName,omitempty"`
	// ReservedHours - READ-ONLY; This is the total hours reserved for the day. E.g. if reservation for 1 instance was made on 1 PM, this will be 11 hours for that day and 24 hours from subsequent days.
	ReservedHours *decimal.Decimal `json:"reservedHours,omitempty"`
	// UsageDate - READ-ONLY; The date on which consumption occurred.
	UsageDate *date.Time `json:"usageDate,omitempty"`
	// UsedHours - READ-ONLY; This is the total hours used by the instance.
	UsedHours *decimal.Decimal `json:"usedHours,omitempty"`
	// InstanceID - READ-ONLY; This identifier is the name of the resource or the fully qualified Resource ID.
	InstanceID *string `json:"instanceId,omitempty"`
	// TotalReservedQuantity - READ-ONLY; This is the total count of instances that are reserved for the reservationId.
	TotalReservedQuantity *decimal.Decimal `json:"totalReservedQuantity,omitempty"`
}

// ReservationDetailsListResult result of listing reservation details.
type ReservationDetailsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of reservation details.
	Value *[]ReservationDetail `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReservationDetailsListResultIterator provides access to a complete listing of ReservationDetail values.
type ReservationDetailsListResultIterator struct {
	i    int
	page ReservationDetailsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReservationDetailsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationDetailsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReservationDetailsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReservationDetailsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReservationDetailsListResultIterator) Response() ReservationDetailsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReservationDetailsListResultIterator) Value() ReservationDetail {
	if !iter.page.NotDone() {
		return ReservationDetail{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReservationDetailsListResultIterator type.
func NewReservationDetailsListResultIterator(page ReservationDetailsListResultPage) ReservationDetailsListResultIterator {
	return ReservationDetailsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rdlr ReservationDetailsListResult) IsEmpty() bool {
	return rdlr.Value == nil || len(*rdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rdlr ReservationDetailsListResult) hasNextLink() bool {
	return rdlr.NextLink != nil && len(*rdlr.NextLink) != 0
}

// reservationDetailsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rdlr ReservationDetailsListResult) reservationDetailsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rdlr.NextLink)))
}

// ReservationDetailsListResultPage contains a page of ReservationDetail values.
type ReservationDetailsListResultPage struct {
	fn   func(context.Context, ReservationDetailsListResult) (ReservationDetailsListResult, error)
	rdlr ReservationDetailsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReservationDetailsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationDetailsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rdlr)
		if err != nil {
			return err
		}
		page.rdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReservationDetailsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReservationDetailsListResultPage) NotDone() bool {
	return !page.rdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReservationDetailsListResultPage) Response() ReservationDetailsListResult {
	return page.rdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReservationDetailsListResultPage) Values() []ReservationDetail {
	if page.rdlr.IsEmpty() {
		return nil
	}
	return *page.rdlr.Value
}

// Creates a new instance of the ReservationDetailsListResultPage type.
func NewReservationDetailsListResultPage(getNextPage func(context.Context, ReservationDetailsListResult) (ReservationDetailsListResult, error)) ReservationDetailsListResultPage {
	return ReservationDetailsListResultPage{fn: getNextPage}
}

// ReservationRecommendation reservation recommendation resource.
type ReservationRecommendation struct {
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
	// Sku - READ-ONLY; Resource sku
	Sku                                  *string `json:"sku,omitempty"`
	*ReservationRecommendationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ReservationRecommendation.
func (rr ReservationRecommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.ReservationRecommendationProperties != nil {
		objectMap["properties"] = rr.ReservationRecommendationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReservationRecommendation struct.
func (rr *ReservationRecommendation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rr.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rr.Location = &location
			}
		case "sku":
			if v != nil {
				var sku string
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				rr.Sku = &sku
			}
		case "properties":
			if v != nil {
				var reservationRecommendationProperties ReservationRecommendationProperties
				err = json.Unmarshal(*v, &reservationRecommendationProperties)
				if err != nil {
					return err
				}
				rr.ReservationRecommendationProperties = &reservationRecommendationProperties
			}
		}
	}

	return nil
}

// ReservationRecommendationProperties the properties of the reservation recommendation.
type ReservationRecommendationProperties struct {
	// LookBackPeriod - READ-ONLY; The number of days of usage to look back for recommendation.
	LookBackPeriod *string `json:"lookBackPeriod,omitempty"`
	// MeterID - READ-ONLY; The meter id (GUID)
	MeterID *uuid.UUID `json:"meterId,omitempty"`
	// Term - READ-ONLY; RI recommendations in one or three year terms.
	Term *string `json:"term,omitempty"`
	// CostWithNoReservedInstances - READ-ONLY; The total amount of cost without reserved instances.
	CostWithNoReservedInstances *decimal.Decimal `json:"costWithNoReservedInstances,omitempty"`
	// RecommendedQuantity - READ-ONLY; Recommended quality for reserved instances.
	RecommendedQuantity *decimal.Decimal `json:"recommendedQuantity,omitempty"`
	// TotalCostWithReservedInstances - READ-ONLY; The total amount of cost with reserved instances.
	TotalCostWithReservedInstances *decimal.Decimal `json:"totalCostWithReservedInstances,omitempty"`
	// NetSavings - READ-ONLY; Total estimated savings with reserved instances.
	NetSavings *decimal.Decimal `json:"netSavings,omitempty"`
	// FirstUsageDate - READ-ONLY; The usage date for looking back.
	FirstUsageDate *date.Time `json:"firstUsageDate,omitempty"`
	// Scope - READ-ONLY; Shared or single recommendation.
	Scope *string `json:"scope,omitempty"`
}

// ReservationRecommendationsListResult result of listing reservation recommendations.
type ReservationRecommendationsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of reservation recommendations.
	Value *[]ReservationRecommendation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReservationRecommendationsListResultIterator provides access to a complete listing of
// ReservationRecommendation values.
type ReservationRecommendationsListResultIterator struct {
	i    int
	page ReservationRecommendationsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReservationRecommendationsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationRecommendationsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReservationRecommendationsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReservationRecommendationsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReservationRecommendationsListResultIterator) Response() ReservationRecommendationsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReservationRecommendationsListResultIterator) Value() ReservationRecommendation {
	if !iter.page.NotDone() {
		return ReservationRecommendation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReservationRecommendationsListResultIterator type.
func NewReservationRecommendationsListResultIterator(page ReservationRecommendationsListResultPage) ReservationRecommendationsListResultIterator {
	return ReservationRecommendationsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rrlr ReservationRecommendationsListResult) IsEmpty() bool {
	return rrlr.Value == nil || len(*rrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rrlr ReservationRecommendationsListResult) hasNextLink() bool {
	return rrlr.NextLink != nil && len(*rrlr.NextLink) != 0
}

// reservationRecommendationsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rrlr ReservationRecommendationsListResult) reservationRecommendationsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rrlr.NextLink)))
}

// ReservationRecommendationsListResultPage contains a page of ReservationRecommendation values.
type ReservationRecommendationsListResultPage struct {
	fn   func(context.Context, ReservationRecommendationsListResult) (ReservationRecommendationsListResult, error)
	rrlr ReservationRecommendationsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReservationRecommendationsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationRecommendationsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rrlr)
		if err != nil {
			return err
		}
		page.rrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReservationRecommendationsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReservationRecommendationsListResultPage) NotDone() bool {
	return !page.rrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReservationRecommendationsListResultPage) Response() ReservationRecommendationsListResult {
	return page.rrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReservationRecommendationsListResultPage) Values() []ReservationRecommendation {
	if page.rrlr.IsEmpty() {
		return nil
	}
	return *page.rrlr.Value
}

// Creates a new instance of the ReservationRecommendationsListResultPage type.
func NewReservationRecommendationsListResultPage(getNextPage func(context.Context, ReservationRecommendationsListResult) (ReservationRecommendationsListResult, error)) ReservationRecommendationsListResultPage {
	return ReservationRecommendationsListResultPage{fn: getNextPage}
}

// ReservationSummariesListResult result of listing reservation summaries.
type ReservationSummariesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of reservation summaries.
	Value *[]ReservationSummary `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReservationSummariesListResultIterator provides access to a complete listing of ReservationSummary values.
type ReservationSummariesListResultIterator struct {
	i    int
	page ReservationSummariesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReservationSummariesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationSummariesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReservationSummariesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReservationSummariesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReservationSummariesListResultIterator) Response() ReservationSummariesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReservationSummariesListResultIterator) Value() ReservationSummary {
	if !iter.page.NotDone() {
		return ReservationSummary{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReservationSummariesListResultIterator type.
func NewReservationSummariesListResultIterator(page ReservationSummariesListResultPage) ReservationSummariesListResultIterator {
	return ReservationSummariesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rslr ReservationSummariesListResult) IsEmpty() bool {
	return rslr.Value == nil || len(*rslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rslr ReservationSummariesListResult) hasNextLink() bool {
	return rslr.NextLink != nil && len(*rslr.NextLink) != 0
}

// reservationSummariesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rslr ReservationSummariesListResult) reservationSummariesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rslr.NextLink)))
}

// ReservationSummariesListResultPage contains a page of ReservationSummary values.
type ReservationSummariesListResultPage struct {
	fn   func(context.Context, ReservationSummariesListResult) (ReservationSummariesListResult, error)
	rslr ReservationSummariesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReservationSummariesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationSummariesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rslr)
		if err != nil {
			return err
		}
		page.rslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReservationSummariesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReservationSummariesListResultPage) NotDone() bool {
	return !page.rslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReservationSummariesListResultPage) Response() ReservationSummariesListResult {
	return page.rslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReservationSummariesListResultPage) Values() []ReservationSummary {
	if page.rslr.IsEmpty() {
		return nil
	}
	return *page.rslr.Value
}

// Creates a new instance of the ReservationSummariesListResultPage type.
func NewReservationSummariesListResultPage(getNextPage func(context.Context, ReservationSummariesListResult) (ReservationSummariesListResult, error)) ReservationSummariesListResultPage {
	return ReservationSummariesListResultPage{fn: getNextPage}
}

// ReservationSummary reservation summary resource.
type ReservationSummary struct {
	*ReservationSummaryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ReservationSummary.
func (rs ReservationSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rs.ReservationSummaryProperties != nil {
		objectMap["properties"] = rs.ReservationSummaryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReservationSummary struct.
func (rs *ReservationSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var reservationSummaryProperties ReservationSummaryProperties
				err = json.Unmarshal(*v, &reservationSummaryProperties)
				if err != nil {
					return err
				}
				rs.ReservationSummaryProperties = &reservationSummaryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rs.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rs.Tags = tags
			}
		}
	}

	return nil
}

// ReservationSummaryProperties the properties of the reservation summary.
type ReservationSummaryProperties struct {
	// ReservationOrderID - READ-ONLY; The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents a single purchase transaction. A reservation order contains reservations. The reservation order specifies the VM size and region for the reservations.
	ReservationOrderID *string `json:"reservationOrderId,omitempty"`
	// ReservationID - READ-ONLY; The reservation ID is the identifier of a reservation within a reservation order. Each reservation is the grouping for applying the benefit scope and also specifies the number of instances to which the reservation benefit can be applied to.
	ReservationID *string `json:"reservationId,omitempty"`
	// SkuName - READ-ONLY; This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records.
	SkuName *string `json:"skuName,omitempty"`
	// ReservedHours - READ-ONLY; This is the total hours reserved. E.g. if reservation for 1 instance was made on 1 PM, this will be 11 hours for that day and 24 hours from subsequent days
	ReservedHours *decimal.Decimal `json:"reservedHours,omitempty"`
	// UsageDate - READ-ONLY; Data corresponding to the utilization record. If the grain of data is monthly, it will be first day of month.
	UsageDate *date.Time `json:"usageDate,omitempty"`
	// UsedHours - READ-ONLY; Total used hours by the reservation
	UsedHours *decimal.Decimal `json:"usedHours,omitempty"`
	// MinUtilizationPercentage - READ-ONLY; This is the minimum hourly utilization in the usage time (day or month). E.g. if usage record corresponds to 12/10/2017 and on that for hour 4 and 5, utilization was 10%, this field will return 10% for that day
	MinUtilizationPercentage *decimal.Decimal `json:"minUtilizationPercentage,omitempty"`
	// AvgUtilizationPercentage - READ-ONLY; This is average utilization for the entire time range. (day or month depending on the grain)
	AvgUtilizationPercentage *decimal.Decimal `json:"avgUtilizationPercentage,omitempty"`
	// MaxUtilizationPercentage - READ-ONLY; This is the maximum hourly utilization in the usage time (day or month). E.g. if usage record corresponds to 12/10/2017 and on that for hour 4 and 5, utilization was 100%, this field will return 100% for that day.
	MaxUtilizationPercentage *decimal.Decimal `json:"maxUtilizationPercentage,omitempty"`
}

// Resource the Resource model definition.
type Resource struct {
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceAttributes the Resource model definition.
type ResourceAttributes struct {
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
	// Sku - READ-ONLY; Resource sku
	Sku *string `json:"sku,omitempty"`
}

// Tag the tag resource.
type Tag struct {
	// Key - Tag key.
	Key *string `json:"key,omitempty"`
}

// TagProperties the properties of the tag.
type TagProperties struct {
	// Tags - A list of Tag.
	Tags *[]Tag `json:"tags,omitempty"`
}

// TagsResult a resource listing all tags.
type TagsResult struct {
	autorest.Response `json:"-"`
	*TagProperties    `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ETag - eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for TagsResult.
func (tr TagsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.TagProperties != nil {
		objectMap["properties"] = tr.TagProperties
	}
	if tr.ETag != nil {
		objectMap["eTag"] = tr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TagsResult struct.
func (tr *TagsResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tagProperties TagProperties
				err = json.Unmarshal(*v, &tagProperties)
				if err != nil {
					return err
				}
				tr.TagProperties = &tagProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tr.Type = &typeVar
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				tr.ETag = &eTag
			}
		}
	}

	return nil
}

// UsageDetail an usage detail resource.
type UsageDetail struct {
	*UsageDetailProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for UsageDetail.
func (ud UsageDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ud.UsageDetailProperties != nil {
		objectMap["properties"] = ud.UsageDetailProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UsageDetail struct.
func (ud *UsageDetail) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var usageDetailProperties UsageDetailProperties
				err = json.Unmarshal(*v, &usageDetailProperties)
				if err != nil {
					return err
				}
				ud.UsageDetailProperties = &usageDetailProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ud.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ud.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ud.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ud.Tags = tags
			}
		}
	}

	return nil
}

// UsageDetailProperties the properties of the usage detail.
type UsageDetailProperties struct {
	// BillingPeriodID - READ-ONLY; The id of the billing period resource that the usage belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty"`
	// InvoiceID - READ-ONLY; The id of the invoice resource that the usage belongs to.
	InvoiceID *string `json:"invoiceId,omitempty"`
	// UsageStart - READ-ONLY; The start of the date time range covered by the usage detail.
	UsageStart *date.Time `json:"usageStart,omitempty"`
	// UsageEnd - READ-ONLY; The end of the date time range covered by the usage detail.
	UsageEnd *date.Time `json:"usageEnd,omitempty"`
	// InstanceName - READ-ONLY; The name of the resource instance that the usage is about.
	InstanceName *string `json:"instanceName,omitempty"`
	// InstanceID - READ-ONLY; The uri of the resource instance that the usage is about.
	InstanceID *string `json:"instanceId,omitempty"`
	// InstanceLocation - READ-ONLY; The location of the resource instance that the usage is about.
	InstanceLocation *string `json:"instanceLocation,omitempty"`
	// Currency - READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string `json:"currency,omitempty"`
	// UsageQuantity - READ-ONLY; The quantity of usage.
	UsageQuantity *decimal.Decimal `json:"usageQuantity,omitempty"`
	// BillableQuantity - READ-ONLY; The billable usage quantity.
	BillableQuantity *decimal.Decimal `json:"billableQuantity,omitempty"`
	// PretaxCost - READ-ONLY; The amount of cost before tax.
	PretaxCost *decimal.Decimal `json:"pretaxCost,omitempty"`
	// IsEstimated - READ-ONLY; The estimated usage is subject to change.
	IsEstimated *bool `json:"isEstimated,omitempty"`
	// MeterID - READ-ONLY; The meter id (GUID).
	MeterID *uuid.UUID `json:"meterId,omitempty"`
	// MeterDetails - READ-ONLY; The details about the meter. By default this is not populated, unless it's specified in $expand.
	MeterDetails *MeterDetails `json:"meterDetails,omitempty"`
	// SubscriptionGUID - READ-ONLY; Subscription guid.
	SubscriptionGUID *uuid.UUID `json:"subscriptionGuid,omitempty"`
	// SubscriptionName - READ-ONLY; Subscription name.
	SubscriptionName *string `json:"subscriptionName,omitempty"`
	// AccountName - READ-ONLY; Account name.
	AccountName *string `json:"accountName,omitempty"`
	// DepartmentName - READ-ONLY; Department name.
	DepartmentName *string `json:"departmentName,omitempty"`
	// Product - READ-ONLY; Product name.
	Product *string `json:"product,omitempty"`
	// ConsumedService - READ-ONLY; Consumed service name.
	ConsumedService *string `json:"consumedService,omitempty"`
	// CostCenter - READ-ONLY; The cost center of this department if it is a department and a costcenter exists
	CostCenter *string `json:"costCenter,omitempty"`
	// PartNumber - READ-ONLY; Part Number
	PartNumber *string `json:"partNumber,omitempty"`
	// ResourceGUID - READ-ONLY; Resource Guid
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// OfferID - READ-ONLY; Offer Id
	OfferID *string `json:"offerId,omitempty"`
	// ChargesBilledSeparately - READ-ONLY; Charges billed separately
	ChargesBilledSeparately *bool `json:"chargesBilledSeparately,omitempty"`
	// Location - READ-ONLY; Resource Location
	Location *string `json:"location,omitempty"`
	// AdditionalProperties - READ-ONLY; Additional details of this usage item. By default this is not populated, unless it's specified in $expand.
	AdditionalProperties *string `json:"additionalProperties,omitempty"`
}

// UsageDetailsListResult result of listing usage details. It contains a list of available usage details in
// reverse chronological order by billing period.
type UsageDetailsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of usage details.
	Value *[]UsageDetail `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UsageDetailsListResultIterator provides access to a complete listing of UsageDetail values.
type UsageDetailsListResultIterator struct {
	i    int
	page UsageDetailsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UsageDetailsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsageDetailsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UsageDetailsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UsageDetailsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UsageDetailsListResultIterator) Response() UsageDetailsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UsageDetailsListResultIterator) Value() UsageDetail {
	if !iter.page.NotDone() {
		return UsageDetail{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UsageDetailsListResultIterator type.
func NewUsageDetailsListResultIterator(page UsageDetailsListResultPage) UsageDetailsListResultIterator {
	return UsageDetailsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (udlr UsageDetailsListResult) IsEmpty() bool {
	return udlr.Value == nil || len(*udlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (udlr UsageDetailsListResult) hasNextLink() bool {
	return udlr.NextLink != nil && len(*udlr.NextLink) != 0
}

// usageDetailsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (udlr UsageDetailsListResult) usageDetailsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !udlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(udlr.NextLink)))
}

// UsageDetailsListResultPage contains a page of UsageDetail values.
type UsageDetailsListResultPage struct {
	fn   func(context.Context, UsageDetailsListResult) (UsageDetailsListResult, error)
	udlr UsageDetailsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UsageDetailsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsageDetailsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.udlr)
		if err != nil {
			return err
		}
		page.udlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UsageDetailsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UsageDetailsListResultPage) NotDone() bool {
	return !page.udlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UsageDetailsListResultPage) Response() UsageDetailsListResult {
	return page.udlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UsageDetailsListResultPage) Values() []UsageDetail {
	if page.udlr.IsEmpty() {
		return nil
	}
	return *page.udlr.Value
}

// Creates a new instance of the UsageDetailsListResultPage type.
func NewUsageDetailsListResultPage(getNextPage func(context.Context, UsageDetailsListResult) (UsageDetailsListResult, error)) UsageDetailsListResultPage {
	return UsageDetailsListResultPage{fn: getNextPage}
}
