package batch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"io"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/batch/2020-03-01.11.0/batch"

// AccountListSupportedImagesResult ...
type AccountListSupportedImagesResult struct {
	autorest.Response `json:"-"`
	Value             *[]ImageInformation `json:"value,omitempty"`
	OdataNextLink     *string             `json:"odata.nextLink,omitempty"`
}

// AccountListSupportedImagesResultIterator provides access to a complete listing of ImageInformation values.
type AccountListSupportedImagesResultIterator struct {
	i    int
	page AccountListSupportedImagesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountListSupportedImagesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListSupportedImagesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccountListSupportedImagesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountListSupportedImagesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountListSupportedImagesResultIterator) Response() AccountListSupportedImagesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountListSupportedImagesResultIterator) Value() ImageInformation {
	if !iter.page.NotDone() {
		return ImageInformation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccountListSupportedImagesResultIterator type.
func NewAccountListSupportedImagesResultIterator(page AccountListSupportedImagesResultPage) AccountListSupportedImagesResultIterator {
	return AccountListSupportedImagesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alsir AccountListSupportedImagesResult) IsEmpty() bool {
	return alsir.Value == nil || len(*alsir.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alsir AccountListSupportedImagesResult) hasNextLink() bool {
	return alsir.OdataNextLink != nil && len(*alsir.OdataNextLink) != 0
}

// accountListSupportedImagesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alsir AccountListSupportedImagesResult) accountListSupportedImagesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alsir.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alsir.OdataNextLink)))
}

// AccountListSupportedImagesResultPage contains a page of ImageInformation values.
type AccountListSupportedImagesResultPage struct {
	fn    func(context.Context, AccountListSupportedImagesResult) (AccountListSupportedImagesResult, error)
	alsir AccountListSupportedImagesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountListSupportedImagesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListSupportedImagesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alsir)
		if err != nil {
			return err
		}
		page.alsir = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccountListSupportedImagesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountListSupportedImagesResultPage) NotDone() bool {
	return !page.alsir.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountListSupportedImagesResultPage) Response() AccountListSupportedImagesResult {
	return page.alsir
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountListSupportedImagesResultPage) Values() []ImageInformation {
	if page.alsir.IsEmpty() {
		return nil
	}
	return *page.alsir.Value
}

// Creates a new instance of the AccountListSupportedImagesResultPage type.
func NewAccountListSupportedImagesResultPage(getNextPage func(context.Context, AccountListSupportedImagesResult) (AccountListSupportedImagesResult, error)) AccountListSupportedImagesResultPage {
	return AccountListSupportedImagesResultPage{fn: getNextPage}
}

// AffinityInformation ...
type AffinityInformation struct {
	// AffinityID - You can pass the affinityId of a Node to indicate that this Task needs to run on that Compute Node. Note that this is just a soft affinity. If the target Compute Node is busy or unavailable at the time the Task is scheduled, then the Task will be scheduled elsewhere.
	AffinityID *string `json:"affinityId,omitempty"`
}

// ApplicationListResult ...
type ApplicationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationSummary `json:"value,omitempty"`
	OdataNextLink     *string               `json:"odata.nextLink,omitempty"`
}

// ApplicationListResultIterator provides access to a complete listing of ApplicationSummary values.
type ApplicationListResultIterator struct {
	i    int
	page ApplicationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationListResultIterator) Response() ApplicationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationListResultIterator) Value() ApplicationSummary {
	if !iter.page.NotDone() {
		return ApplicationSummary{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationListResultIterator type.
func NewApplicationListResultIterator(page ApplicationListResultPage) ApplicationListResultIterator {
	return ApplicationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr ApplicationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr ApplicationListResult) hasNextLink() bool {
	return alr.OdataNextLink != nil && len(*alr.OdataNextLink) != 0
}

// applicationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr ApplicationListResult) applicationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.OdataNextLink)))
}

// ApplicationListResultPage contains a page of ApplicationSummary values.
type ApplicationListResultPage struct {
	fn  func(context.Context, ApplicationListResult) (ApplicationListResult, error)
	alr ApplicationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationListResultPage) Response() ApplicationListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationListResultPage) Values() []ApplicationSummary {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the ApplicationListResultPage type.
func NewApplicationListResultPage(getNextPage func(context.Context, ApplicationListResult) (ApplicationListResult, error)) ApplicationListResultPage {
	return ApplicationListResultPage{fn: getNextPage}
}

// ApplicationPackageReference ...
type ApplicationPackageReference struct {
	ApplicationID *string `json:"applicationId,omitempty"`
	// Version - If this is omitted on a Pool, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences and HTTP status code 409. If this is omitted on a Task, and no default version is specified for this application, the Task fails with a pre-processing error.
	Version *string `json:"version,omitempty"`
}

// ApplicationSummary ...
type ApplicationSummary struct {
	autorest.Response `json:"-"`
	ID                *string   `json:"id,omitempty"`
	DisplayName       *string   `json:"displayName,omitempty"`
	Versions          *[]string `json:"versions,omitempty"`
}

// AuthenticationTokenSettings ...
type AuthenticationTokenSettings struct {
	// Access - The authentication token grants access to a limited set of Batch service operations. Currently the only supported value for the access property is 'job', which grants access to all operations related to the Job which contains the Task.
	Access *[]AccessScope `json:"access,omitempty"`
}

// AutoPoolSpecification ...
type AutoPoolSpecification struct {
	// AutoPoolIDPrefix - The Batch service assigns each auto Pool a unique identifier on creation. To distinguish between Pools created for different purposes, you can specify this element to add a prefix to the ID that is assigned. The prefix can be up to 20 characters long.
	AutoPoolIDPrefix *string `json:"autoPoolIdPrefix,omitempty"`
	// PoolLifetimeOption - Possible values include: 'PoolLifetimeOptionJobSchedule', 'PoolLifetimeOptionJob'
	PoolLifetimeOption PoolLifetimeOption `json:"poolLifetimeOption,omitempty"`
	// KeepAlive - If false, the Batch service deletes the Pool once its lifetime (as determined by the poolLifetimeOption setting) expires; that is, when the Job or Job Schedule completes. If true, the Batch service does not delete the Pool automatically. It is up to the user to delete auto Pools created with this option.
	KeepAlive *bool              `json:"keepAlive,omitempty"`
	Pool      *PoolSpecification `json:"pool,omitempty"`
}

// AutoScaleRun ...
type AutoScaleRun struct {
	autorest.Response `json:"-"`
	Timestamp         *date.Time `json:"timestamp,omitempty"`
	// Results - Each variable value is returned in the form $variable=value, and variables are separated by semicolons.
	Results *string            `json:"results,omitempty"`
	Error   *AutoScaleRunError `json:"error,omitempty"`
}

// AutoScaleRunError ...
type AutoScaleRunError struct {
	Code    *string          `json:"code,omitempty"`
	Message *string          `json:"message,omitempty"`
	Values  *[]NameValuePair `json:"values,omitempty"`
}

// AutoUserSpecification ...
type AutoUserSpecification struct {
	// Scope - The default value is pool. If the pool is running Windows a value of Task should be specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way which could impact other tasks, or if certificates have been specified on the pool which should not be accessible by normal tasks but should be accessible by StartTasks. Possible values include: 'Task', 'Pool'
	Scope AutoUserScope `json:"scope,omitempty"`
	// ElevationLevel - The default value is nonAdmin. Possible values include: 'NonAdmin', 'Admin'
	ElevationLevel ElevationLevel `json:"elevationLevel,omitempty"`
}

// AzureBlobFileSystemConfiguration ...
type AzureBlobFileSystemConfiguration struct {
	AccountName   *string `json:"accountName,omitempty"`
	ContainerName *string `json:"containerName,omitempty"`
	// AccountKey - This property is mutually exclusive with sasKey and one must be specified.
	AccountKey *string `json:"accountKey,omitempty"`
	// SasKey - This property is mutually exclusive with accountKey and one must be specified.
	SasKey *string `json:"sasKey,omitempty"`
	// BlobfuseOptions - These are 'net use' options in Windows and 'mount' options in Linux.
	BlobfuseOptions *string `json:"blobfuseOptions,omitempty"`
	// RelativeMountPath - All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
}

// AzureFileShareConfiguration ...
type AzureFileShareConfiguration struct {
	AccountName *string `json:"accountName,omitempty"`
	// AzureFileURL - This is of the form 'https://{account}.file.core.windows.net/'.
	AzureFileURL *string `json:"azureFileUrl,omitempty"`
	AccountKey   *string `json:"accountKey,omitempty"`
	// RelativeMountPath - All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
	// MountOptions - These are 'net use' options in Windows and 'mount' options in Linux.
	MountOptions *string `json:"mountOptions,omitempty"`
}

// Certificate a Certificate that can be installed on Compute Nodes and can be used to authenticate operations
// on the machine.
type Certificate struct {
	autorest.Response   `json:"-"`
	Thumbprint          *string `json:"thumbprint,omitempty"`
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	URL                 *string `json:"url,omitempty"`
	// State - Possible values include: 'Active', 'Deleting', 'DeleteFailed'
	State               CertificateState `json:"state,omitempty"`
	StateTransitionTime *date.Time       `json:"stateTransitionTime,omitempty"`
	// PreviousState - This property is not set if the Certificate is in its initial active state. Possible values include: 'Active', 'Deleting', 'DeleteFailed'
	PreviousState CertificateState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - This property is not set if the Certificate is in its initial Active state.
	PreviousStateTransitionTime *date.Time `json:"previousStateTransitionTime,omitempty"`
	PublicData                  *string    `json:"publicData,omitempty"`
	// DeleteCertificateError - This property is set only if the Certificate is in the DeleteFailed state.
	DeleteCertificateError *DeleteCertificateError `json:"deleteCertificateError,omitempty"`
}

// CertificateAddParameter ...
type CertificateAddParameter struct {
	Thumbprint          *string `json:"thumbprint,omitempty"`
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	Data                *string `json:"data,omitempty"`
	// CertificateFormat - Possible values include: 'Pfx', 'Cer'
	CertificateFormat CertificateFormat `json:"certificateFormat,omitempty"`
	// Password - This must be omitted if the Certificate format is cer.
	Password *string `json:"password,omitempty"`
}

// CertificateListResult ...
type CertificateListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Certificate `json:"value,omitempty"`
	OdataNextLink     *string        `json:"odata.nextLink,omitempty"`
}

// CertificateListResultIterator provides access to a complete listing of Certificate values.
type CertificateListResultIterator struct {
	i    int
	page CertificateListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateListResultIterator) Response() CertificateListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateListResultIterator) Value() Certificate {
	if !iter.page.NotDone() {
		return Certificate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateListResultIterator type.
func NewCertificateListResultIterator(page CertificateListResultPage) CertificateListResultIterator {
	return CertificateListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CertificateListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr CertificateListResult) hasNextLink() bool {
	return clr.OdataNextLink != nil && len(*clr.OdataNextLink) != 0
}

// certificateListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CertificateListResult) certificateListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.OdataNextLink)))
}

// CertificateListResultPage contains a page of Certificate values.
type CertificateListResultPage struct {
	fn  func(context.Context, CertificateListResult) (CertificateListResult, error)
	clr CertificateListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateListResultPage) Response() CertificateListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateListResultPage) Values() []Certificate {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the CertificateListResultPage type.
func NewCertificateListResultPage(getNextPage func(context.Context, CertificateListResult) (CertificateListResult, error)) CertificateListResultPage {
	return CertificateListResultPage{fn: getNextPage}
}

// CertificateReference ...
type CertificateReference struct {
	Thumbprint          *string `json:"thumbprint,omitempty"`
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	// StoreLocation - The default value is currentuser. This property is applicable only for Pools configured with Windows Compute Nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows Image reference). For Linux Compute Nodes, the Certificates are stored in a directory inside the Task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the Task to query for this location. For Certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and Certificates are placed in that directory. Possible values include: 'CurrentUser', 'LocalMachine'
	StoreLocation CertificateStoreLocation `json:"storeLocation,omitempty"`
	// StoreName - This property is applicable only for Pools configured with Windows Compute Nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows Image reference). Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be used. The default value is My.
	StoreName *string `json:"storeName,omitempty"`
	// Visibility - You can specify more than one visibility in this collection. The default is all Accounts.
	Visibility *[]CertificateVisibility `json:"visibility,omitempty"`
}

// CIFSMountConfiguration ...
type CIFSMountConfiguration struct {
	Username *string `json:"username,omitempty"`
	Source   *string `json:"source,omitempty"`
	// RelativeMountPath - All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
	// MountOptions - These are 'net use' options in Windows and 'mount' options in Linux.
	MountOptions *string `json:"mountOptions,omitempty"`
	Password     *string `json:"password,omitempty"`
}

// CloudJob ...
type CloudJob struct {
	autorest.Response `json:"-"`
	// ID - The ID is case-preserving and case-insensitive (that is, you may not have two IDs within an Account that differ only by case).
	ID                   *string `json:"id,omitempty"`
	DisplayName          *string `json:"displayName,omitempty"`
	UsesTaskDependencies *bool   `json:"usesTaskDependencies,omitempty"`
	URL                  *string `json:"url,omitempty"`
	// ETag - This is an opaque string. You can use it to detect whether the Job has changed between requests. In particular, you can be pass the ETag when updating a Job to specify that your changes should take effect only if nobody else has modified the Job in the meantime.
	ETag *string `json:"eTag,omitempty"`
	// LastModified - This is the last time at which the Job level data, such as the Job state or priority, changed. It does not factor in task-level changes such as adding new Tasks or Tasks changing state.
	LastModified *date.Time `json:"lastModified,omitempty"`
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// State - Possible values include: 'JobStateActive', 'JobStateDisabling', 'JobStateDisabled', 'JobStateEnabling', 'JobStateTerminating', 'JobStateCompleted', 'JobStateDeleting'
	State               JobState   `json:"state,omitempty"`
	StateTransitionTime *date.Time `json:"stateTransitionTime,omitempty"`
	// PreviousState - This property is not set if the Job is in its initial Active state. Possible values include: 'JobStateActive', 'JobStateDisabling', 'JobStateDisabled', 'JobStateEnabling', 'JobStateTerminating', 'JobStateCompleted', 'JobStateDeleting'
	PreviousState JobState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - This property is not set if the Job is in its initial Active state.
	PreviousStateTransitionTime *date.Time `json:"previousStateTransitionTime,omitempty"`
	// Priority - Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. The default value is 0.
	Priority       *int32          `json:"priority,omitempty"`
	Constraints    *JobConstraints `json:"constraints,omitempty"`
	JobManagerTask *JobManagerTask `json:"jobManagerTask,omitempty"`
	// JobPreparationTask - The Job Preparation Task is a special Task run on each Compute Node before any other Task of the Job.
	JobPreparationTask *JobPreparationTask `json:"jobPreparationTask,omitempty"`
	// JobReleaseTask - The Job Release Task is a special Task run at the end of the Job on each Compute Node that has run any other Task of the Job.
	JobReleaseTask *JobReleaseTask `json:"jobReleaseTask,omitempty"`
	// CommonEnvironmentSettings - Individual Tasks can override an environment setting specified here by specifying the same setting name with a different value.
	CommonEnvironmentSettings *[]EnvironmentSetting `json:"commonEnvironmentSettings,omitempty"`
	PoolInfo                  *PoolInformation      `json:"poolInfo,omitempty"`
	// OnAllTasksComplete - The default is noaction. Possible values include: 'NoAction', 'TerminateJob'
	OnAllTasksComplete OnAllTasksComplete `json:"onAllTasksComplete,omitempty"`
	// OnTaskFailure - A Task is considered to have failed if has a failureInfo. A failureInfo is set if the Task completes with a non-zero exit code after exhausting its retry count, or if there was an error starting the Task, for example due to a resource file download error. The default is noaction. Possible values include: 'OnTaskFailureNoAction', 'OnTaskFailurePerformExitOptionsJobAction'
	OnTaskFailure        OnTaskFailure            `json:"onTaskFailure,omitempty"`
	NetworkConfiguration *JobNetworkConfiguration `json:"networkConfiguration,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata      *[]MetadataItem          `json:"metadata,omitempty"`
	ExecutionInfo *JobExecutionInformation `json:"executionInfo,omitempty"`
	// Stats - This property is populated only if the CloudJob was retrieved with an expand clause including the 'stats' attribute; otherwise it is null. The statistics may not be immediately available. The Batch service performs periodic roll-up of statistics. The typical delay is about 30 minutes.
	Stats *JobStatistics `json:"stats,omitempty"`
}

// CloudJobListPreparationAndReleaseTaskStatusResult ...
type CloudJobListPreparationAndReleaseTaskStatusResult struct {
	autorest.Response `json:"-"`
	Value             *[]JobPreparationAndReleaseTaskExecutionInformation `json:"value,omitempty"`
	OdataNextLink     *string                                             `json:"odata.nextLink,omitempty"`
}

// CloudJobListPreparationAndReleaseTaskStatusResultIterator provides access to a complete listing of
// JobPreparationAndReleaseTaskExecutionInformation values.
type CloudJobListPreparationAndReleaseTaskStatusResultIterator struct {
	i    int
	page CloudJobListPreparationAndReleaseTaskStatusResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudJobListPreparationAndReleaseTaskStatusResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudJobListPreparationAndReleaseTaskStatusResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CloudJobListPreparationAndReleaseTaskStatusResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudJobListPreparationAndReleaseTaskStatusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudJobListPreparationAndReleaseTaskStatusResultIterator) Response() CloudJobListPreparationAndReleaseTaskStatusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudJobListPreparationAndReleaseTaskStatusResultIterator) Value() JobPreparationAndReleaseTaskExecutionInformation {
	if !iter.page.NotDone() {
		return JobPreparationAndReleaseTaskExecutionInformation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CloudJobListPreparationAndReleaseTaskStatusResultIterator type.
func NewCloudJobListPreparationAndReleaseTaskStatusResultIterator(page CloudJobListPreparationAndReleaseTaskStatusResultPage) CloudJobListPreparationAndReleaseTaskStatusResultIterator {
	return CloudJobListPreparationAndReleaseTaskStatusResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cjlpartsr CloudJobListPreparationAndReleaseTaskStatusResult) IsEmpty() bool {
	return cjlpartsr.Value == nil || len(*cjlpartsr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cjlpartsr CloudJobListPreparationAndReleaseTaskStatusResult) hasNextLink() bool {
	return cjlpartsr.OdataNextLink != nil && len(*cjlpartsr.OdataNextLink) != 0
}

// cloudJobListPreparationAndReleaseTaskStatusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cjlpartsr CloudJobListPreparationAndReleaseTaskStatusResult) cloudJobListPreparationAndReleaseTaskStatusResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cjlpartsr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cjlpartsr.OdataNextLink)))
}

// CloudJobListPreparationAndReleaseTaskStatusResultPage contains a page of
// JobPreparationAndReleaseTaskExecutionInformation values.
type CloudJobListPreparationAndReleaseTaskStatusResultPage struct {
	fn        func(context.Context, CloudJobListPreparationAndReleaseTaskStatusResult) (CloudJobListPreparationAndReleaseTaskStatusResult, error)
	cjlpartsr CloudJobListPreparationAndReleaseTaskStatusResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudJobListPreparationAndReleaseTaskStatusResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudJobListPreparationAndReleaseTaskStatusResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cjlpartsr)
		if err != nil {
			return err
		}
		page.cjlpartsr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CloudJobListPreparationAndReleaseTaskStatusResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudJobListPreparationAndReleaseTaskStatusResultPage) NotDone() bool {
	return !page.cjlpartsr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudJobListPreparationAndReleaseTaskStatusResultPage) Response() CloudJobListPreparationAndReleaseTaskStatusResult {
	return page.cjlpartsr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudJobListPreparationAndReleaseTaskStatusResultPage) Values() []JobPreparationAndReleaseTaskExecutionInformation {
	if page.cjlpartsr.IsEmpty() {
		return nil
	}
	return *page.cjlpartsr.Value
}

// Creates a new instance of the CloudJobListPreparationAndReleaseTaskStatusResultPage type.
func NewCloudJobListPreparationAndReleaseTaskStatusResultPage(getNextPage func(context.Context, CloudJobListPreparationAndReleaseTaskStatusResult) (CloudJobListPreparationAndReleaseTaskStatusResult, error)) CloudJobListPreparationAndReleaseTaskStatusResultPage {
	return CloudJobListPreparationAndReleaseTaskStatusResultPage{fn: getNextPage}
}

// CloudJobListResult ...
type CloudJobListResult struct {
	autorest.Response `json:"-"`
	Value             *[]CloudJob `json:"value,omitempty"`
	OdataNextLink     *string     `json:"odata.nextLink,omitempty"`
}

// CloudJobListResultIterator provides access to a complete listing of CloudJob values.
type CloudJobListResultIterator struct {
	i    int
	page CloudJobListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudJobListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudJobListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CloudJobListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudJobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudJobListResultIterator) Response() CloudJobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudJobListResultIterator) Value() CloudJob {
	if !iter.page.NotDone() {
		return CloudJob{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CloudJobListResultIterator type.
func NewCloudJobListResultIterator(page CloudJobListResultPage) CloudJobListResultIterator {
	return CloudJobListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cjlr CloudJobListResult) IsEmpty() bool {
	return cjlr.Value == nil || len(*cjlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cjlr CloudJobListResult) hasNextLink() bool {
	return cjlr.OdataNextLink != nil && len(*cjlr.OdataNextLink) != 0
}

// cloudJobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cjlr CloudJobListResult) cloudJobListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cjlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cjlr.OdataNextLink)))
}

// CloudJobListResultPage contains a page of CloudJob values.
type CloudJobListResultPage struct {
	fn   func(context.Context, CloudJobListResult) (CloudJobListResult, error)
	cjlr CloudJobListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudJobListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudJobListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cjlr)
		if err != nil {
			return err
		}
		page.cjlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CloudJobListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudJobListResultPage) NotDone() bool {
	return !page.cjlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudJobListResultPage) Response() CloudJobListResult {
	return page.cjlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudJobListResultPage) Values() []CloudJob {
	if page.cjlr.IsEmpty() {
		return nil
	}
	return *page.cjlr.Value
}

// Creates a new instance of the CloudJobListResultPage type.
func NewCloudJobListResultPage(getNextPage func(context.Context, CloudJobListResult) (CloudJobListResult, error)) CloudJobListResultPage {
	return CloudJobListResultPage{fn: getNextPage}
}

// CloudJobSchedule ...
type CloudJobSchedule struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	DisplayName       *string `json:"displayName,omitempty"`
	URL               *string `json:"url,omitempty"`
	// ETag - This is an opaque string. You can use it to detect whether the Job Schedule has changed between requests. In particular, you can be pass the ETag with an Update Job Schedule request to specify that your changes should take effect only if nobody else has modified the schedule in the meantime.
	ETag *string `json:"eTag,omitempty"`
	// LastModified - This is the last time at which the schedule level data, such as the Job specification or recurrence information, changed. It does not factor in job-level changes such as new Jobs being created or Jobs changing state.
	LastModified *date.Time `json:"lastModified,omitempty"`
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// State - Possible values include: 'JobScheduleStateActive', 'JobScheduleStateCompleted', 'JobScheduleStateDisabled', 'JobScheduleStateTerminating', 'JobScheduleStateDeleting'
	State               JobScheduleState `json:"state,omitempty"`
	StateTransitionTime *date.Time       `json:"stateTransitionTime,omitempty"`
	// PreviousState - This property is not present if the Job Schedule is in its initial active state. Possible values include: 'JobScheduleStateActive', 'JobScheduleStateCompleted', 'JobScheduleStateDisabled', 'JobScheduleStateTerminating', 'JobScheduleStateDeleting'
	PreviousState JobScheduleState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - This property is not present if the Job Schedule is in its initial active state.
	PreviousStateTransitionTime *date.Time                       `json:"previousStateTransitionTime,omitempty"`
	Schedule                    *Schedule                        `json:"schedule,omitempty"`
	JobSpecification            *JobSpecification                `json:"jobSpecification,omitempty"`
	ExecutionInfo               *JobScheduleExecutionInformation `json:"executionInfo,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata *[]MetadataItem        `json:"metadata,omitempty"`
	Stats    *JobScheduleStatistics `json:"stats,omitempty"`
}

// CloudJobScheduleListResult ...
type CloudJobScheduleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]CloudJobSchedule `json:"value,omitempty"`
	OdataNextLink     *string             `json:"odata.nextLink,omitempty"`
}

// CloudJobScheduleListResultIterator provides access to a complete listing of CloudJobSchedule values.
type CloudJobScheduleListResultIterator struct {
	i    int
	page CloudJobScheduleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudJobScheduleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudJobScheduleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CloudJobScheduleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudJobScheduleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudJobScheduleListResultIterator) Response() CloudJobScheduleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudJobScheduleListResultIterator) Value() CloudJobSchedule {
	if !iter.page.NotDone() {
		return CloudJobSchedule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CloudJobScheduleListResultIterator type.
func NewCloudJobScheduleListResultIterator(page CloudJobScheduleListResultPage) CloudJobScheduleListResultIterator {
	return CloudJobScheduleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cjslr CloudJobScheduleListResult) IsEmpty() bool {
	return cjslr.Value == nil || len(*cjslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cjslr CloudJobScheduleListResult) hasNextLink() bool {
	return cjslr.OdataNextLink != nil && len(*cjslr.OdataNextLink) != 0
}

// cloudJobScheduleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cjslr CloudJobScheduleListResult) cloudJobScheduleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cjslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cjslr.OdataNextLink)))
}

// CloudJobScheduleListResultPage contains a page of CloudJobSchedule values.
type CloudJobScheduleListResultPage struct {
	fn    func(context.Context, CloudJobScheduleListResult) (CloudJobScheduleListResult, error)
	cjslr CloudJobScheduleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudJobScheduleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudJobScheduleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cjslr)
		if err != nil {
			return err
		}
		page.cjslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CloudJobScheduleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudJobScheduleListResultPage) NotDone() bool {
	return !page.cjslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudJobScheduleListResultPage) Response() CloudJobScheduleListResult {
	return page.cjslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudJobScheduleListResultPage) Values() []CloudJobSchedule {
	if page.cjslr.IsEmpty() {
		return nil
	}
	return *page.cjslr.Value
}

// Creates a new instance of the CloudJobScheduleListResultPage type.
func NewCloudJobScheduleListResultPage(getNextPage func(context.Context, CloudJobScheduleListResult) (CloudJobScheduleListResult, error)) CloudJobScheduleListResultPage {
	return CloudJobScheduleListResultPage{fn: getNextPage}
}

// CloudPool ...
type CloudPool struct {
	autorest.Response `json:"-"`
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not have two IDs within an Account that differ only by case).
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	URL         *string `json:"url,omitempty"`
	// ETag - This is an opaque string. You can use it to detect whether the Pool has changed between requests. In particular, you can be pass the ETag when updating a Pool to specify that your changes should take effect only if nobody else has modified the Pool in the meantime.
	ETag *string `json:"eTag,omitempty"`
	// LastModified - This is the last time at which the Pool level data, such as the targetDedicatedNodes or enableAutoscale settings, changed. It does not factor in node-level changes such as a Compute Node changing state.
	LastModified *date.Time `json:"lastModified,omitempty"`
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// State - Possible values include: 'PoolStateActive', 'PoolStateDeleting'
	State               PoolState  `json:"state,omitempty"`
	StateTransitionTime *date.Time `json:"stateTransitionTime,omitempty"`
	// AllocationState - Possible values include: 'Steady', 'Resizing', 'Stopping'
	AllocationState               AllocationState `json:"allocationState,omitempty"`
	AllocationStateTransitionTime *date.Time      `json:"allocationStateTransitionTime,omitempty"`
	// VMSize - For information about available sizes of virtual machines in Pools, see Choose a VM size for Compute Nodes in an Azure Batch Pool (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
	VMSize *string `json:"vmSize,omitempty"`
	// CloudServiceConfiguration - This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch Account was created with its poolAllocationMode property set to 'UserSubscription'.
	CloudServiceConfiguration *CloudServiceConfiguration `json:"cloudServiceConfiguration,omitempty"`
	// VirtualMachineConfiguration - This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
	// ResizeTimeout - This is the timeout for the most recent resize operation. (The initial sizing when the Pool is created counts as a resize.) The default value is 15 minutes.
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// ResizeErrors - This property is set only if one or more errors occurred during the last Pool resize, and only when the Pool allocationState is Steady.
	ResizeErrors          *[]ResizeError `json:"resizeErrors,omitempty"`
	CurrentDedicatedNodes *int32         `json:"currentDedicatedNodes,omitempty"`
	// CurrentLowPriorityNodes - Low-priority Compute Nodes which have been preempted are included in this count.
	CurrentLowPriorityNodes *int32 `json:"currentLowPriorityNodes,omitempty"`
	TargetDedicatedNodes    *int32 `json:"targetDedicatedNodes,omitempty"`
	TargetLowPriorityNodes  *int32 `json:"targetLowPriorityNodes,omitempty"`
	// EnableAutoScale - If false, at least one of targetDedicateNodes and targetLowPriorityNodes must be specified. If true, the autoScaleFormula property is required and the Pool automatically resizes according to the formula. The default value is false.
	EnableAutoScale *bool `json:"enableAutoScale,omitempty"`
	// AutoScaleFormula - This property is set only if the Pool automatically scales, i.e. enableAutoScale is true.
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
	// AutoScaleEvaluationInterval - This property is set only if the Pool automatically scales, i.e. enableAutoScale is true.
	AutoScaleEvaluationInterval *string `json:"autoScaleEvaluationInterval,omitempty"`
	// AutoScaleRun - This property is set only if the Pool automatically scales, i.e. enableAutoScale is true.
	AutoScaleRun *AutoScaleRun `json:"autoScaleRun,omitempty"`
	// EnableInterNodeCommunication - This imposes restrictions on which Compute Nodes can be assigned to the Pool. Specifying this value can reduce the chance of the requested number of Compute Nodes to be allocated in the Pool.
	EnableInterNodeCommunication *bool                 `json:"enableInterNodeCommunication,omitempty"`
	NetworkConfiguration         *NetworkConfiguration `json:"networkConfiguration,omitempty"`
	StartTask                    *StartTask            `json:"startTask,omitempty"`
	// CertificateReferences - For Windows Nodes, the Batch service installs the Certificates to the specified Certificate store and location. For Linux Compute Nodes, the Certificates are stored in a directory inside the Task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the Task to query for this location. For Certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and Certificates are placed in that directory.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// ApplicationPackageReferences - Changes to Package references affect all new Nodes joining the Pool, but do not affect Compute Nodes that are already in the Pool until they are rebooted or reimaged. There is a maximum of 10 Package references on any given Pool.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// ApplicationLicenses - The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, Pool creation will fail.
	ApplicationLicenses *[]string `json:"applicationLicenses,omitempty"`
	// MaxTasksPerNode - The default value is 1. The maximum value is the smaller of 4 times the number of cores of the vmSize of the Pool or 256.
	MaxTasksPerNode *int32 `json:"maxTasksPerNode,omitempty"`
	// TaskSchedulingPolicy - If not specified, the default is spread.
	TaskSchedulingPolicy *TaskSchedulingPolicy `json:"taskSchedulingPolicy,omitempty"`
	UserAccounts         *[]UserAccount        `json:"userAccounts,omitempty"`
	Metadata             *[]MetadataItem       `json:"metadata,omitempty"`
	// Stats - This property is populated only if the CloudPool was retrieved with an expand clause including the 'stats' attribute; otherwise it is null. The statistics may not be immediately available. The Batch service performs periodic roll-up of statistics. The typical delay is about 30 minutes.
	Stats *PoolStatistics `json:"stats,omitempty"`
	// MountConfiguration - This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
	MountConfiguration *[]MountConfiguration `json:"mountConfiguration,omitempty"`
}

// CloudPoolListResult ...
type CloudPoolListResult struct {
	autorest.Response `json:"-"`
	Value             *[]CloudPool `json:"value,omitempty"`
	OdataNextLink     *string      `json:"odata.nextLink,omitempty"`
}

// CloudPoolListResultIterator provides access to a complete listing of CloudPool values.
type CloudPoolListResultIterator struct {
	i    int
	page CloudPoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudPoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudPoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CloudPoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudPoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudPoolListResultIterator) Response() CloudPoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudPoolListResultIterator) Value() CloudPool {
	if !iter.page.NotDone() {
		return CloudPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CloudPoolListResultIterator type.
func NewCloudPoolListResultIterator(page CloudPoolListResultPage) CloudPoolListResultIterator {
	return CloudPoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cplr CloudPoolListResult) IsEmpty() bool {
	return cplr.Value == nil || len(*cplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cplr CloudPoolListResult) hasNextLink() bool {
	return cplr.OdataNextLink != nil && len(*cplr.OdataNextLink) != 0
}

// cloudPoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cplr CloudPoolListResult) cloudPoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cplr.OdataNextLink)))
}

// CloudPoolListResultPage contains a page of CloudPool values.
type CloudPoolListResultPage struct {
	fn   func(context.Context, CloudPoolListResult) (CloudPoolListResult, error)
	cplr CloudPoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudPoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudPoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cplr)
		if err != nil {
			return err
		}
		page.cplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CloudPoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudPoolListResultPage) NotDone() bool {
	return !page.cplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudPoolListResultPage) Response() CloudPoolListResult {
	return page.cplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudPoolListResultPage) Values() []CloudPool {
	if page.cplr.IsEmpty() {
		return nil
	}
	return *page.cplr.Value
}

// Creates a new instance of the CloudPoolListResultPage type.
func NewCloudPoolListResultPage(getNextPage func(context.Context, CloudPoolListResult) (CloudPoolListResult, error)) CloudPoolListResultPage {
	return CloudPoolListResultPage{fn: getNextPage}
}

// CloudServiceConfiguration ...
type CloudServiceConfiguration struct {
	// OsFamily - Possible values are:
	// 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1.
	// 3 - OS Family 3, equivalent to Windows Server 2012.
	// 4 - OS Family 4, equivalent to Windows Server 2012 R2.
	// 5 - OS Family 5, equivalent to Windows Server 2016.
	// 6 - OS Family 6, equivalent to Windows Server 2019. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
	OsFamily *string `json:"osFamily,omitempty"`
	// OsVersion - The default value is * which specifies the latest operating system version for the specified OS family.
	OsVersion *string `json:"osVersion,omitempty"`
}

// CloudTask batch will retry Tasks when a recovery operation is triggered on a Node. Examples of recovery
// operations include (but are not limited to) when an unhealthy Node is rebooted or a Compute Node disappeared
// due to host failure. Retries due to recovery operations are independent of and are not counted against the
// maxTaskRetryCount. Even if the maxTaskRetryCount is 0, an internal retry due to a recovery operation may
// occur. Because of this, all Tasks should be idempotent. This means Tasks need to tolerate being interrupted
// and restarted without causing any corruption or duplicate data. The best practice for long running Tasks is
// to use some form of checkpointing.
type CloudTask struct {
	autorest.Response `json:"-"`
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters.
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	URL         *string `json:"url,omitempty"`
	// ETag - This is an opaque string. You can use it to detect whether the Task has changed between requests. In particular, you can be pass the ETag when updating a Task to specify that your changes should take effect only if nobody else has modified the Task in the meantime.
	ETag         *string    `json:"eTag,omitempty"`
	LastModified *date.Time `json:"lastModified,omitempty"`
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ExitConditions - How the Batch service should respond when the Task completes.
	ExitConditions *ExitConditions `json:"exitConditions,omitempty"`
	// State - Possible values include: 'TaskStateActive', 'TaskStatePreparing', 'TaskStateRunning', 'TaskStateCompleted'
	State               TaskState  `json:"state,omitempty"`
	StateTransitionTime *date.Time `json:"stateTransitionTime,omitempty"`
	// PreviousState - This property is not set if the Task is in its initial Active state. Possible values include: 'TaskStateActive', 'TaskStatePreparing', 'TaskStateRunning', 'TaskStateCompleted'
	PreviousState TaskState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - This property is not set if the Task is in its initial Active state.
	PreviousStateTransitionTime *date.Time `json:"previousStateTransitionTime,omitempty"`
	// CommandLine - For multi-instance Tasks, the command line is executed as the primary Task, after the primary Task and all subtasks have finished executing the coordination command line. The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. If the command line refers to file paths, it should use a relative path (relative to the Task working directory), or use the Batch provided environment variable (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
	CommandLine *string `json:"commandLine,omitempty"`
	// ContainerSettings - If the Pool that will run this Task has containerConfiguration set, this must be set as well. If the Pool that will run this Task doesn't have containerConfiguration set, this must not be set. When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all Task environment variables are mapped into the container, and the Task command line is executed in the container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host disk, meaning that Batch file APIs will not be able to access those files.
	ContainerSettings *TaskContainerSettings `json:"containerSettings,omitempty"`
	// ResourceFiles - For multi-instance Tasks, the resource files will only be downloaded to the Compute Node on which the primary Task is executed. There is a maximum size for the list of resource files.  When the max size is exceeded, the request will fail and the response error code will be RequestEntityTooLarge. If this occurs, the collection of ResourceFiles must be reduced in size. This can be achieved using .zip files, Application Packages, or Docker Containers.
	ResourceFiles *[]ResourceFile `json:"resourceFiles,omitempty"`
	// OutputFiles - For multi-instance Tasks, the files will only be uploaded from the Compute Node on which the primary Task is executed.
	OutputFiles         *[]OutputFile         `json:"outputFiles,omitempty"`
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	AffinityInfo        *AffinityInformation  `json:"affinityInfo,omitempty"`
	Constraints         *TaskConstraints      `json:"constraints,omitempty"`
	// UserIdentity - If omitted, the Task runs as a non-administrative user unique to the Task.
	UserIdentity          *UserIdentity             `json:"userIdentity,omitempty"`
	ExecutionInfo         *TaskExecutionInformation `json:"executionInfo,omitempty"`
	NodeInfo              *ComputeNodeInformation   `json:"nodeInfo,omitempty"`
	MultiInstanceSettings *MultiInstanceSettings    `json:"multiInstanceSettings,omitempty"`
	Stats                 *TaskStatistics           `json:"stats,omitempty"`
	// DependsOn - This Task will not be scheduled until all Tasks that it depends on have completed successfully. If any of those Tasks fail and exhaust their retry counts, this Task will never be scheduled.
	DependsOn *TaskDependencies `json:"dependsOn,omitempty"`
	// ApplicationPackageReferences - Application packages are downloaded and deployed to a shared directory, not the Task working directory. Therefore, if a referenced package is already on the Node, and is up to date, then it is not re-downloaded; the existing copy on the Compute Node is used. If a referenced Package cannot be installed, for example because the package has been deleted or because download failed, the Task fails.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// AuthenticationTokenSettings - If this property is set, the Batch service provides the Task with an authentication token which can be used to authenticate Batch service operations without requiring an Account access key. The token is provided via the AZ_BATCH_AUTHENTICATION_TOKEN environment variable. The operations that the Task can carry out using the token depend on the settings. For example, a Task can request Job permissions in order to add other Tasks to the Job, or check the status of the Job or of other Tasks under the Job.
	AuthenticationTokenSettings *AuthenticationTokenSettings `json:"authenticationTokenSettings,omitempty"`
}

// CloudTaskListResult ...
type CloudTaskListResult struct {
	autorest.Response `json:"-"`
	Value             *[]CloudTask `json:"value,omitempty"`
	OdataNextLink     *string      `json:"odata.nextLink,omitempty"`
}

// CloudTaskListResultIterator provides access to a complete listing of CloudTask values.
type CloudTaskListResultIterator struct {
	i    int
	page CloudTaskListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudTaskListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudTaskListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CloudTaskListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudTaskListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudTaskListResultIterator) Response() CloudTaskListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudTaskListResultIterator) Value() CloudTask {
	if !iter.page.NotDone() {
		return CloudTask{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CloudTaskListResultIterator type.
func NewCloudTaskListResultIterator(page CloudTaskListResultPage) CloudTaskListResultIterator {
	return CloudTaskListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ctlr CloudTaskListResult) IsEmpty() bool {
	return ctlr.Value == nil || len(*ctlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ctlr CloudTaskListResult) hasNextLink() bool {
	return ctlr.OdataNextLink != nil && len(*ctlr.OdataNextLink) != 0
}

// cloudTaskListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ctlr CloudTaskListResult) cloudTaskListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ctlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ctlr.OdataNextLink)))
}

// CloudTaskListResultPage contains a page of CloudTask values.
type CloudTaskListResultPage struct {
	fn   func(context.Context, CloudTaskListResult) (CloudTaskListResult, error)
	ctlr CloudTaskListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudTaskListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudTaskListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ctlr)
		if err != nil {
			return err
		}
		page.ctlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CloudTaskListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudTaskListResultPage) NotDone() bool {
	return !page.ctlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudTaskListResultPage) Response() CloudTaskListResult {
	return page.ctlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudTaskListResultPage) Values() []CloudTask {
	if page.ctlr.IsEmpty() {
		return nil
	}
	return *page.ctlr.Value
}

// Creates a new instance of the CloudTaskListResultPage type.
func NewCloudTaskListResultPage(getNextPage func(context.Context, CloudTaskListResult) (CloudTaskListResult, error)) CloudTaskListResultPage {
	return CloudTaskListResultPage{fn: getNextPage}
}

// CloudTaskListSubtasksResult ...
type CloudTaskListSubtasksResult struct {
	autorest.Response `json:"-"`
	Value             *[]SubtaskInformation `json:"value,omitempty"`
}

// ComputeNode ...
type ComputeNode struct {
	autorest.Response `json:"-"`
	// ID - Every Compute Node that is added to a Pool is assigned a unique ID. Whenever a Compute Node is removed from a Pool, all of its local files are deleted, and the ID is reclaimed and could be reused for new Compute Nodes.
	ID  *string `json:"id,omitempty"`
	URL *string `json:"url,omitempty"`
	// State - The low-priority Compute Node has been preempted. Tasks which were running on the Compute Node when it was preempted will be rescheduled when another Compute Node becomes available. Possible values include: 'Idle', 'Rebooting', 'Reimaging', 'Running', 'Unusable', 'Creating', 'Starting', 'WaitingForStartTask', 'StartTaskFailed', 'Unknown', 'LeavingPool', 'Offline', 'Preempted'
	State ComputeNodeState `json:"state,omitempty"`
	// SchedulingState - Possible values include: 'Enabled', 'Disabled'
	SchedulingState     SchedulingState `json:"schedulingState,omitempty"`
	StateTransitionTime *date.Time      `json:"stateTransitionTime,omitempty"`
	// LastBootTime - This property may not be present if the Compute Node state is unusable.
	LastBootTime *date.Time `json:"lastBootTime,omitempty"`
	// AllocationTime - This is the time when the Compute Node was initially allocated and doesn't change once set. It is not updated when the Compute Node is service healed or preempted.
	AllocationTime *date.Time `json:"allocationTime,omitempty"`
	// IPAddress - Every Compute Node that is added to a Pool is assigned a unique IP address. Whenever a Compute Node is removed from a Pool, all of its local files are deleted, and the IP address is reclaimed and could be reused for new Compute Nodes.
	IPAddress *string `json:"ipAddress,omitempty"`
	// AffinityID - Note that this is just a soft affinity. If the target Compute Node is busy or unavailable at the time the Task is scheduled, then the Task will be scheduled elsewhere.
	AffinityID *string `json:"affinityId,omitempty"`
	// VMSize - For information about available sizes of virtual machines in Pools, see Choose a VM size for Compute Nodes in an Azure Batch Pool (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
	VMSize              *string `json:"vmSize,omitempty"`
	TotalTasksRun       *int32  `json:"totalTasksRun,omitempty"`
	RunningTasksCount   *int32  `json:"runningTasksCount,omitempty"`
	TotalTasksSucceeded *int32  `json:"totalTasksSucceeded,omitempty"`
	// RecentTasks - This property is present only if at least one Task has run on this Compute Node since it was assigned to the Pool.
	RecentTasks   *[]TaskInformation    `json:"recentTasks,omitempty"`
	StartTask     *StartTask            `json:"startTask,omitempty"`
	StartTaskInfo *StartTaskInformation `json:"startTaskInfo,omitempty"`
	// CertificateReferences - For Windows Nodes, the Batch service installs the Certificates to the specified Certificate store and location. For Linux Compute Nodes, the Certificates are stored in a directory inside the Task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the Task to query for this location. For Certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and Certificates are placed in that directory.
	CertificateReferences *[]CertificateReference           `json:"certificateReferences,omitempty"`
	Errors                *[]ComputeNodeError               `json:"errors,omitempty"`
	IsDedicated           *bool                             `json:"isDedicated,omitempty"`
	EndpointConfiguration *ComputeNodeEndpointConfiguration `json:"endpointConfiguration,omitempty"`
	NodeAgentInfo         *NodeAgentInformation             `json:"nodeAgentInfo,omitempty"`
}

// ComputeNodeEndpointConfiguration ...
type ComputeNodeEndpointConfiguration struct {
	InboundEndpoints *[]InboundEndpoint `json:"inboundEndpoints,omitempty"`
}

// ComputeNodeError ...
type ComputeNodeError struct {
	Code         *string          `json:"code,omitempty"`
	Message      *string          `json:"message,omitempty"`
	ErrorDetails *[]NameValuePair `json:"errorDetails,omitempty"`
}

// ComputeNodeGetRemoteLoginSettingsResult ...
type ComputeNodeGetRemoteLoginSettingsResult struct {
	autorest.Response    `json:"-"`
	RemoteLoginIPAddress *string `json:"remoteLoginIPAddress,omitempty"`
	RemoteLoginPort      *int32  `json:"remoteLoginPort,omitempty"`
}

// ComputeNodeInformation ...
type ComputeNodeInformation struct {
	AffinityID           *string `json:"affinityId,omitempty"`
	NodeURL              *string `json:"nodeUrl,omitempty"`
	PoolID               *string `json:"poolId,omitempty"`
	NodeID               *string `json:"nodeId,omitempty"`
	TaskRootDirectory    *string `json:"taskRootDirectory,omitempty"`
	TaskRootDirectoryURL *string `json:"taskRootDirectoryUrl,omitempty"`
}

// ComputeNodeListResult ...
type ComputeNodeListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ComputeNode `json:"value,omitempty"`
	OdataNextLink     *string        `json:"odata.nextLink,omitempty"`
}

// ComputeNodeListResultIterator provides access to a complete listing of ComputeNode values.
type ComputeNodeListResultIterator struct {
	i    int
	page ComputeNodeListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ComputeNodeListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComputeNodeListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ComputeNodeListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ComputeNodeListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ComputeNodeListResultIterator) Response() ComputeNodeListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ComputeNodeListResultIterator) Value() ComputeNode {
	if !iter.page.NotDone() {
		return ComputeNode{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ComputeNodeListResultIterator type.
func NewComputeNodeListResultIterator(page ComputeNodeListResultPage) ComputeNodeListResultIterator {
	return ComputeNodeListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cnlr ComputeNodeListResult) IsEmpty() bool {
	return cnlr.Value == nil || len(*cnlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cnlr ComputeNodeListResult) hasNextLink() bool {
	return cnlr.OdataNextLink != nil && len(*cnlr.OdataNextLink) != 0
}

// computeNodeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cnlr ComputeNodeListResult) computeNodeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cnlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cnlr.OdataNextLink)))
}

// ComputeNodeListResultPage contains a page of ComputeNode values.
type ComputeNodeListResultPage struct {
	fn   func(context.Context, ComputeNodeListResult) (ComputeNodeListResult, error)
	cnlr ComputeNodeListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ComputeNodeListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComputeNodeListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cnlr)
		if err != nil {
			return err
		}
		page.cnlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ComputeNodeListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ComputeNodeListResultPage) NotDone() bool {
	return !page.cnlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ComputeNodeListResultPage) Response() ComputeNodeListResult {
	return page.cnlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ComputeNodeListResultPage) Values() []ComputeNode {
	if page.cnlr.IsEmpty() {
		return nil
	}
	return *page.cnlr.Value
}

// Creates a new instance of the ComputeNodeListResultPage type.
func NewComputeNodeListResultPage(getNextPage func(context.Context, ComputeNodeListResult) (ComputeNodeListResult, error)) ComputeNodeListResultPage {
	return ComputeNodeListResultPage{fn: getNextPage}
}

// ComputeNodeUser ...
type ComputeNodeUser struct {
	Name *string `json:"name,omitempty"`
	// IsAdmin - The default value is false.
	IsAdmin *bool `json:"isAdmin,omitempty"`
	// ExpiryTime - If omitted, the default is 1 day from the current time. For Linux Compute Nodes, the expiryTime has a precision up to a day.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// Password - The password is required for Windows Compute Nodes (those created with 'cloudServiceConfiguration', or created with 'virtualMachineConfiguration' using a Windows Image reference). For Linux Compute Nodes, the password can optionally be specified along with the sshPublicKey property.
	Password *string `json:"password,omitempty"`
	// SSHPublicKey - The public key should be compatible with OpenSSH encoding and should be base 64 encoded. This property can be specified only for Linux Compute Nodes. If this is specified for a Windows Compute Node, then the Batch service rejects the request; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	SSHPublicKey *string `json:"sshPublicKey,omitempty"`
}

// ContainerConfiguration ...
type ContainerConfiguration struct {
	Type *string `json:"type,omitempty"`
	// ContainerImageNames - This is the full Image reference, as would be specified to "docker pull". An Image will be sourced from the default Docker registry unless the Image is fully qualified with an alternative registry.
	ContainerImageNames *[]string `json:"containerImageNames,omitempty"`
	// ContainerRegistries - If any Images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
	ContainerRegistries *[]ContainerRegistry `json:"containerRegistries,omitempty"`
}

// ContainerRegistry ...
type ContainerRegistry struct {
	// RegistryServer - If omitted, the default is "docker.io".
	RegistryServer *string `json:"registryServer,omitempty"`
	UserName       *string `json:"username,omitempty"`
	Password       *string `json:"password,omitempty"`
}

// DataDisk ...
type DataDisk struct {
	// Lun - The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun.
	Lun *int32 `json:"lun,omitempty"`
	// Caching - The default value for caching is readwrite. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/. Possible values include: 'None', 'ReadOnly', 'ReadWrite'
	Caching    CachingType `json:"caching,omitempty"`
	DiskSizeGB *int32      `json:"diskSizeGB,omitempty"`
	// StorageAccountType - If omitted, the default is "standard_lrs". Possible values include: 'StandardLRS', 'PremiumLRS'
	StorageAccountType StorageAccountType `json:"storageAccountType,omitempty"`
}

// DeleteCertificateError ...
type DeleteCertificateError struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
	// Values - This list includes details such as the active Pools and Compute Nodes referencing this Certificate. However, if a large number of resources reference the Certificate, the list contains only about the first hundred.
	Values *[]NameValuePair `json:"values,omitempty"`
}

// DiskEncryptionConfiguration the disk encryption configuration applied on compute nodes in the pool. Disk
// encryption configuration is not supported on Linux pool created with Shared Image Gallery Image.
type DiskEncryptionConfiguration struct {
	// Targets - If omitted, no disks on the compute nodes in the pool will be encrypted. On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
	Targets *[]DiskEncryptionTarget `json:"targets,omitempty"`
}

// EnvironmentSetting ...
type EnvironmentSetting struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// Error ...
type Error struct {
	Code    *string        `json:"code,omitempty"`
	Message *ErrorMessage  `json:"message,omitempty"`
	Values  *[]ErrorDetail `json:"values,omitempty"`
}

// ErrorDetail ...
type ErrorDetail struct {
	Key   *string `json:"key,omitempty"`
	Value *string `json:"value,omitempty"`
}

// ErrorMessage ...
type ErrorMessage struct {
	Lang  *string `json:"lang,omitempty"`
	Value *string `json:"value,omitempty"`
}

// ExitCodeMapping ...
type ExitCodeMapping struct {
	Code        *int32       `json:"code,omitempty"`
	ExitOptions *ExitOptions `json:"exitOptions,omitempty"`
}

// ExitCodeRangeMapping ...
type ExitCodeRangeMapping struct {
	Start       *int32       `json:"start,omitempty"`
	End         *int32       `json:"end,omitempty"`
	ExitOptions *ExitOptions `json:"exitOptions,omitempty"`
}

// ExitConditions ...
type ExitConditions struct {
	ExitCodes          *[]ExitCodeMapping      `json:"exitCodes,omitempty"`
	ExitCodeRanges     *[]ExitCodeRangeMapping `json:"exitCodeRanges,omitempty"`
	PreProcessingError *ExitOptions            `json:"preProcessingError,omitempty"`
	// FileUploadError - If the Task exited with an exit code that was specified via exitCodes or exitCodeRanges, and then encountered a file upload error, then the action specified by the exit code takes precedence.
	FileUploadError *ExitOptions `json:"fileUploadError,omitempty"`
	// Default - This value is used if the Task exits with any nonzero exit code not listed in the exitCodes or exitCodeRanges collection, with a pre-processing error if the preProcessingError property is not present, or with a file upload error if the fileUploadError property is not present. If you want non-default behavior on exit code 0, you must list it explicitly using the exitCodes or exitCodeRanges collection.
	Default *ExitOptions `json:"default,omitempty"`
}

// ExitOptions ...
type ExitOptions struct {
	// JobAction - The default is none for exit code 0 and terminate for all other exit conditions. If the Job's onTaskFailed property is noaction, then specifying this property returns an error and the add Task request fails with an invalid property value error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request). Possible values include: 'JobActionNone', 'JobActionDisable', 'JobActionTerminate'
	JobAction JobAction `json:"jobAction,omitempty"`
	// DependencyAction - Possible values are 'satisfy' (allowing dependent tasks to progress) and 'block' (dependent tasks continue to wait). Batch does not yet support cancellation of dependent tasks. Possible values include: 'Satisfy', 'Block'
	DependencyAction DependencyAction `json:"dependencyAction,omitempty"`
}

// FileProperties ...
type FileProperties struct {
	// CreationTime - The creation time is not returned for files on Linux Compute Nodes.
	CreationTime  *date.Time `json:"creationTime,omitempty"`
	LastModified  *date.Time `json:"lastModified,omitempty"`
	ContentLength *int64     `json:"contentLength,omitempty"`
	ContentType   *string    `json:"contentType,omitempty"`
	// FileMode - The file mode is returned only for files on Linux Compute Nodes.
	FileMode *string `json:"fileMode,omitempty"`
}

// ImageInformation ...
type ImageInformation struct {
	NodeAgentSKUID *string         `json:"nodeAgentSKUId,omitempty"`
	ImageReference *ImageReference `json:"imageReference,omitempty"`
	// OsType - Possible values include: 'Linux', 'Windows'
	OsType OSType `json:"osType,omitempty"`
	// Capabilities - Not every capability of the Image is listed. Capabilities in this list are considered of special interest and are generally related to integration with other features in the Azure Batch service.
	Capabilities          *[]string  `json:"capabilities,omitempty"`
	BatchSupportEndOfLife *date.Time `json:"batchSupportEndOfLife,omitempty"`
	// VerificationType - Possible values include: 'Verified', 'Unverified'
	VerificationType VerificationType `json:"verificationType,omitempty"`
}

// ImageReference ...
type ImageReference struct {
	// Publisher - For example, Canonical or MicrosoftWindowsServer.
	Publisher *string `json:"publisher,omitempty"`
	// Offer - For example, UbuntuServer or WindowsServer.
	Offer *string `json:"offer,omitempty"`
	// Sku - For example, 18.04-LTS or 2019-Datacenter.
	Sku *string `json:"sku,omitempty"`
	// Version - A value of 'latest' can be specified to select the latest version of an Image. If omitted, the default is 'latest'.
	Version *string `json:"version,omitempty"`
	// VirtualMachineImageID - This property is mutually exclusive with other ImageReference properties. For Virtual Machine Image it must be in the same region and subscription as the Azure Batch account. The Shared Image Gallery Image must have replicas in the same region as the Azure Batch account. For information about the firewall settings for the Batch Compute Node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
	VirtualMachineImageID *string `json:"virtualMachineImageId,omitempty"`
}

// InboundEndpoint ...
type InboundEndpoint struct {
	Name *string `json:"name,omitempty"`
	// Protocol - Possible values include: 'TCP', 'UDP'
	Protocol        InboundEndpointProtocol `json:"protocol,omitempty"`
	PublicIPAddress *string                 `json:"publicIPAddress,omitempty"`
	PublicFQDN      *string                 `json:"publicFQDN,omitempty"`
	FrontendPort    *int32                  `json:"frontendPort,omitempty"`
	BackendPort     *int32                  `json:"backendPort,omitempty"`
}

// InboundNATPool ...
type InboundNATPool struct {
	// Name - The name must be unique within a Batch Pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values are provided the request fails with HTTP status code 400.
	Name *string `json:"name,omitempty"`
	// Protocol - Possible values include: 'TCP', 'UDP'
	Protocol InboundEndpointProtocol `json:"protocol,omitempty"`
	// BackendPort - This must be unique within a Batch Pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved values are provided the request fails with HTTP status code 400.
	BackendPort *int32 `json:"backendPort,omitempty"`
	// FrontendPortRangeStart - Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within a Pool must be distinct and cannot overlap. Each range must contain at least 40 ports. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
	FrontendPortRangeStart *int32 `json:"frontendPortRangeStart,omitempty"`
	// FrontendPortRangeEnd - Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a Pool must be distinct and cannot overlap. Each range must contain at least 40 ports. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
	FrontendPortRangeEnd *int32 `json:"frontendPortRangeEnd,omitempty"`
	// NetworkSecurityGroupRules - The maximum number of rules that can be specified across all the endpoints on a Batch Pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
	NetworkSecurityGroupRules *[]NetworkSecurityGroupRule `json:"networkSecurityGroupRules,omitempty"`
}

// JobAddParameter ...
type JobAddParameter struct {
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not have two IDs within an Account that differ only by case).
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	// Priority - Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. The default value is 0.
	Priority *int32 `json:"priority,omitempty"`
	// Constraints - The execution constraints for the Job.
	Constraints *JobConstraints `json:"constraints,omitempty"`
	// JobManagerTask - If the Job does not specify a Job Manager Task, the user must explicitly add Tasks to the Job. If the Job does specify a Job Manager Task, the Batch service creates the Job Manager Task when the Job is created, and will try to schedule the Job Manager Task before scheduling other Tasks in the Job. The Job Manager Task's typical purpose is to control and/or monitor Job execution, for example by deciding what additional Tasks to run, determining when the work is complete, etc. (However, a Job Manager Task is not restricted to these activities - it is a fully-fledged Task in the system and perform whatever actions are required for the Job.) For example, a Job Manager Task might download a file specified as a parameter, analyze the contents of that file and submit additional Tasks based on those contents.
	JobManagerTask *JobManagerTask `json:"jobManagerTask,omitempty"`
	// JobPreparationTask - If a Job has a Job Preparation Task, the Batch service will run the Job Preparation Task on a Node before starting any Tasks of that Job on that Compute Node.
	JobPreparationTask *JobPreparationTask `json:"jobPreparationTask,omitempty"`
	// JobReleaseTask - A Job Release Task cannot be specified without also specifying a Job Preparation Task for the Job. The Batch service runs the Job Release Task on the Nodes that have run the Job Preparation Task. The primary purpose of the Job Release Task is to undo changes to Compute Nodes made by the Job Preparation Task. Example activities include deleting local files, or shutting down services that were started as part of Job preparation.
	JobReleaseTask *JobReleaseTask `json:"jobReleaseTask,omitempty"`
	// CommonEnvironmentSettings - Individual Tasks can override an environment setting specified here by specifying the same setting name with a different value.
	CommonEnvironmentSettings *[]EnvironmentSetting `json:"commonEnvironmentSettings,omitempty"`
	PoolInfo                  *PoolInformation      `json:"poolInfo,omitempty"`
	// OnAllTasksComplete - Note that if a Job contains no Tasks, then all Tasks are considered complete. This option is therefore most commonly used with a Job Manager task; if you want to use automatic Job termination without a Job Manager, you should initially set onAllTasksComplete to noaction and update the Job properties to set onAllTasksComplete to terminatejob once you have finished adding Tasks. The default is noaction. Possible values include: 'NoAction', 'TerminateJob'
	OnAllTasksComplete OnAllTasksComplete `json:"onAllTasksComplete,omitempty"`
	// OnTaskFailure - A Task is considered to have failed if has a failureInfo. A failureInfo is set if the Task completes with a non-zero exit code after exhausting its retry count, or if there was an error starting the Task, for example due to a resource file download error. The default is noaction. Possible values include: 'OnTaskFailureNoAction', 'OnTaskFailurePerformExitOptionsJobAction'
	OnTaskFailure OnTaskFailure `json:"onTaskFailure,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata             *[]MetadataItem          `json:"metadata,omitempty"`
	UsesTaskDependencies *bool                    `json:"usesTaskDependencies,omitempty"`
	NetworkConfiguration *JobNetworkConfiguration `json:"networkConfiguration,omitempty"`
}

// JobConstraints ...
type JobConstraints struct {
	// MaxWallClockTime - If the Job does not complete within the time limit, the Batch service terminates it and any Tasks that are still running. In this case, the termination reason will be MaxWallClockTimeExpiry. If this property is not specified, there is no time limit on how long the Job may run.
	MaxWallClockTime *string `json:"maxWallClockTime,omitempty"`
	// MaxTaskRetryCount - Note that this value specifically controls the number of retries. The Batch service will try each Task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries a Task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry Tasks. If the maximum retry count is -1, the Batch service retries Tasks without limit. The default value is 0 (no retries).
	MaxTaskRetryCount *int32 `json:"maxTaskRetryCount,omitempty"`
}

// JobDisableParameter ...
type JobDisableParameter struct {
	// DisableTasks - Possible values include: 'DisableJobOptionRequeue', 'DisableJobOptionTerminate', 'DisableJobOptionWait'
	DisableTasks DisableJobOption `json:"disableTasks,omitempty"`
}

// JobExecutionInformation ...
type JobExecutionInformation struct {
	// StartTime - This is the time at which the Job was created.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - This property is set only if the Job is in the completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// PoolID - This element contains the actual Pool where the Job is assigned. When you get Job details from the service, they also contain a poolInfo element, which contains the Pool configuration data from when the Job was added or updated. That poolInfo element may also contain a poolId element. If it does, the two IDs are the same. If it does not, it means the Job ran on an auto Pool, and this property contains the ID of that auto Pool.
	PoolID *string `json:"poolId,omitempty"`
	// SchedulingError - This property is not set if there was no error starting the Job.
	SchedulingError *JobSchedulingError `json:"schedulingError,omitempty"`
	// TerminateReason - This property is set only if the Job is in the completed state. If the Batch service terminates the Job, it sets the reason as follows: JMComplete - the Job Manager Task completed, and killJobOnCompletion was set to true. MaxWallClockTimeExpiry - the Job reached its maxWallClockTime constraint. TerminateJobSchedule - the Job ran as part of a schedule, and the schedule terminated. AllTasksComplete - the Job's onAllTasksComplete attribute is set to terminatejob, and all Tasks in the Job are complete. TaskFailed - the Job's onTaskFailure attribute is set to performExitOptionsJobAction, and a Task in the Job failed with an exit condition that specified a jobAction of terminatejob. Any other string is a user-defined reason specified in a call to the 'Terminate a Job' operation.
	TerminateReason *string `json:"terminateReason,omitempty"`
}

// JobManagerTask the Job Manager Task is automatically started when the Job is created. The Batch service
// tries to schedule the Job Manager Task before any other Tasks in the Job. When shrinking a Pool, the Batch
// service tries to preserve Nodes where Job Manager Tasks are running for as long as possible (that is,
// Compute Nodes running 'normal' Tasks are removed before Compute Nodes running Job Manager Tasks). When a Job
// Manager Task fails and needs to be restarted, the system tries to schedule it at the highest priority. If
// there are no idle Compute Nodes available, the system may terminate one of the running Tasks in the Pool and
// return it to the queue in order to make room for the Job Manager Task to restart. Note that a Job Manager
// Task in one Job does not have priority over Tasks in other Jobs. Across Jobs, only Job level priorities are
// observed. For example, if a Job Manager in a priority 0 Job needs to be restarted, it will not displace
// Tasks of a priority 1 Job. Batch will retry Tasks when a recovery operation is triggered on a Node. Examples
// of recovery operations include (but are not limited to) when an unhealthy Node is rebooted or a Compute Node
// disappeared due to host failure. Retries due to recovery operations are independent of and are not counted
// against the maxTaskRetryCount. Even if the maxTaskRetryCount is 0, an internal retry due to a recovery
// operation may occur. Because of this, all Tasks should be idempotent. This means Tasks need to tolerate
// being interrupted and restarted without causing any corruption or duplicate data. The best practice for long
// running Tasks is to use some form of checkpointing.
type JobManagerTask struct {
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores and cannot contain more than 64 characters.
	ID *string `json:"id,omitempty"`
	// DisplayName - It need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	// CommandLine - The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. If the command line refers to file paths, it should use a relative path (relative to the Task working directory), or use the Batch provided environment variable (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
	CommandLine *string `json:"commandLine,omitempty"`
	// ContainerSettings - If the Pool that will run this Task has containerConfiguration set, this must be set as well. If the Pool that will run this Task doesn't have containerConfiguration set, this must not be set. When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all Task environment variables are mapped into the container, and the Task command line is executed in the container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host disk, meaning that Batch file APIs will not be able to access those files.
	ContainerSettings *TaskContainerSettings `json:"containerSettings,omitempty"`
	// ResourceFiles - Files listed under this element are located in the Task's working directory. There is a maximum size for the list of resource files.  When the max size is exceeded, the request will fail and the response error code will be RequestEntityTooLarge. If this occurs, the collection of ResourceFiles must be reduced in size. This can be achieved using .zip files, Application Packages, or Docker Containers.
	ResourceFiles *[]ResourceFile `json:"resourceFiles,omitempty"`
	// OutputFiles - For multi-instance Tasks, the files will only be uploaded from the Compute Node on which the primary Task is executed.
	OutputFiles         *[]OutputFile         `json:"outputFiles,omitempty"`
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	Constraints         *TaskConstraints      `json:"constraints,omitempty"`
	// KillJobOnCompletion - If true, when the Job Manager Task completes, the Batch service marks the Job as complete. If any Tasks are still running at this time (other than Job Release), those Tasks are terminated. If false, the completion of the Job Manager Task does not affect the Job status. In this case, you should either use the onAllTasksComplete attribute to terminate the Job, or have a client or user terminate the Job explicitly. An example of this is if the Job Manager creates a set of Tasks but then takes no further role in their execution. The default value is true. If you are using the onAllTasksComplete and onTaskFailure attributes to control Job lifetime, and using the Job Manager Task only to create the Tasks for the Job (not to monitor progress), then it is important to set killJobOnCompletion to false.
	KillJobOnCompletion *bool `json:"killJobOnCompletion,omitempty"`
	// UserIdentity - If omitted, the Task runs as a non-administrative user unique to the Task.
	UserIdentity *UserIdentity `json:"userIdentity,omitempty"`
	// RunExclusive - If true, no other Tasks will run on the same Node for as long as the Job Manager is running. If false, other Tasks can run simultaneously with the Job Manager on a Compute Node. The Job Manager Task counts normally against the Compute Node's concurrent Task limit, so this is only relevant if the Compute Node allows multiple concurrent Tasks. The default value is true.
	RunExclusive *bool `json:"runExclusive,omitempty"`
	// ApplicationPackageReferences - Application Packages are downloaded and deployed to a shared directory, not the Task working directory. Therefore, if a referenced Application Package is already on the Compute Node, and is up to date, then it is not re-downloaded; the existing copy on the Compute Node is used. If a referenced Application Package cannot be installed, for example because the package has been deleted or because download failed, the Task fails.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// AuthenticationTokenSettings - If this property is set, the Batch service provides the Task with an authentication token which can be used to authenticate Batch service operations without requiring an Account access key. The token is provided via the AZ_BATCH_AUTHENTICATION_TOKEN environment variable. The operations that the Task can carry out using the token depend on the settings. For example, a Task can request Job permissions in order to add other Tasks to the Job, or check the status of the Job or of other Tasks under the Job.
	AuthenticationTokenSettings *AuthenticationTokenSettings `json:"authenticationTokenSettings,omitempty"`
	// AllowLowPriorityNode - The default value is true.
	AllowLowPriorityNode *bool `json:"allowLowPriorityNode,omitempty"`
}

// JobNetworkConfiguration ...
type JobNetworkConfiguration struct {
	// SubnetID - The virtual network must be in the same region and subscription as the Azure Batch Account. The specified subnet should have enough free IP addresses to accommodate the number of Compute Nodes which will run Tasks from the Job. This can be up to the number of Compute Nodes in the Pool. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet so that Azure Batch service can schedule Tasks on the Nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the Nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the Compute Nodes to unusable. This is of the form /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication from the Azure Batch service. For Pools created with a Virtual Machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. Port 443 is also required to be open for outbound connections for communications to Azure Storage. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
	SubnetID *string `json:"subnetId,omitempty"`
}

// JobPatchParameter ...
type JobPatchParameter struct {
	// Priority - Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. If omitted, the priority of the Job is left unchanged.
	Priority *int32 `json:"priority,omitempty"`
	// OnAllTasksComplete - If omitted, the completion behavior is left unchanged. You may not change the value from terminatejob to noaction - that is, once you have engaged automatic Job termination, you cannot turn it off again. If you try to do this, the request fails with an 'invalid property value' error response; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request). Possible values include: 'NoAction', 'TerminateJob'
	OnAllTasksComplete OnAllTasksComplete `json:"onAllTasksComplete,omitempty"`
	// Constraints - If omitted, the existing execution constraints are left unchanged.
	Constraints *JobConstraints `json:"constraints,omitempty"`
	// PoolInfo - You may change the Pool for a Job only when the Job is disabled. The Patch Job call will fail if you include the poolInfo element and the Job is not disabled. If you specify an autoPoolSpecification in the poolInfo, only the keepAlive property of the autoPoolSpecification can be updated, and then only if the autoPoolSpecification has a poolLifetimeOption of Job (other job properties can be updated as normal). If omitted, the Job continues to run on its current Pool.
	PoolInfo *PoolInformation `json:"poolInfo,omitempty"`
	// Metadata - If omitted, the existing Job metadata is left unchanged.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobPreparationAndReleaseTaskExecutionInformation ...
type JobPreparationAndReleaseTaskExecutionInformation struct {
	PoolID                          *string                                 `json:"poolId,omitempty"`
	NodeID                          *string                                 `json:"nodeId,omitempty"`
	NodeURL                         *string                                 `json:"nodeUrl,omitempty"`
	JobPreparationTaskExecutionInfo *JobPreparationTaskExecutionInformation `json:"jobPreparationTaskExecutionInfo,omitempty"`
	// JobReleaseTaskExecutionInfo - This property is set only if the Job Release Task has run on the Compute Node.
	JobReleaseTaskExecutionInfo *JobReleaseTaskExecutionInformation `json:"jobReleaseTaskExecutionInfo,omitempty"`
}

// JobPreparationTask you can use Job Preparation to prepare a Node to run Tasks for the Job. Activities
// commonly performed in Job Preparation include: Downloading common resource files used by all the Tasks in
// the Job. The Job Preparation Task can download these common resource files to the shared location on the
// Node. (AZ_BATCH_NODE_ROOT_DIR\shared), or starting a local service on the Node so that all Tasks of that Job
// can communicate with it. If the Job Preparation Task fails (that is, exhausts its retry count before exiting
// with exit code 0), Batch will not run Tasks of this Job on the Node. The Compute Node remains ineligible to
// run Tasks of this Job until it is reimaged. The Compute Node remains active and can be used for other Jobs.
// The Job Preparation Task can run multiple times on the same Node. Therefore, you should write the Job
// Preparation Task to handle re-execution. If the Node is rebooted, the Job Preparation Task is run again on
// the Compute Node before scheduling any other Task of the Job, if rerunOnNodeRebootAfterSuccess is true or if
// the Job Preparation Task did not previously complete. If the Node is reimaged, the Job Preparation Task is
// run again before scheduling any Task of the Job. Batch will retry Tasks when a recovery operation is
// triggered on a Node. Examples of recovery operations include (but are not limited to) when an unhealthy Node
// is rebooted or a Compute Node disappeared due to host failure. Retries due to recovery operations are
// independent of and are not counted against the maxTaskRetryCount. Even if the maxTaskRetryCount is 0, an
// internal retry due to a recovery operation may occur. Because of this, all Tasks should be idempotent. This
// means Tasks need to tolerate being interrupted and restarted without causing any corruption or duplicate
// data. The best practice for long running Tasks is to use some form of checkpointing.
type JobPreparationTask struct {
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores and cannot contain more than 64 characters. If you do not specify this property, the Batch service assigns a default value of 'jobpreparation'. No other Task in the Job can have the same ID as the Job Preparation Task. If you try to submit a Task with the same id, the Batch service rejects the request with error code TaskIdSameAsJobPreparationTask; if you are calling the REST API directly, the HTTP status code is 409 (Conflict).
	ID *string `json:"id,omitempty"`
	// CommandLine - The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. If the command line refers to file paths, it should use a relative path (relative to the Task working directory), or use the Batch provided environment variable (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
	CommandLine *string `json:"commandLine,omitempty"`
	// ContainerSettings - When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all Task environment variables are mapped into the container, and the Task command line is executed in the container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host disk, meaning that Batch file APIs will not be able to access those files.
	ContainerSettings *TaskContainerSettings `json:"containerSettings,omitempty"`
	// ResourceFiles - Files listed under this element are located in the Task's working directory.  There is a maximum size for the list of resource files.  When the max size is exceeded, the request will fail and the response error code will be RequestEntityTooLarge. If this occurs, the collection of ResourceFiles must be reduced in size. This can be achieved using .zip files, Application Packages, or Docker Containers.
	ResourceFiles       *[]ResourceFile       `json:"resourceFiles,omitempty"`
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	Constraints         *TaskConstraints      `json:"constraints,omitempty"`
	// WaitForSuccess - If true and the Job Preparation Task fails on a Node, the Batch service retries the Job Preparation Task up to its maximum retry count (as specified in the constraints element). If the Task has still not completed successfully after all retries, then the Batch service will not schedule Tasks of the Job to the Node. The Node remains active and eligible to run Tasks of other Jobs. If false, the Batch service will not wait for the Job Preparation Task to complete. In this case, other Tasks of the Job can start executing on the Compute Node while the Job Preparation Task is still running; and even if the Job Preparation Task fails, new Tasks will continue to be scheduled on the Compute Node. The default value is true.
	WaitForSuccess *bool `json:"waitForSuccess,omitempty"`
	// UserIdentity - If omitted, the Task runs as a non-administrative user unique to the Task on Windows Compute Nodes, or a non-administrative user unique to the Pool on Linux Compute Nodes.
	UserIdentity *UserIdentity `json:"userIdentity,omitempty"`
	// RerunOnNodeRebootAfterSuccess - The Job Preparation Task is always rerun if a Compute Node is reimaged, or if the Job Preparation Task did not complete (e.g. because the reboot occurred while the Task was running). Therefore, you should always write a Job Preparation Task to be idempotent and to behave correctly if run multiple times. The default value is true.
	RerunOnNodeRebootAfterSuccess *bool `json:"rerunOnNodeRebootAfterSuccess,omitempty"`
}

// JobPreparationTaskExecutionInformation ...
type JobPreparationTaskExecutionInformation struct {
	// StartTime - If the Task has been restarted or retried, this is the most recent time at which the Task started running.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - This property is set only if the Task is in the Completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// State - Possible values include: 'JobPreparationTaskStateRunning', 'JobPreparationTaskStateCompleted'
	State                JobPreparationTaskState `json:"state,omitempty"`
	TaskRootDirectory    *string                 `json:"taskRootDirectory,omitempty"`
	TaskRootDirectoryURL *string                 `json:"taskRootDirectoryUrl,omitempty"`
	// ExitCode - This parameter is returned only if the Task is in the completed state. The exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. Note that the exit code may also be generated by the Compute Node operating system, such as when a process is forcibly terminated.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// ContainerInfo - This property is set only if the Task runs in a container context.
	ContainerInfo *TaskContainerExecutionInformation `json:"containerInfo,omitempty"`
	// FailureInfo - This property is set only if the Task is in the completed state and encountered a failure.
	FailureInfo *TaskFailureInformation `json:"failureInfo,omitempty"`
	// RetryCount - Task application failures (non-zero exit code) are retried, pre-processing errors (the Task could not be run) and file upload errors are not retried. The Batch service will retry the Task up to the limit specified by the constraints.
	RetryCount *int32 `json:"retryCount,omitempty"`
	// LastRetryTime - This property is set only if the Task was retried (i.e. retryCount is nonzero). If present, this is typically the same as startTime, but may be different if the Task has been restarted for reasons other than retry; for example, if the Compute Node was rebooted during a retry, then the startTime is updated but the lastRetryTime is not.
	LastRetryTime *date.Time `json:"lastRetryTime,omitempty"`
	// Result - If the value is 'failed', then the details of the failure can be found in the failureInfo property. Possible values include: 'Success', 'Failure'
	Result TaskExecutionResult `json:"result,omitempty"`
}

// JobReleaseTask the Job Release Task runs when the Job ends, because of one of the following: The user calls
// the Terminate Job API, or the Delete Job API while the Job is still active, the Job's maximum wall clock
// time constraint is reached, and the Job is still active, or the Job's Job Manager Task completed, and the
// Job is configured to terminate when the Job Manager completes. The Job Release Task runs on each Node where
// Tasks of the Job have run and the Job Preparation Task ran and completed. If you reimage a Node after it has
// run the Job Preparation Task, and the Job ends without any further Tasks of the Job running on that Node
// (and hence the Job Preparation Task does not re-run), then the Job Release Task does not run on that Compute
// Node. If a Node reboots while the Job Release Task is still running, the Job Release Task runs again when
// the Compute Node starts up. The Job is not marked as complete until all Job Release Tasks have completed.
// The Job Release Task runs in the background. It does not occupy a scheduling slot; that is, it does not
// count towards the maxTasksPerNode limit specified on the Pool.
type JobReleaseTask struct {
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores and cannot contain more than 64 characters. If you do not specify this property, the Batch service assigns a default value of 'jobrelease'. No other Task in the Job can have the same ID as the Job Release Task. If you try to submit a Task with the same id, the Batch service rejects the request with error code TaskIdSameAsJobReleaseTask; if you are calling the REST API directly, the HTTP status code is 409 (Conflict).
	ID *string `json:"id,omitempty"`
	// CommandLine - The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. If the command line refers to file paths, it should use a relative path (relative to the Task working directory), or use the Batch provided environment variable (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
	CommandLine *string `json:"commandLine,omitempty"`
	// ContainerSettings - When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all Task environment variables are mapped into the container, and the Task command line is executed in the container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host disk, meaning that Batch file APIs will not be able to access those files.
	ContainerSettings *TaskContainerSettings `json:"containerSettings,omitempty"`
	// ResourceFiles - Files listed under this element are located in the Task's working directory.
	ResourceFiles       *[]ResourceFile       `json:"resourceFiles,omitempty"`
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	MaxWallClockTime    *string               `json:"maxWallClockTime,omitempty"`
	// RetentionTime - The default is 7 days, i.e. the Task directory will be retained for 7 days unless the Compute Node is removed or the Job is deleted.
	RetentionTime *string `json:"retentionTime,omitempty"`
	// UserIdentity - If omitted, the Task runs as a non-administrative user unique to the Task.
	UserIdentity *UserIdentity `json:"userIdentity,omitempty"`
}

// JobReleaseTaskExecutionInformation ...
type JobReleaseTaskExecutionInformation struct {
	// StartTime - If the Task has been restarted or retried, this is the most recent time at which the Task started running.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - This property is set only if the Task is in the Completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// State - Possible values include: 'JobReleaseTaskStateRunning', 'JobReleaseTaskStateCompleted'
	State                JobReleaseTaskState `json:"state,omitempty"`
	TaskRootDirectory    *string             `json:"taskRootDirectory,omitempty"`
	TaskRootDirectoryURL *string             `json:"taskRootDirectoryUrl,omitempty"`
	// ExitCode - This parameter is returned only if the Task is in the completed state. The exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. Note that the exit code may also be generated by the Compute Node operating system, such as when a process is forcibly terminated.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// ContainerInfo - This property is set only if the Task runs in a container context.
	ContainerInfo *TaskContainerExecutionInformation `json:"containerInfo,omitempty"`
	// FailureInfo - This property is set only if the Task is in the completed state and encountered a failure.
	FailureInfo *TaskFailureInformation `json:"failureInfo,omitempty"`
	// Result - If the value is 'failed', then the details of the failure can be found in the failureInfo property. Possible values include: 'Success', 'Failure'
	Result TaskExecutionResult `json:"result,omitempty"`
}

// JobScheduleAddParameter ...
type JobScheduleAddParameter struct {
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not have two IDs within an Account that differ only by case).
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName      *string           `json:"displayName,omitempty"`
	Schedule         *Schedule         `json:"schedule,omitempty"`
	JobSpecification *JobSpecification `json:"jobSpecification,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobScheduleExecutionInformation ...
type JobScheduleExecutionInformation struct {
	// NextRunTime - This property is meaningful only if the schedule is in the active state when the time comes around. For example, if the schedule is disabled, no Job will be created at nextRunTime unless the Job is enabled before then.
	NextRunTime *date.Time `json:"nextRunTime,omitempty"`
	// RecentJob - This property is present only if the at least one Job has run under the schedule.
	RecentJob *RecentJob `json:"recentJob,omitempty"`
	// EndTime - This property is set only if the Job Schedule is in the completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// JobSchedulePatchParameter ...
type JobSchedulePatchParameter struct {
	// Schedule - If you do not specify this element, the existing schedule is left unchanged.
	Schedule *Schedule `json:"schedule,omitempty"`
	// JobSpecification - Updates affect only Jobs that are started after the update has taken place. Any currently active Job continues with the older specification.
	JobSpecification *JobSpecification `json:"jobSpecification,omitempty"`
	// Metadata - If you do not specify this element, existing metadata is left unchanged.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobScheduleStatistics ...
type JobScheduleStatistics struct {
	URL            *string    `json:"url,omitempty"`
	StartTime      *date.Time `json:"startTime,omitempty"`
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
	UserCPUTime    *string    `json:"userCPUTime,omitempty"`
	KernelCPUTime  *string    `json:"kernelCPUTime,omitempty"`
	// WallClockTime - The wall clock time is the elapsed time from when the Task started running on a Compute Node to when it finished (or to the last time the statistics were updated, if the Task had not finished by then). If a Task was retried, this includes the wall clock time of all the Task retries.
	WallClockTime     *string  `json:"wallClockTime,omitempty"`
	ReadIOps          *int64   `json:"readIOps,omitempty"`
	WriteIOps         *int64   `json:"writeIOps,omitempty"`
	ReadIOGiB         *float64 `json:"readIOGiB,omitempty"`
	WriteIOGiB        *float64 `json:"writeIOGiB,omitempty"`
	NumSucceededTasks *int64   `json:"numSucceededTasks,omitempty"`
	NumFailedTasks    *int64   `json:"numFailedTasks,omitempty"`
	NumTaskRetries    *int64   `json:"numTaskRetries,omitempty"`
	// WaitTime - This value is only reported in the Account lifetime statistics; it is not included in the Job statistics.
	WaitTime *string `json:"waitTime,omitempty"`
}

// JobScheduleUpdateParameter ...
type JobScheduleUpdateParameter struct {
	// Schedule - If you do not specify this element, it is equivalent to passing the default schedule: that is, a single Job scheduled to run immediately.
	Schedule *Schedule `json:"schedule,omitempty"`
	// JobSpecification - Updates affect only Jobs that are started after the update has taken place. Any currently active Job continues with the older specification.
	JobSpecification *JobSpecification `json:"jobSpecification,omitempty"`
	// Metadata - If you do not specify this element, it takes the default value of an empty list; in effect, any existing metadata is deleted.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobSchedulingError ...
type JobSchedulingError struct {
	// Category - Possible values include: 'UserError', 'ServerError'
	Category ErrorCategory    `json:"category,omitempty"`
	Code     *string          `json:"code,omitempty"`
	Message  *string          `json:"message,omitempty"`
	Details  *[]NameValuePair `json:"details,omitempty"`
}

// JobSpecification ...
type JobSpecification struct {
	// Priority - Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. The default value is 0. This priority is used as the default for all Jobs under the Job Schedule. You can update a Job's priority after it has been created using by using the update Job API.
	Priority *int32 `json:"priority,omitempty"`
	// DisplayName - The name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName          *string `json:"displayName,omitempty"`
	UsesTaskDependencies *bool   `json:"usesTaskDependencies,omitempty"`
	// OnAllTasksComplete - Note that if a Job contains no Tasks, then all Tasks are considered complete. This option is therefore most commonly used with a Job Manager task; if you want to use automatic Job termination without a Job Manager, you should initially set onAllTasksComplete to noaction and update the Job properties to set onAllTasksComplete to terminatejob once you have finished adding Tasks. The default is noaction. Possible values include: 'NoAction', 'TerminateJob'
	OnAllTasksComplete OnAllTasksComplete `json:"onAllTasksComplete,omitempty"`
	// OnTaskFailure - The default is noaction. Possible values include: 'OnTaskFailureNoAction', 'OnTaskFailurePerformExitOptionsJobAction'
	OnTaskFailure        OnTaskFailure            `json:"onTaskFailure,omitempty"`
	NetworkConfiguration *JobNetworkConfiguration `json:"networkConfiguration,omitempty"`
	Constraints          *JobConstraints          `json:"constraints,omitempty"`
	// JobManagerTask - If the Job does not specify a Job Manager Task, the user must explicitly add Tasks to the Job using the Task API. If the Job does specify a Job Manager Task, the Batch service creates the Job Manager Task when the Job is created, and will try to schedule the Job Manager Task before scheduling other Tasks in the Job.
	JobManagerTask *JobManagerTask `json:"jobManagerTask,omitempty"`
	// JobPreparationTask - If a Job has a Job Preparation Task, the Batch service will run the Job Preparation Task on a Node before starting any Tasks of that Job on that Compute Node.
	JobPreparationTask *JobPreparationTask `json:"jobPreparationTask,omitempty"`
	// JobReleaseTask - The primary purpose of the Job Release Task is to undo changes to Nodes made by the Job Preparation Task. Example activities include deleting local files, or shutting down services that were started as part of Job preparation. A Job Release Task cannot be specified without also specifying a Job Preparation Task for the Job. The Batch service runs the Job Release Task on the Compute Nodes that have run the Job Preparation Task.
	JobReleaseTask *JobReleaseTask `json:"jobReleaseTask,omitempty"`
	// CommonEnvironmentSettings - Individual Tasks can override an environment setting specified here by specifying the same setting name with a different value.
	CommonEnvironmentSettings *[]EnvironmentSetting `json:"commonEnvironmentSettings,omitempty"`
	PoolInfo                  *PoolInformation      `json:"poolInfo,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobStatistics ...
type JobStatistics struct {
	autorest.Response `json:"-"`
	URL               *string    `json:"url,omitempty"`
	StartTime         *date.Time `json:"startTime,omitempty"`
	LastUpdateTime    *date.Time `json:"lastUpdateTime,omitempty"`
	UserCPUTime       *string    `json:"userCPUTime,omitempty"`
	KernelCPUTime     *string    `json:"kernelCPUTime,omitempty"`
	// WallClockTime -  The wall clock time is the elapsed time from when the Task started running on a Compute Node to when it finished (or to the last time the statistics were updated, if the Task had not finished by then). If a Task was retried, this includes the wall clock time of all the Task retries.
	WallClockTime *string  `json:"wallClockTime,omitempty"`
	ReadIOps      *int64   `json:"readIOps,omitempty"`
	WriteIOps     *int64   `json:"writeIOps,omitempty"`
	ReadIOGiB     *float64 `json:"readIOGiB,omitempty"`
	WriteIOGiB    *float64 `json:"writeIOGiB,omitempty"`
	// NumSucceededTasks - A Task completes successfully if it returns exit code 0.
	NumSucceededTasks *int64 `json:"numSucceededTasks,omitempty"`
	// NumFailedTasks - A Task fails if it exhausts its maximum retry count without returning exit code 0.
	NumFailedTasks *int64 `json:"numFailedTasks,omitempty"`
	NumTaskRetries *int64 `json:"numTaskRetries,omitempty"`
	// WaitTime - The wait time for a Task is defined as the elapsed time between the creation of the Task and the start of Task execution. (If the Task is retried due to failures, the wait time is the time to the most recent Task execution.) This value is only reported in the Account lifetime statistics; it is not included in the Job statistics.
	WaitTime *string `json:"waitTime,omitempty"`
}

// JobTerminateParameter ...
type JobTerminateParameter struct {
	TerminateReason *string `json:"terminateReason,omitempty"`
}

// JobUpdateParameter ...
type JobUpdateParameter struct {
	// Priority - Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. If omitted, it is set to the default value 0.
	Priority *int32 `json:"priority,omitempty"`
	// Constraints - If omitted, the constraints are cleared.
	Constraints *JobConstraints `json:"constraints,omitempty"`
	// PoolInfo - You may change the Pool for a Job only when the Job is disabled. The Update Job call will fail if you include the poolInfo element and the Job is not disabled. If you specify an autoPoolSpecification in the poolInfo, only the keepAlive property of the autoPoolSpecification can be updated, and then only if the autoPoolSpecification has a poolLifetimeOption of Job (other job properties can be updated as normal).
	PoolInfo *PoolInformation `json:"poolInfo,omitempty"`
	// Metadata - If omitted, it takes the default value of an empty list; in effect, any existing metadata is deleted.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
	// OnAllTasksComplete - If omitted, the completion behavior is set to noaction. If the current value is terminatejob, this is an error because a Job's completion behavior may not be changed from terminatejob to noaction. You may not change the value from terminatejob to noaction - that is, once you have engaged automatic Job termination, you cannot turn it off again. If you try to do this, the request fails and Batch returns status code 400 (Bad Request) and an 'invalid property value' error response. If you do not specify this element in a PUT request, it is equivalent to passing noaction. This is an error if the current value is terminatejob. Possible values include: 'NoAction', 'TerminateJob'
	OnAllTasksComplete OnAllTasksComplete `json:"onAllTasksComplete,omitempty"`
}

// LinuxUserConfiguration ...
type LinuxUserConfiguration struct {
	// UID - The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
	UID *int32 `json:"uid,omitempty"`
	// Gid - The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
	Gid *int32 `json:"gid,omitempty"`
	// SSHPrivateKey - The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between Compute Nodes in a Linux Pool when the Pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between Compute Nodes (no modification of the user's .ssh directory is done).
	SSHPrivateKey *string `json:"sshPrivateKey,omitempty"`
}

// MetadataItem the Batch service does not assign any meaning to this metadata; it is solely for the use of
// user code.
type MetadataItem struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// MountConfiguration ...
type MountConfiguration struct {
	// AzureBlobFileSystemConfiguration - This property is mutually exclusive with all other properties.
	AzureBlobFileSystemConfiguration *AzureBlobFileSystemConfiguration `json:"azureBlobFileSystemConfiguration,omitempty"`
	// NfsMountConfiguration - This property is mutually exclusive with all other properties.
	NfsMountConfiguration *NFSMountConfiguration `json:"nfsMountConfiguration,omitempty"`
	// CifsMountConfiguration - This property is mutually exclusive with all other properties.
	CifsMountConfiguration *CIFSMountConfiguration `json:"cifsMountConfiguration,omitempty"`
	// AzureFileShareConfiguration - This property is mutually exclusive with all other properties.
	AzureFileShareConfiguration *AzureFileShareConfiguration `json:"azureFileShareConfiguration,omitempty"`
}

// MultiInstanceSettings multi-instance Tasks are commonly used to support MPI Tasks. In the MPI case, if any
// of the subtasks fail (for example due to exiting with a non-zero exit code) the entire multi-instance Task
// fails. The multi-instance Task is then terminated and retried, up to its retry limit.
type MultiInstanceSettings struct {
	// NumberOfInstances - If omitted, the default is 1.
	NumberOfInstances *int32 `json:"numberOfInstances,omitempty"`
	// CoordinationCommandLine - A typical coordination command line launches a background service and verifies that the service is ready to process inter-node messages.
	CoordinationCommandLine *string `json:"coordinationCommandLine,omitempty"`
	// CommonResourceFiles - The difference between common resource files and Task resource files is that common resource files are downloaded for all subtasks including the primary, whereas Task resource files are downloaded only for the primary. Also note that these resource files are not downloaded to the Task working directory, but instead are downloaded to the Task root directory (one directory above the working directory).  There is a maximum size for the list of resource files.  When the max size is exceeded, the request will fail and the response error code will be RequestEntityTooLarge. If this occurs, the collection of ResourceFiles must be reduced in size. This can be achieved using .zip files, Application Packages, or Docker Containers.
	CommonResourceFiles *[]ResourceFile `json:"commonResourceFiles,omitempty"`
}

// NameValuePair ...
type NameValuePair struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// NetworkConfiguration the network configuration for a Pool.
type NetworkConfiguration struct {
	// SubnetID - The virtual network must be in the same region and subscription as the Azure Batch Account. The specified subnet should have enough free IP addresses to accommodate the number of Compute Nodes in the Pool. If the subnet doesn't have enough free IP addresses, the Pool will partially allocate Nodes and a resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule Tasks on the Nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the Nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the Compute Nodes to unusable. For Pools created with virtualMachineConfiguration only ARM virtual networks ('Microsoft.Network/virtualNetworks') are supported, but for Pools created with cloudServiceConfiguration both ARM and classic virtual networks are supported. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication. For Pools created with a virtual machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For Pools created with a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port 443. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
	SubnetID *string `json:"subnetId,omitempty"`
	// DynamicVNetAssignmentScope - Possible values include: 'DynamicVNetAssignmentScopeNone', 'DynamicVNetAssignmentScopeJob'
	DynamicVNetAssignmentScope DynamicVNetAssignmentScope `json:"dynamicVNetAssignmentScope,omitempty"`
	// EndpointConfiguration - Pool endpoint configuration is only supported on Pools with the virtualMachineConfiguration property.
	EndpointConfiguration *PoolEndpointConfiguration `json:"endpointConfiguration,omitempty"`
	// PublicIPAddressConfiguration - Public IP configuration property is only supported on Pools with the virtualMachineConfiguration property.
	PublicIPAddressConfiguration *PublicIPAddressConfiguration `json:"publicIPAddressConfiguration,omitempty"`
}

// NetworkSecurityGroupRule ...
type NetworkSecurityGroupRule struct {
	// Priority - Priorities within a Pool must be unique and are evaluated in order of priority. The lower the number the higher the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 4096. If any reserved or duplicate values are provided the request fails with HTTP status code 400.
	Priority *int32 `json:"priority,omitempty"`
	// Access - Possible values include: 'Allow', 'Deny'
	Access NetworkSecurityGroupRuleAccess `json:"access,omitempty"`
	// SourceAddressPrefix - Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values are provided the request fails with HTTP status code 400.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
	// SourcePortRanges - Valid values are '*' (for all ports 0 - 65535), a specific port (i.e. 22), or a port range (i.e. 100-200). The ports must be in the range of 0 to 65535. Each entry in this collection must not overlap any other entry (either a range or an individual port). If any other values are provided the request fails with HTTP status code 400. The default value is '*'.
	SourcePortRanges *[]string `json:"sourcePortRanges,omitempty"`
}

// NFSMountConfiguration ...
type NFSMountConfiguration struct {
	Source *string `json:"source,omitempty"`
	// RelativeMountPath - All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
	// MountOptions - These are 'net use' options in Windows and 'mount' options in Linux.
	MountOptions *string `json:"mountOptions,omitempty"`
}

// NodeAgentInformation the Batch Compute Node agent is a program that runs on each Compute Node in the Pool
// and provides Batch capability on the Compute Node.
type NodeAgentInformation struct {
	// Version - This version number can be checked against the Compute Node agent release notes located at https://github.com/Azure/Batch/blob/master/changelogs/nodeagent/CHANGELOG.md.
	Version *string `json:"version,omitempty"`
	// LastUpdateTime - This is the most recent time that the Compute Node agent was updated to a new version.
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
}

// NodeCounts ...
type NodeCounts struct {
	Creating            *int32 `json:"creating,omitempty"`
	Idle                *int32 `json:"idle,omitempty"`
	Offline             *int32 `json:"offline,omitempty"`
	Preempted           *int32 `json:"preempted,omitempty"`
	Rebooting           *int32 `json:"rebooting,omitempty"`
	Reimaging           *int32 `json:"reimaging,omitempty"`
	Running             *int32 `json:"running,omitempty"`
	Starting            *int32 `json:"starting,omitempty"`
	StartTaskFailed     *int32 `json:"startTaskFailed,omitempty"`
	LeavingPool         *int32 `json:"leavingPool,omitempty"`
	Unknown             *int32 `json:"unknown,omitempty"`
	Unusable            *int32 `json:"unusable,omitempty"`
	WaitingForStartTask *int32 `json:"waitingForStartTask,omitempty"`
	Total               *int32 `json:"total,omitempty"`
}

// NodeDisableSchedulingParameter ...
type NodeDisableSchedulingParameter struct {
	// NodeDisableSchedulingOption - The default value is requeue. Possible values include: 'DisableComputeNodeSchedulingOptionRequeue', 'DisableComputeNodeSchedulingOptionTerminate', 'DisableComputeNodeSchedulingOptionTaskCompletion'
	NodeDisableSchedulingOption DisableComputeNodeSchedulingOption `json:"nodeDisableSchedulingOption,omitempty"`
}

// NodeFile ...
type NodeFile struct {
	Name        *string         `json:"name,omitempty"`
	URL         *string         `json:"url,omitempty"`
	IsDirectory *bool           `json:"isDirectory,omitempty"`
	Properties  *FileProperties `json:"properties,omitempty"`
}

// NodeFileListResult ...
type NodeFileListResult struct {
	autorest.Response `json:"-"`
	Value             *[]NodeFile `json:"value,omitempty"`
	OdataNextLink     *string     `json:"odata.nextLink,omitempty"`
}

// NodeFileListResultIterator provides access to a complete listing of NodeFile values.
type NodeFileListResultIterator struct {
	i    int
	page NodeFileListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NodeFileListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NodeFileListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NodeFileListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NodeFileListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NodeFileListResultIterator) Response() NodeFileListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NodeFileListResultIterator) Value() NodeFile {
	if !iter.page.NotDone() {
		return NodeFile{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NodeFileListResultIterator type.
func NewNodeFileListResultIterator(page NodeFileListResultPage) NodeFileListResultIterator {
	return NodeFileListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nflr NodeFileListResult) IsEmpty() bool {
	return nflr.Value == nil || len(*nflr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nflr NodeFileListResult) hasNextLink() bool {
	return nflr.OdataNextLink != nil && len(*nflr.OdataNextLink) != 0
}

// nodeFileListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nflr NodeFileListResult) nodeFileListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !nflr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nflr.OdataNextLink)))
}

// NodeFileListResultPage contains a page of NodeFile values.
type NodeFileListResultPage struct {
	fn   func(context.Context, NodeFileListResult) (NodeFileListResult, error)
	nflr NodeFileListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NodeFileListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NodeFileListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nflr)
		if err != nil {
			return err
		}
		page.nflr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NodeFileListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NodeFileListResultPage) NotDone() bool {
	return !page.nflr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NodeFileListResultPage) Response() NodeFileListResult {
	return page.nflr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NodeFileListResultPage) Values() []NodeFile {
	if page.nflr.IsEmpty() {
		return nil
	}
	return *page.nflr.Value
}

// Creates a new instance of the NodeFileListResultPage type.
func NewNodeFileListResultPage(getNextPage func(context.Context, NodeFileListResult) (NodeFileListResult, error)) NodeFileListResultPage {
	return NodeFileListResultPage{fn: getNextPage}
}

// NodeRebootParameter ...
type NodeRebootParameter struct {
	// NodeRebootOption - The default value is requeue. Possible values include: 'ComputeNodeRebootOptionRequeue', 'ComputeNodeRebootOptionTerminate', 'ComputeNodeRebootOptionTaskCompletion', 'ComputeNodeRebootOptionRetainedData'
	NodeRebootOption ComputeNodeRebootOption `json:"nodeRebootOption,omitempty"`
}

// NodeReimageParameter ...
type NodeReimageParameter struct {
	// NodeReimageOption - The default value is requeue. Possible values include: 'ComputeNodeReimageOptionRequeue', 'ComputeNodeReimageOptionTerminate', 'ComputeNodeReimageOptionTaskCompletion', 'ComputeNodeReimageOptionRetainedData'
	NodeReimageOption ComputeNodeReimageOption `json:"nodeReimageOption,omitempty"`
}

// NodeRemoveParameter ...
type NodeRemoveParameter struct {
	NodeList *[]string `json:"nodeList,omitempty"`
	// ResizeTimeout - The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// NodeDeallocationOption - The default value is requeue. Possible values include: 'Requeue', 'Terminate', 'TaskCompletion', 'RetainedData'
	NodeDeallocationOption ComputeNodeDeallocationOption `json:"nodeDeallocationOption,omitempty"`
}

// NodeUpdateUserParameter ...
type NodeUpdateUserParameter struct {
	// Password - The password is required for Windows Compute Nodes (those created with 'cloudServiceConfiguration', or created with 'virtualMachineConfiguration' using a Windows Image reference). For Linux Compute Nodes, the password can optionally be specified along with the sshPublicKey property. If omitted, any existing password is removed.
	Password *string `json:"password,omitempty"`
	// ExpiryTime - If omitted, the default is 1 day from the current time. For Linux Compute Nodes, the expiryTime has a precision up to a day.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// SSHPublicKey - The public key should be compatible with OpenSSH encoding and should be base 64 encoded. This property can be specified only for Linux Compute Nodes. If this is specified for a Windows Compute Node, then the Batch service rejects the request; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request). If omitted, any existing SSH public key is removed.
	SSHPublicKey *string `json:"sshPublicKey,omitempty"`
}

// OutputFile ...
type OutputFile struct {
	// FilePattern - Both relative and absolute paths are supported. Relative paths are relative to the Task working directory. The following wildcards are supported: * matches 0 or more characters (for example pattern abc* would match abc or abcdef), ** matches any directory, ? matches any single character, [abc] matches one character in the brackets, and [a-c] matches one character in the range. Brackets can include a negation to match any character not specified (for example [!abc] matches any character but a, b, or c). If a file name starts with "." it is ignored by default but may be matched by specifying it explicitly (for example *.gif will not match .a.gif, but .*.gif will). A simple example: **\*.txt matches any file that does not start in '.' and ends with .txt in the Task working directory or any subdirectory. If the filename contains a wildcard character it can be escaped using brackets (for example abc[*] would match a file named abc*). Note that both \ and / are treated as directory separators on Windows, but only / is on Linux. Environment variables (%var% on Windows or $var on Linux) are expanded prior to the pattern being applied.
	FilePattern   *string                  `json:"filePattern,omitempty"`
	Destination   *OutputFileDestination   `json:"destination,omitempty"`
	UploadOptions *OutputFileUploadOptions `json:"uploadOptions,omitempty"`
}

// OutputFileBlobContainerDestination ...
type OutputFileBlobContainerDestination struct {
	// Path - If filePattern refers to a specific file (i.e. contains no wildcards), then path is the name of the blob to which to upload that file. If filePattern contains one or more wildcards (and therefore may match multiple files), then path is the name of the blob virtual directory (which is prepended to each blob name) to which to upload the file(s). If omitted, file(s) are uploaded to the root of the container with a blob name matching their file name.
	Path *string `json:"path,omitempty"`
	// ContainerURL - The URL must include a Shared Access Signature (SAS) granting write permissions to the container.
	ContainerURL *string `json:"containerUrl,omitempty"`
}

// OutputFileDestination ...
type OutputFileDestination struct {
	Container *OutputFileBlobContainerDestination `json:"container,omitempty"`
}

// OutputFileUploadOptions ...
type OutputFileUploadOptions struct {
	// UploadCondition - The default is taskcompletion. Possible values include: 'OutputFileUploadConditionTaskSuccess', 'OutputFileUploadConditionTaskFailure', 'OutputFileUploadConditionTaskCompletion'
	UploadCondition OutputFileUploadCondition `json:"uploadCondition,omitempty"`
}

// PoolAddParameter ...
type PoolAddParameter struct {
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not have two Pool IDs within an Account that differ only by case).
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	// VMSize - For information about available sizes of virtual machines for Cloud Services Pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services (https://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch supports all Cloud Services VM sizes except ExtraSmall, A1V2 and A2V2. For information about available VM sizes for Pools using Images from the Virtual Machines Marketplace (pools created with virtualMachineConfiguration) see Sizes for Virtual Machines (Linux) (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
	VMSize *string `json:"vmSize,omitempty"`
	// CloudServiceConfiguration - This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch Account was created with its poolAllocationMode property set to 'UserSubscription'.
	CloudServiceConfiguration *CloudServiceConfiguration `json:"cloudServiceConfiguration,omitempty"`
	// VirtualMachineConfiguration - This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
	// ResizeTimeout - This timeout applies only to manual scaling; it has no effect when enableAutoScale is set to true. The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// TargetDedicatedNodes - This property must not be specified if enableAutoScale is set to true. If enableAutoScale is set to false, then you must set either targetDedicatedNodes, targetLowPriorityNodes, or both.
	TargetDedicatedNodes *int32 `json:"targetDedicatedNodes,omitempty"`
	// TargetLowPriorityNodes - This property must not be specified if enableAutoScale is set to true. If enableAutoScale is set to false, then you must set either targetDedicatedNodes, targetLowPriorityNodes, or both.
	TargetLowPriorityNodes *int32 `json:"targetLowPriorityNodes,omitempty"`
	// EnableAutoScale - If false, at least one of targetDedicateNodes and targetLowPriorityNodes must be specified. If true, the autoScaleFormula property is required and the Pool automatically resizes according to the formula. The default value is false.
	EnableAutoScale *bool `json:"enableAutoScale,omitempty"`
	// AutoScaleFormula - This property must not be specified if enableAutoScale is set to false. It is required if enableAutoScale is set to true. The formula is checked for validity before the Pool is created. If the formula is not valid, the Batch service rejects the request with detailed error information. For more information about specifying this formula, see 'Automatically scale Compute Nodes in an Azure Batch Pool' (https://azure.microsoft.com/documentation/articles/batch-automatic-scaling/).
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
	// AutoScaleEvaluationInterval - The default value is 15 minutes. The minimum and maximum value are 5 minutes and 168 hours respectively. If you specify a value less than 5 minutes or greater than 168 hours, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	AutoScaleEvaluationInterval *string `json:"autoScaleEvaluationInterval,omitempty"`
	// EnableInterNodeCommunication - Enabling inter-node communication limits the maximum size of the Pool due to deployment restrictions on the Compute Nodes of the Pool. This may result in the Pool not reaching its desired size. The default value is false.
	EnableInterNodeCommunication *bool                 `json:"enableInterNodeCommunication,omitempty"`
	NetworkConfiguration         *NetworkConfiguration `json:"networkConfiguration,omitempty"`
	// StartTask - The Task runs when the Compute Node is added to the Pool or when the Compute Node is restarted.
	StartTask *StartTask `json:"startTask,omitempty"`
	// CertificateReferences - For Windows Nodes, the Batch service installs the Certificates to the specified Certificate store and location. For Linux Compute Nodes, the Certificates are stored in a directory inside the Task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the Task to query for this location. For Certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and Certificates are placed in that directory.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// ApplicationPackageReferences - Changes to Package references affect all new Nodes joining the Pool, but do not affect Compute Nodes that are already in the Pool until they are rebooted or reimaged. There is a maximum of 10 Package references on any given Pool.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// ApplicationLicenses - The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, Pool creation will fail.
	ApplicationLicenses *[]string `json:"applicationLicenses,omitempty"`
	// MaxTasksPerNode - The default value is 1. The maximum value is the smaller of 4 times the number of cores of the vmSize of the Pool or 256.
	MaxTasksPerNode *int32 `json:"maxTasksPerNode,omitempty"`
	// TaskSchedulingPolicy - If not specified, the default is spread.
	TaskSchedulingPolicy *TaskSchedulingPolicy `json:"taskSchedulingPolicy,omitempty"`
	UserAccounts         *[]UserAccount        `json:"userAccounts,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
	// MountConfiguration - Mount the storage using Azure fileshare, NFS, CIFS or Blobfuse based file system.
	MountConfiguration *[]MountConfiguration `json:"mountConfiguration,omitempty"`
}

// PoolEnableAutoScaleParameter ...
type PoolEnableAutoScaleParameter struct {
	// AutoScaleFormula - The formula is checked for validity before it is applied to the Pool. If the formula is not valid, the Batch service rejects the request with detailed error information. For more information about specifying this formula, see Automatically scale Compute Nodes in an Azure Batch Pool (https://azure.microsoft.com/en-us/documentation/articles/batch-automatic-scaling).
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
	// AutoScaleEvaluationInterval - The default value is 15 minutes. The minimum and maximum value are 5 minutes and 168 hours respectively. If you specify a value less than 5 minutes or greater than 168 hours, the Batch service rejects the request with an invalid property value error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request). If you specify a new interval, then the existing autoscale evaluation schedule will be stopped and a new autoscale evaluation schedule will be started, with its starting time being the time when this request was issued.
	AutoScaleEvaluationInterval *string `json:"autoScaleEvaluationInterval,omitempty"`
}

// PoolEndpointConfiguration ...
type PoolEndpointConfiguration struct {
	// InboundNATPools - The maximum number of inbound NAT Pools per Batch Pool is 5. If the maximum number of inbound NAT Pools is exceeded the request fails with HTTP status code 400.
	InboundNATPools *[]InboundNATPool `json:"inboundNATPools,omitempty"`
}

// PoolEvaluateAutoScaleParameter ...
type PoolEvaluateAutoScaleParameter struct {
	// AutoScaleFormula - The formula is validated and its results calculated, but it is not applied to the Pool. To apply the formula to the Pool, 'Enable automatic scaling on a Pool'. For more information about specifying this formula, see Automatically scale Compute Nodes in an Azure Batch Pool (https://azure.microsoft.com/en-us/documentation/articles/batch-automatic-scaling).
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
}

// PoolInformation ...
type PoolInformation struct {
	// PoolID - You must ensure that the Pool referenced by this property exists. If the Pool does not exist at the time the Batch service tries to schedule a Job, no Tasks for the Job will run until you create a Pool with that id. Note that the Batch service will not reject the Job request; it will simply not run Tasks until the Pool exists. You must specify either the Pool ID or the auto Pool specification, but not both.
	PoolID *string `json:"poolId,omitempty"`
	// AutoPoolSpecification - If auto Pool creation fails, the Batch service moves the Job to a completed state, and the Pool creation error is set in the Job's scheduling error property. The Batch service manages the lifetime (both creation and, unless keepAlive is specified, deletion) of the auto Pool. Any user actions that affect the lifetime of the auto Pool while the Job is active will result in unexpected behavior. You must specify either the Pool ID or the auto Pool specification, but not both.
	AutoPoolSpecification *AutoPoolSpecification `json:"autoPoolSpecification,omitempty"`
}

// PoolListUsageMetricsResult ...
type PoolListUsageMetricsResult struct {
	autorest.Response `json:"-"`
	Value             *[]PoolUsageMetrics `json:"value,omitempty"`
	OdataNextLink     *string             `json:"odata.nextLink,omitempty"`
}

// PoolListUsageMetricsResultIterator provides access to a complete listing of PoolUsageMetrics values.
type PoolListUsageMetricsResultIterator struct {
	i    int
	page PoolListUsageMetricsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PoolListUsageMetricsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PoolListUsageMetricsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PoolListUsageMetricsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PoolListUsageMetricsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PoolListUsageMetricsResultIterator) Response() PoolListUsageMetricsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PoolListUsageMetricsResultIterator) Value() PoolUsageMetrics {
	if !iter.page.NotDone() {
		return PoolUsageMetrics{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PoolListUsageMetricsResultIterator type.
func NewPoolListUsageMetricsResultIterator(page PoolListUsageMetricsResultPage) PoolListUsageMetricsResultIterator {
	return PoolListUsageMetricsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plumr PoolListUsageMetricsResult) IsEmpty() bool {
	return plumr.Value == nil || len(*plumr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plumr PoolListUsageMetricsResult) hasNextLink() bool {
	return plumr.OdataNextLink != nil && len(*plumr.OdataNextLink) != 0
}

// poolListUsageMetricsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plumr PoolListUsageMetricsResult) poolListUsageMetricsResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plumr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plumr.OdataNextLink)))
}

// PoolListUsageMetricsResultPage contains a page of PoolUsageMetrics values.
type PoolListUsageMetricsResultPage struct {
	fn    func(context.Context, PoolListUsageMetricsResult) (PoolListUsageMetricsResult, error)
	plumr PoolListUsageMetricsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PoolListUsageMetricsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PoolListUsageMetricsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plumr)
		if err != nil {
			return err
		}
		page.plumr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PoolListUsageMetricsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PoolListUsageMetricsResultPage) NotDone() bool {
	return !page.plumr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PoolListUsageMetricsResultPage) Response() PoolListUsageMetricsResult {
	return page.plumr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PoolListUsageMetricsResultPage) Values() []PoolUsageMetrics {
	if page.plumr.IsEmpty() {
		return nil
	}
	return *page.plumr.Value
}

// Creates a new instance of the PoolListUsageMetricsResultPage type.
func NewPoolListUsageMetricsResultPage(getNextPage func(context.Context, PoolListUsageMetricsResult) (PoolListUsageMetricsResult, error)) PoolListUsageMetricsResultPage {
	return PoolListUsageMetricsResultPage{fn: getNextPage}
}

// PoolNodeCounts ...
type PoolNodeCounts struct {
	PoolID      *string     `json:"poolId,omitempty"`
	Dedicated   *NodeCounts `json:"dedicated,omitempty"`
	LowPriority *NodeCounts `json:"lowPriority,omitempty"`
}

// PoolNodeCountsListResult ...
type PoolNodeCountsListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of Compute Node counts by Pool.
	Value         *[]PoolNodeCounts `json:"value,omitempty"`
	OdataNextLink *string           `json:"odata.nextLink,omitempty"`
}

// PoolNodeCountsListResultIterator provides access to a complete listing of PoolNodeCounts values.
type PoolNodeCountsListResultIterator struct {
	i    int
	page PoolNodeCountsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PoolNodeCountsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PoolNodeCountsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PoolNodeCountsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PoolNodeCountsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PoolNodeCountsListResultIterator) Response() PoolNodeCountsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PoolNodeCountsListResultIterator) Value() PoolNodeCounts {
	if !iter.page.NotDone() {
		return PoolNodeCounts{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PoolNodeCountsListResultIterator type.
func NewPoolNodeCountsListResultIterator(page PoolNodeCountsListResultPage) PoolNodeCountsListResultIterator {
	return PoolNodeCountsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pnclr PoolNodeCountsListResult) IsEmpty() bool {
	return pnclr.Value == nil || len(*pnclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pnclr PoolNodeCountsListResult) hasNextLink() bool {
	return pnclr.OdataNextLink != nil && len(*pnclr.OdataNextLink) != 0
}

// poolNodeCountsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pnclr PoolNodeCountsListResult) poolNodeCountsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !pnclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pnclr.OdataNextLink)))
}

// PoolNodeCountsListResultPage contains a page of PoolNodeCounts values.
type PoolNodeCountsListResultPage struct {
	fn    func(context.Context, PoolNodeCountsListResult) (PoolNodeCountsListResult, error)
	pnclr PoolNodeCountsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PoolNodeCountsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PoolNodeCountsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pnclr)
		if err != nil {
			return err
		}
		page.pnclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PoolNodeCountsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PoolNodeCountsListResultPage) NotDone() bool {
	return !page.pnclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PoolNodeCountsListResultPage) Response() PoolNodeCountsListResult {
	return page.pnclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PoolNodeCountsListResultPage) Values() []PoolNodeCounts {
	if page.pnclr.IsEmpty() {
		return nil
	}
	return *page.pnclr.Value
}

// Creates a new instance of the PoolNodeCountsListResultPage type.
func NewPoolNodeCountsListResultPage(getNextPage func(context.Context, PoolNodeCountsListResult) (PoolNodeCountsListResult, error)) PoolNodeCountsListResultPage {
	return PoolNodeCountsListResultPage{fn: getNextPage}
}

// PoolPatchParameter ...
type PoolPatchParameter struct {
	// StartTask - If this element is present, it overwrites any existing StartTask. If omitted, any existing StartTask is left unchanged.
	StartTask *StartTask `json:"startTask,omitempty"`
	// CertificateReferences - If this element is present, it replaces any existing Certificate references configured on the Pool. If omitted, any existing Certificate references are left unchanged. For Windows Nodes, the Batch service installs the Certificates to the specified Certificate store and location. For Linux Compute Nodes, the Certificates are stored in a directory inside the Task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the Task to query for this location. For Certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and Certificates are placed in that directory.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// ApplicationPackageReferences - Changes to Package references affect all new Nodes joining the Pool, but do not affect Compute Nodes that are already in the Pool until they are rebooted or reimaged. If this element is present, it replaces any existing Package references. If you specify an empty collection, then all Package references are removed from the Pool. If omitted, any existing Package references are left unchanged.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// Metadata - If this element is present, it replaces any existing metadata configured on the Pool. If you specify an empty collection, any metadata is removed from the Pool. If omitted, any existing metadata is left unchanged.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// PoolResizeParameter ...
type PoolResizeParameter struct {
	TargetDedicatedNodes   *int32 `json:"targetDedicatedNodes,omitempty"`
	TargetLowPriorityNodes *int32 `json:"targetLowPriorityNodes,omitempty"`
	// ResizeTimeout - The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// NodeDeallocationOption - The default value is requeue. Possible values include: 'Requeue', 'Terminate', 'TaskCompletion', 'RetainedData'
	NodeDeallocationOption ComputeNodeDeallocationOption `json:"nodeDeallocationOption,omitempty"`
}

// PoolSpecification ...
type PoolSpecification struct {
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	// VMSize - For information about available sizes of virtual machines in Pools, see Choose a VM size for Compute Nodes in an Azure Batch Pool (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
	VMSize *string `json:"vmSize,omitempty"`
	// CloudServiceConfiguration - This property must be specified if the Pool needs to be created with Azure PaaS VMs. This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. If neither is specified then the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request). This property cannot be specified if the Batch Account was created with its poolAllocationMode property set to 'UserSubscription'.
	CloudServiceConfiguration *CloudServiceConfiguration `json:"cloudServiceConfiguration,omitempty"`
	// VirtualMachineConfiguration - This property must be specified if the Pool needs to be created with Azure IaaS VMs. This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified. If neither is specified then the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
	// MaxTasksPerNode - The default value is 1. The maximum value is the smaller of 4 times the number of cores of the vmSize of the Pool or 256.
	MaxTasksPerNode *int32 `json:"maxTasksPerNode,omitempty"`
	// TaskSchedulingPolicy - If not specified, the default is spread.
	TaskSchedulingPolicy *TaskSchedulingPolicy `json:"taskSchedulingPolicy,omitempty"`
	// ResizeTimeout - This timeout applies only to manual scaling; it has no effect when enableAutoScale is set to true. The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// TargetDedicatedNodes - This property must not be specified if enableAutoScale is set to true. If enableAutoScale is set to false, then you must set either targetDedicatedNodes, targetLowPriorityNodes, or both.
	TargetDedicatedNodes *int32 `json:"targetDedicatedNodes,omitempty"`
	// TargetLowPriorityNodes - This property must not be specified if enableAutoScale is set to true. If enableAutoScale is set to false, then you must set either targetDedicatedNodes, targetLowPriorityNodes, or both.
	TargetLowPriorityNodes *int32 `json:"targetLowPriorityNodes,omitempty"`
	// EnableAutoScale - If false, at least one of targetDedicateNodes and targetLowPriorityNodes must be specified. If true, the autoScaleFormula element is required. The Pool automatically resizes according to the formula. The default value is false.
	EnableAutoScale *bool `json:"enableAutoScale,omitempty"`
	// AutoScaleFormula - This property must not be specified if enableAutoScale is set to false. It is required if enableAutoScale is set to true. The formula is checked for validity before the Pool is created. If the formula is not valid, the Batch service rejects the request with detailed error information.
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
	// AutoScaleEvaluationInterval - The default value is 15 minutes. The minimum and maximum value are 5 minutes and 168 hours respectively. If you specify a value less than 5 minutes or greater than 168 hours, the Batch service rejects the request with an invalid property value error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	AutoScaleEvaluationInterval *string `json:"autoScaleEvaluationInterval,omitempty"`
	// EnableInterNodeCommunication - Enabling inter-node communication limits the maximum size of the Pool due to deployment restrictions on the Compute Nodes of the Pool. This may result in the Pool not reaching its desired size. The default value is false.
	EnableInterNodeCommunication *bool                 `json:"enableInterNodeCommunication,omitempty"`
	NetworkConfiguration         *NetworkConfiguration `json:"networkConfiguration,omitempty"`
	StartTask                    *StartTask            `json:"startTask,omitempty"`
	// CertificateReferences - For Windows Nodes, the Batch service installs the Certificates to the specified Certificate store and location. For Linux Compute Nodes, the Certificates are stored in a directory inside the Task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the Task to query for this location. For Certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and Certificates are placed in that directory.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// ApplicationPackageReferences - Changes to Package references affect all new Nodes joining the Pool, but do not affect Compute Nodes that are already in the Pool until they are rebooted or reimaged. There is a maximum of 10 Package references on any given Pool.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// ApplicationLicenses - The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, Pool creation will fail. The permitted licenses available on the Pool are 'maya', 'vray', '3dsmax', 'arnold'. An additional charge applies for each application license added to the Pool.
	ApplicationLicenses *[]string      `json:"applicationLicenses,omitempty"`
	UserAccounts        *[]UserAccount `json:"userAccounts,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
	// MountConfiguration - This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
	MountConfiguration *[]MountConfiguration `json:"mountConfiguration,omitempty"`
}

// PoolStatistics ...
type PoolStatistics struct {
	autorest.Response `json:"-"`
	URL               *string             `json:"url,omitempty"`
	StartTime         *date.Time          `json:"startTime,omitempty"`
	LastUpdateTime    *date.Time          `json:"lastUpdateTime,omitempty"`
	UsageStats        *UsageStatistics    `json:"usageStats,omitempty"`
	ResourceStats     *ResourceStatistics `json:"resourceStats,omitempty"`
}

// PoolUpdatePropertiesParameter ...
type PoolUpdatePropertiesParameter struct {
	// StartTask - If this element is present, it overwrites any existing StartTask. If omitted, any existing StartTask is removed from the Pool.
	StartTask *StartTask `json:"startTask,omitempty"`
	// CertificateReferences - This list replaces any existing Certificate references configured on the Pool. If you specify an empty collection, any existing Certificate references are removed from the Pool. For Windows Nodes, the Batch service installs the Certificates to the specified Certificate store and location. For Linux Compute Nodes, the Certificates are stored in a directory inside the Task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the Task to query for this location. For Certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and Certificates are placed in that directory.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// ApplicationPackageReferences - The list replaces any existing Application Package references on the Pool. Changes to Application Package references affect all new Compute Nodes joining the Pool, but do not affect Compute Nodes that are already in the Pool until they are rebooted or reimaged. There is a maximum of 10 Application Package references on any given Pool. If omitted, or if you specify an empty collection, any existing Application Packages references are removed from the Pool. A maximum of 10 references may be specified on a given Pool.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// Metadata - This list replaces any existing metadata configured on the Pool. If omitted, or if you specify an empty collection, any existing metadata is removed from the Pool.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// PoolUsageMetrics ...
type PoolUsageMetrics struct {
	PoolID    *string    `json:"poolId,omitempty"`
	StartTime *date.Time `json:"startTime,omitempty"`
	EndTime   *date.Time `json:"endTime,omitempty"`
	// VMSize - For information about available sizes of virtual machines in Pools, see Choose a VM size for Compute Nodes in an Azure Batch Pool (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
	VMSize         *string  `json:"vmSize,omitempty"`
	TotalCoreHours *float64 `json:"totalCoreHours,omitempty"`
}

// PublicIPAddressConfiguration the public IP Address configuration of the networking configuration of a Pool.
type PublicIPAddressConfiguration struct {
	// Provision - The default value is BatchManaged. Possible values include: 'BatchManaged', 'UserManaged', 'NoPublicIPAddresses'
	Provision IPAddressProvisioningType `json:"provision,omitempty"`
	// IPAddressIds - The number of IPs specified here limits the maximum size of the Pool - 50 dedicated nodes or 20 low-priority nodes can be allocated for each public IP. For example, a pool needing 150 dedicated VMs would need at least 3 public IPs specified. Each element of this collection is of the form: /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
	IPAddressIds *[]string `json:"ipAddressIds,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// RecentJob ...
type RecentJob struct {
	ID  *string `json:"id,omitempty"`
	URL *string `json:"url,omitempty"`
}

// ResizeError ...
type ResizeError struct {
	Code    *string          `json:"code,omitempty"`
	Message *string          `json:"message,omitempty"`
	Values  *[]NameValuePair `json:"values,omitempty"`
}

// ResourceFile ...
type ResourceFile struct {
	// AutoStorageContainerName - The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified.
	AutoStorageContainerName *string `json:"autoStorageContainerName,omitempty"`
	// StorageContainerURL - The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. This URL must be readable and listable using anonymous access; that is, the Batch service does not present any credentials when downloading blobs from the container. There are two ways to get such a URL for a container in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the container, or set the ACL for the container to allow public access.
	StorageContainerURL *string `json:"storageContainerUrl,omitempty"`
	// HTTPURL - The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. If the URL points to Azure Blob Storage, it must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access.
	HTTPURL *string `json:"httpUrl,omitempty"`
	// BlobPrefix - The property is valid only when autoStorageContainerName or storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
	BlobPrefix *string `json:"blobPrefix,omitempty"`
	// FilePath - If the httpUrl property is specified, the filePath is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and is the directory to download the files to. In the case where filePath is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the Task's working directory (for example by using '..').
	FilePath *string `json:"filePath,omitempty"`
	// FileMode - This property applies only to files being downloaded to Linux Compute Nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows Compute Node. If this property is not specified for a Linux Compute Node, then a default value of 0770 is applied to the file.
	FileMode *string `json:"fileMode,omitempty"`
}

// ResourceStatistics ...
type ResourceStatistics struct {
	StartTime        *date.Time `json:"startTime,omitempty"`
	LastUpdateTime   *date.Time `json:"lastUpdateTime,omitempty"`
	AvgCPUPercentage *float64   `json:"avgCPUPercentage,omitempty"`
	AvgMemoryGiB     *float64   `json:"avgMemoryGiB,omitempty"`
	PeakMemoryGiB    *float64   `json:"peakMemoryGiB,omitempty"`
	AvgDiskGiB       *float64   `json:"avgDiskGiB,omitempty"`
	PeakDiskGiB      *float64   `json:"peakDiskGiB,omitempty"`
	DiskReadIOps     *int64     `json:"diskReadIOps,omitempty"`
	DiskWriteIOps    *int64     `json:"diskWriteIOps,omitempty"`
	DiskReadGiB      *float64   `json:"diskReadGiB,omitempty"`
	DiskWriteGiB     *float64   `json:"diskWriteGiB,omitempty"`
	NetworkReadGiB   *float64   `json:"networkReadGiB,omitempty"`
	NetworkWriteGiB  *float64   `json:"networkWriteGiB,omitempty"`
}

// Schedule ...
type Schedule struct {
	// DoNotRunUntil - If you do not specify a doNotRunUntil time, the schedule becomes ready to create Jobs immediately.
	DoNotRunUntil *date.Time `json:"doNotRunUntil,omitempty"`
	// DoNotRunAfter - If you do not specify a doNotRunAfter time, and you are creating a recurring Job Schedule, the Job Schedule will remain active until you explicitly terminate it.
	DoNotRunAfter *date.Time `json:"doNotRunAfter,omitempty"`
	// StartWindow - If a Job is not created within the startWindow interval, then the 'opportunity' is lost; no Job will be created until the next recurrence of the schedule. If the schedule is recurring, and the startWindow is longer than the recurrence interval, then this is equivalent to an infinite startWindow, because the Job that is 'due' in one recurrenceInterval is not carried forward into the next recurrence interval. The default is infinite. The minimum value is 1 minute. If you specify a lower value, the Batch service rejects the schedule with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	StartWindow *string `json:"startWindow,omitempty"`
	// RecurrenceInterval - Because a Job Schedule can have at most one active Job under it at any given time, if it is time to create a new Job under a Job Schedule, but the previous Job is still running, the Batch service will not create the new Job until the previous Job finishes. If the previous Job does not finish within the startWindow period of the new recurrenceInterval, then no new Job will be scheduled for that interval. For recurring Jobs, you should normally specify a jobManagerTask in the jobSpecification. If you do not use jobManagerTask, you will need an external process to monitor when Jobs are created, add Tasks to the Jobs and terminate the Jobs ready for the next recurrence. The default is that the schedule does not recur: one Job is created, within the startWindow after the doNotRunUntil time, and the schedule is complete as soon as that Job finishes. The minimum value is 1 minute. If you specify a lower value, the Batch service rejects the schedule with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	RecurrenceInterval *string `json:"recurrenceInterval,omitempty"`
}

// StartTask batch will retry Tasks when a recovery operation is triggered on a Node. Examples of recovery
// operations include (but are not limited to) when an unhealthy Node is rebooted or a Compute Node disappeared
// due to host failure. Retries due to recovery operations are independent of and are not counted against the
// maxTaskRetryCount. Even if the maxTaskRetryCount is 0, an internal retry due to a recovery operation may
// occur. Because of this, all Tasks should be idempotent. This means Tasks need to tolerate being interrupted
// and restarted without causing any corruption or duplicate data. The best practice for long running Tasks is
// to use some form of checkpointing. In some cases the StartTask may be re-run even though the Compute Node
// was not rebooted. Special care should be taken to avoid StartTasks which create breakaway process or
// install/launch services from the StartTask working directory, as this will block Batch from being able to
// re-run the StartTask.
type StartTask struct {
	// CommandLine - The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. If the command line refers to file paths, it should use a relative path (relative to the Task working directory), or use the Batch provided environment variable (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
	CommandLine *string `json:"commandLine,omitempty"`
	// ContainerSettings - When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all Task environment variables are mapped into the container, and the Task command line is executed in the container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host disk, meaning that Batch file APIs will not be able to access those files.
	ContainerSettings *TaskContainerSettings `json:"containerSettings,omitempty"`
	// ResourceFiles - Files listed under this element are located in the Task's working directory.
	ResourceFiles       *[]ResourceFile       `json:"resourceFiles,omitempty"`
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	// UserIdentity - If omitted, the Task runs as a non-administrative user unique to the Task.
	UserIdentity *UserIdentity `json:"userIdentity,omitempty"`
	// MaxTaskRetryCount - The Batch service retries a Task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the Task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the Task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the Task. If the maximum retry count is -1, the Batch service retries the Task without limit.
	MaxTaskRetryCount *int32 `json:"maxTaskRetryCount,omitempty"`
	// WaitForSuccess - If true and the StartTask fails on a Node, the Batch service retries the StartTask up to its maximum retry count (maxTaskRetryCount). If the Task has still not completed successfully after all retries, then the Batch service marks the Node unusable, and will not schedule Tasks to it. This condition can be detected via the Compute Node state and failure info details. If false, the Batch service will not wait for the StartTask to complete. In this case, other Tasks can start executing on the Compute Node while the StartTask is still running; and even if the StartTask fails, new Tasks will continue to be scheduled on the Compute Node. The default is true.
	WaitForSuccess *bool `json:"waitForSuccess,omitempty"`
}

// StartTaskInformation ...
type StartTaskInformation struct {
	// State - Possible values include: 'StartTaskStateRunning', 'StartTaskStateCompleted'
	State StartTaskState `json:"state,omitempty"`
	// StartTime - This value is reset every time the Task is restarted or retried (that is, this is the most recent time at which the StartTask started running).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - This is the end time of the most recent run of the StartTask, if that run has completed (even if that run failed and a retry is pending). This element is not present if the StartTask is currently running.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExitCode - This property is set only if the StartTask is in the completed state. In general, the exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. However, if the Batch service terminates the StartTask (due to timeout, or user termination via the API) you may see an operating system-defined exit code.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// ContainerInfo - This property is set only if the Task runs in a container context.
	ContainerInfo *TaskContainerExecutionInformation `json:"containerInfo,omitempty"`
	// FailureInfo - This property is set only if the Task is in the completed state and encountered a failure.
	FailureInfo *TaskFailureInformation `json:"failureInfo,omitempty"`
	// RetryCount - Task application failures (non-zero exit code) are retried, pre-processing errors (the Task could not be run) and file upload errors are not retried. The Batch service will retry the Task up to the limit specified by the constraints.
	RetryCount *int32 `json:"retryCount,omitempty"`
	// LastRetryTime - This element is present only if the Task was retried (i.e. retryCount is nonzero). If present, this is typically the same as startTime, but may be different if the Task has been restarted for reasons other than retry; for example, if the Compute Node was rebooted during a retry, then the startTime is updated but the lastRetryTime is not.
	LastRetryTime *date.Time `json:"lastRetryTime,omitempty"`
	// Result - If the value is 'failed', then the details of the failure can be found in the failureInfo property. Possible values include: 'Success', 'Failure'
	Result TaskExecutionResult `json:"result,omitempty"`
}

// SubtaskInformation ...
type SubtaskInformation struct {
	ID        *int32                  `json:"id,omitempty"`
	NodeInfo  *ComputeNodeInformation `json:"nodeInfo,omitempty"`
	StartTime *date.Time              `json:"startTime,omitempty"`
	// EndTime - This property is set only if the subtask is in the Completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExitCode - This property is set only if the subtask is in the completed state. In general, the exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. However, if the Batch service terminates the subtask (due to timeout, or user termination via the API) you may see an operating system-defined exit code.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// ContainerInfo - This property is set only if the Task runs in a container context.
	ContainerInfo *TaskContainerExecutionInformation `json:"containerInfo,omitempty"`
	// FailureInfo - This property is set only if the Task is in the completed state and encountered a failure.
	FailureInfo *TaskFailureInformation `json:"failureInfo,omitempty"`
	// State - Possible values include: 'SubtaskStatePreparing', 'SubtaskStateRunning', 'SubtaskStateCompleted'
	State               SubtaskState `json:"state,omitempty"`
	StateTransitionTime *date.Time   `json:"stateTransitionTime,omitempty"`
	// PreviousState - This property is not set if the subtask is in its initial running state. Possible values include: 'SubtaskStatePreparing', 'SubtaskStateRunning', 'SubtaskStateCompleted'
	PreviousState SubtaskState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - This property is not set if the subtask is in its initial running state.
	PreviousStateTransitionTime *date.Time `json:"previousStateTransitionTime,omitempty"`
	// Result - If the value is 'failed', then the details of the failure can be found in the failureInfo property. Possible values include: 'Success', 'Failure'
	Result TaskExecutionResult `json:"result,omitempty"`
}

// TaskAddCollectionParameter ...
type TaskAddCollectionParameter struct {
	// Value - The total serialized size of this collection must be less than 1MB. If it is greater than 1MB (for example if each Task has 100's of resource files or environment variables), the request will fail with code 'RequestBodyTooLarge' and should be retried again with fewer Tasks.
	Value *[]TaskAddParameter `json:"value,omitempty"`
}

// TaskAddCollectionResult ...
type TaskAddCollectionResult struct {
	autorest.Response `json:"-"`
	Value             *[]TaskAddResult `json:"value,omitempty"`
}

// TaskAddParameter batch will retry Tasks when a recovery operation is triggered on a Node. Examples of
// recovery operations include (but are not limited to) when an unhealthy Node is rebooted or a Compute Node
// disappeared due to host failure. Retries due to recovery operations are independent of and are not counted
// against the maxTaskRetryCount. Even if the maxTaskRetryCount is 0, an internal retry due to a recovery
// operation may occur. Because of this, all Tasks should be idempotent. This means Tasks need to tolerate
// being interrupted and restarted without causing any corruption or duplicate data. The best practice for long
// running Tasks is to use some form of checkpointing.
type TaskAddParameter struct {
	// ID - The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not have two IDs within a Job that differ only by case).
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	// CommandLine - For multi-instance Tasks, the command line is executed as the primary Task, after the primary Task and all subtasks have finished executing the coordination command line. The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. If the command line refers to file paths, it should use a relative path (relative to the Task working directory), or use the Batch provided environment variable (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
	CommandLine *string `json:"commandLine,omitempty"`
	// ContainerSettings - If the Pool that will run this Task has containerConfiguration set, this must be set as well. If the Pool that will run this Task doesn't have containerConfiguration set, this must not be set. When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all Task environment variables are mapped into the container, and the Task command line is executed in the container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host disk, meaning that Batch file APIs will not be able to access those files.
	ContainerSettings *TaskContainerSettings `json:"containerSettings,omitempty"`
	// ExitConditions - How the Batch service should respond when the Task completes.
	ExitConditions *ExitConditions `json:"exitConditions,omitempty"`
	// ResourceFiles - For multi-instance Tasks, the resource files will only be downloaded to the Compute Node on which the primary Task is executed. There is a maximum size for the list of resource files.  When the max size is exceeded, the request will fail and the response error code will be RequestEntityTooLarge. If this occurs, the collection of ResourceFiles must be reduced in size. This can be achieved using .zip files, Application Packages, or Docker Containers.
	ResourceFiles *[]ResourceFile `json:"resourceFiles,omitempty"`
	// OutputFiles - For multi-instance Tasks, the files will only be uploaded from the Compute Node on which the primary Task is executed.
	OutputFiles         *[]OutputFile         `json:"outputFiles,omitempty"`
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	AffinityInfo        *AffinityInformation  `json:"affinityInfo,omitempty"`
	// Constraints - If you do not specify constraints, the maxTaskRetryCount is the maxTaskRetryCount specified for the Job, the maxWallClockTime is infinite, and the retentionTime is 7 days.
	Constraints *TaskConstraints `json:"constraints,omitempty"`
	// UserIdentity - If omitted, the Task runs as a non-administrative user unique to the Task.
	UserIdentity          *UserIdentity          `json:"userIdentity,omitempty"`
	MultiInstanceSettings *MultiInstanceSettings `json:"multiInstanceSettings,omitempty"`
	// DependsOn - This Task will not be scheduled until all Tasks that it depends on have completed successfully. If any of those Tasks fail and exhaust their retry counts, this Task will never be scheduled. If the Job does not have usesTaskDependencies set to true, and this element is present, the request fails with error code TaskDependenciesNotSpecifiedOnJob.
	DependsOn *TaskDependencies `json:"dependsOn,omitempty"`
	// ApplicationPackageReferences - Application packages are downloaded and deployed to a shared directory, not the Task working directory. Therefore, if a referenced package is already on the Node, and is up to date, then it is not re-downloaded; the existing copy on the Compute Node is used. If a referenced Package cannot be installed, for example because the package has been deleted or because download failed, the Task fails.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// AuthenticationTokenSettings - If this property is set, the Batch service provides the Task with an authentication token which can be used to authenticate Batch service operations without requiring an Account access key. The token is provided via the AZ_BATCH_AUTHENTICATION_TOKEN environment variable. The operations that the Task can carry out using the token depend on the settings. For example, a Task can request Job permissions in order to add other Tasks to the Job, or check the status of the Job or of other Tasks under the Job.
	AuthenticationTokenSettings *AuthenticationTokenSettings `json:"authenticationTokenSettings,omitempty"`
}

// TaskAddResult ...
type TaskAddResult struct {
	// Status - Possible values include: 'TaskAddStatusSuccess', 'TaskAddStatusClientError', 'TaskAddStatusServerError'
	Status TaskAddStatus `json:"status,omitempty"`
	TaskID *string       `json:"taskId,omitempty"`
	// ETag - You can use this to detect whether the Task has changed between requests. In particular, you can be pass the ETag with an Update Task request to specify that your changes should take effect only if nobody else has modified the Job in the meantime.
	ETag         *string    `json:"eTag,omitempty"`
	LastModified *date.Time `json:"lastModified,omitempty"`
	Location     *string    `json:"location,omitempty"`
	Error        *Error     `json:"error,omitempty"`
}

// TaskConstraints ...
type TaskConstraints struct {
	// MaxWallClockTime - If this is not specified, there is no time limit on how long the Task may run.
	MaxWallClockTime *string `json:"maxWallClockTime,omitempty"`
	// RetentionTime - The default is 7 days, i.e. the Task directory will be retained for 7 days unless the Compute Node is removed or the Job is deleted.
	RetentionTime *string `json:"retentionTime,omitempty"`
	// MaxTaskRetryCount - Note that this value specifically controls the number of retries for the Task executable due to a nonzero exit code. The Batch service will try the Task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the Task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the Task after the first attempt. If the maximum retry count is -1, the Batch service retries the Task without limit.
	MaxTaskRetryCount *int32 `json:"maxTaskRetryCount,omitempty"`
}

// TaskContainerExecutionInformation ...
type TaskContainerExecutionInformation struct {
	ContainerID *string `json:"containerId,omitempty"`
	// State - This is the state of the container according to the Docker service. It is equivalent to the status field returned by "docker inspect".
	State *string `json:"state,omitempty"`
	// Error - This is the detailed error string from the Docker service, if available. It is equivalent to the error field returned by "docker inspect".
	Error *string `json:"error,omitempty"`
}

// TaskContainerSettings ...
type TaskContainerSettings struct {
	// ContainerRunOptions - These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
	ContainerRunOptions *string `json:"containerRunOptions,omitempty"`
	// ImageName - This is the full Image reference, as would be specified to "docker pull". If no tag is provided as part of the Image name, the tag ":latest" is used as a default.
	ImageName *string `json:"imageName,omitempty"`
	// Registry - This setting can be omitted if was already provided at Pool creation.
	Registry *ContainerRegistry `json:"registry,omitempty"`
	// WorkingDirectory - The default is 'taskWorkingDirectory'. Possible values include: 'TaskWorkingDirectory', 'ContainerImageDefault'
	WorkingDirectory ContainerWorkingDirectory `json:"workingDirectory,omitempty"`
}

// TaskCounts ...
type TaskCounts struct {
	autorest.Response `json:"-"`
	Active            *int32 `json:"active,omitempty"`
	Running           *int32 `json:"running,omitempty"`
	Completed         *int32 `json:"completed,omitempty"`
	Succeeded         *int32 `json:"succeeded,omitempty"`
	Failed            *int32 `json:"failed,omitempty"`
}

// TaskDependencies ...
type TaskDependencies struct {
	// TaskIds - The taskIds collection is limited to 64000 characters total (i.e. the combined length of all Task IDs). If the taskIds collection exceeds the maximum length, the Add Task request fails with error code TaskDependencyListTooLong. In this case consider using Task ID ranges instead.
	TaskIds      *[]string      `json:"taskIds,omitempty"`
	TaskIDRanges *[]TaskIDRange `json:"taskIdRanges,omitempty"`
}

// TaskExecutionInformation ...
type TaskExecutionInformation struct {
	// StartTime - 'Running' corresponds to the running state, so if the Task specifies resource files or Packages, then the start time reflects the time at which the Task started downloading or deploying these. If the Task has been restarted or retried, this is the most recent time at which the Task started running. This property is present only for Tasks that are in the running or completed state.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - This property is set only if the Task is in the Completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExitCode - This property is set only if the Task is in the completed state. In general, the exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. However, if the Batch service terminates the Task (due to timeout, or user termination via the API) you may see an operating system-defined exit code.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// ContainerInfo - This property is set only if the Task runs in a container context.
	ContainerInfo *TaskContainerExecutionInformation `json:"containerInfo,omitempty"`
	// FailureInfo - This property is set only if the Task is in the completed state and encountered a failure.
	FailureInfo *TaskFailureInformation `json:"failureInfo,omitempty"`
	// RetryCount - Task application failures (non-zero exit code) are retried, pre-processing errors (the Task could not be run) and file upload errors are not retried. The Batch service will retry the Task up to the limit specified by the constraints.
	RetryCount *int32 `json:"retryCount,omitempty"`
	// LastRetryTime - This element is present only if the Task was retried (i.e. retryCount is nonzero). If present, this is typically the same as startTime, but may be different if the Task has been restarted for reasons other than retry; for example, if the Compute Node was rebooted during a retry, then the startTime is updated but the lastRetryTime is not.
	LastRetryTime *date.Time `json:"lastRetryTime,omitempty"`
	// RequeueCount - When the user removes Compute Nodes from a Pool (by resizing/shrinking the pool) or when the Job is being disabled, the user can specify that running Tasks on the Compute Nodes be requeued for execution. This count tracks how many times the Task has been requeued for these reasons.
	RequeueCount *int32 `json:"requeueCount,omitempty"`
	// LastRequeueTime - This property is set only if the requeueCount is nonzero.
	LastRequeueTime *date.Time `json:"lastRequeueTime,omitempty"`
	// Result - If the value is 'failed', then the details of the failure can be found in the failureInfo property. Possible values include: 'Success', 'Failure'
	Result TaskExecutionResult `json:"result,omitempty"`
}

// TaskFailureInformation ...
type TaskFailureInformation struct {
	// Category - Possible values include: 'UserError', 'ServerError'
	Category ErrorCategory    `json:"category,omitempty"`
	Code     *string          `json:"code,omitempty"`
	Message  *string          `json:"message,omitempty"`
	Details  *[]NameValuePair `json:"details,omitempty"`
}

// TaskIDRange the start and end of the range are inclusive. For example, if a range has start 9 and end 12,
// then it represents Tasks '9', '10', '11' and '12'.
type TaskIDRange struct {
	Start *int32 `json:"start,omitempty"`
	End   *int32 `json:"end,omitempty"`
}

// TaskInformation ...
type TaskInformation struct {
	TaskURL   *string `json:"taskUrl,omitempty"`
	JobID     *string `json:"jobId,omitempty"`
	TaskID    *string `json:"taskId,omitempty"`
	SubtaskID *int32  `json:"subtaskId,omitempty"`
	// TaskState - Possible values include: 'TaskStateActive', 'TaskStatePreparing', 'TaskStateRunning', 'TaskStateCompleted'
	TaskState     TaskState                 `json:"taskState,omitempty"`
	ExecutionInfo *TaskExecutionInformation `json:"executionInfo,omitempty"`
}

// TaskSchedulingPolicy ...
type TaskSchedulingPolicy struct {
	// NodeFillType - If not specified, the default is spread. Possible values include: 'Spread', 'Pack'
	NodeFillType ComputeNodeFillType `json:"nodeFillType,omitempty"`
}

// TaskStatistics ...
type TaskStatistics struct {
	URL            *string    `json:"url,omitempty"`
	StartTime      *date.Time `json:"startTime,omitempty"`
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
	UserCPUTime    *string    `json:"userCPUTime,omitempty"`
	KernelCPUTime  *string    `json:"kernelCPUTime,omitempty"`
	// WallClockTime - The wall clock time is the elapsed time from when the Task started running on a Compute Node to when it finished (or to the last time the statistics were updated, if the Task had not finished by then). If the Task was retried, this includes the wall clock time of all the Task retries.
	WallClockTime *string  `json:"wallClockTime,omitempty"`
	ReadIOps      *int64   `json:"readIOps,omitempty"`
	WriteIOps     *int64   `json:"writeIOps,omitempty"`
	ReadIOGiB     *float64 `json:"readIOGiB,omitempty"`
	WriteIOGiB    *float64 `json:"writeIOGiB,omitempty"`
	WaitTime      *string  `json:"waitTime,omitempty"`
}

// TaskUpdateParameter ...
type TaskUpdateParameter struct {
	// Constraints - If omitted, the Task is given the default constraints. For multi-instance Tasks, updating the retention time applies only to the primary Task and not subtasks.
	Constraints *TaskConstraints `json:"constraints,omitempty"`
}

// UploadBatchServiceLogsConfiguration ...
type UploadBatchServiceLogsConfiguration struct {
	// ContainerURL - The URL must include a Shared Access Signature (SAS) granting write permissions to the container. The SAS duration must allow enough time for the upload to finish. The start time for SAS is optional and recommended to not be specified.
	ContainerURL *string `json:"containerUrl,omitempty"`
	// StartTime - Any log file containing a log message in the time range will be uploaded. This means that the operation might retrieve more logs than have been requested since the entire log file is always uploaded, but the operation should not retrieve fewer logs than have been requested.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Any log file containing a log message in the time range will be uploaded. This means that the operation might retrieve more logs than have been requested since the entire log file is always uploaded, but the operation should not retrieve fewer logs than have been requested. If omitted, the default is to upload all logs available after the startTime.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// UploadBatchServiceLogsResult ...
type UploadBatchServiceLogsResult struct {
	autorest.Response `json:"-"`
	// VirtualDirectoryName - The virtual directory name is part of the blob name for each log file uploaded, and it is built based poolId, nodeId and a unique identifier.
	VirtualDirectoryName  *string `json:"virtualDirectoryName,omitempty"`
	NumberOfFilesUploaded *int32  `json:"numberOfFilesUploaded,omitempty"`
}

// UsageStatistics ...
type UsageStatistics struct {
	StartTime         *date.Time `json:"startTime,omitempty"`
	LastUpdateTime    *date.Time `json:"lastUpdateTime,omitempty"`
	DedicatedCoreTime *string    `json:"dedicatedCoreTime,omitempty"`
}

// UserAccount ...
type UserAccount struct {
	Name     *string `json:"name,omitempty"`
	Password *string `json:"password,omitempty"`
	// ElevationLevel - The default value is nonAdmin. Possible values include: 'NonAdmin', 'Admin'
	ElevationLevel ElevationLevel `json:"elevationLevel,omitempty"`
	// LinuxUserConfiguration - This property is ignored if specified on a Windows Pool. If not specified, the user is created with the default options.
	LinuxUserConfiguration *LinuxUserConfiguration `json:"linuxUserConfiguration,omitempty"`
	// WindowsUserConfiguration - This property can only be specified if the user is on a Windows Pool. If not specified and on a Windows Pool, the user is created with the default options.
	WindowsUserConfiguration *WindowsUserConfiguration `json:"windowsUserConfiguration,omitempty"`
}

// UserIdentity specify either the userName or autoUser property, but not both.
type UserIdentity struct {
	// UserName - The userName and autoUser properties are mutually exclusive; you must specify one but not both.
	UserName *string `json:"username,omitempty"`
	// AutoUser - The userName and autoUser properties are mutually exclusive; you must specify one but not both.
	AutoUser *AutoUserSpecification `json:"autoUser,omitempty"`
}

// VirtualMachineConfiguration ...
type VirtualMachineConfiguration struct {
	ImageReference *ImageReference `json:"imageReference,omitempty"`
	// NodeAgentSKUID - The Batch Compute Node agent is a program that runs on each Compute Node in the Pool, and provides the command-and-control interface between the Compute Node and the Batch service. There are different implementations of the Compute Node agent, known as SKUs, for different operating systems. You must specify a Compute Node agent SKU which matches the selected Image reference. To get the list of supported Compute Node agent SKUs along with their list of verified Image references, see the 'List supported Compute Node agent SKUs' operation.
	NodeAgentSKUID *string `json:"nodeAgentSKUId,omitempty"`
	// WindowsConfiguration - This property must not be specified if the imageReference property specifies a Linux OS Image.
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
	// DataDisks - This property must be specified if the Compute Nodes in the Pool need to have empty data disks attached to them. This cannot be updated. Each Compute Node gets its own disk (the disk is not a file share). Existing disks cannot be attached, each attached disk is empty. When the Compute Node is removed from the Pool, the disk and all data associated with it is also deleted. The disk is not formatted after being attached, it must be formatted before use - for more information see https://docs.microsoft.com/en-us/azure/virtual-machines/linux/classic/attach-disk#initialize-a-new-data-disk-in-linux and https://docs.microsoft.com/en-us/azure/virtual-machines/windows/attach-disk-ps#add-an-empty-data-disk-to-a-virtual-machine.
	DataDisks *[]DataDisk `json:"dataDisks,omitempty"`
	// LicenseType - This only applies to Images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the Compute Nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are:
	//  Windows_Server - The on-premises license is for Windows Server.
	//  Windows_Client - The on-premises license is for Windows Client.
	LicenseType *string `json:"licenseType,omitempty"`
	// ContainerConfiguration - If specified, setup is performed on each Compute Node in the Pool to allow Tasks to run in containers. All regular Tasks and Job manager Tasks run on this Pool must specify the containerSettings property, and all other Tasks may specify it.
	ContainerConfiguration *ContainerConfiguration `json:"containerConfiguration,omitempty"`
	// DiskEncryptionConfiguration - If specified, encryption is performed on each node in the pool during node provisioning.
	DiskEncryptionConfiguration *DiskEncryptionConfiguration `json:"diskEncryptionConfiguration,omitempty"`
}

// WindowsConfiguration ...
type WindowsConfiguration struct {
	// EnableAutomaticUpdates - If omitted, the default value is true.
	EnableAutomaticUpdates *bool `json:"enableAutomaticUpdates,omitempty"`
}

// WindowsUserConfiguration ...
type WindowsUserConfiguration struct {
	// LoginMode - The default value for VirtualMachineConfiguration Pools is 'batch' and for CloudServiceConfiguration Pools is 'interactive'. Possible values include: 'Batch', 'Interactive'
	LoginMode LoginMode `json:"loginMode,omitempty"`
}
