/*! \file xlhtml.h
    \brief Header file for xlhtml
*/

/*
   Copyright 2002  Charles N Wyble  <jackshck@thewybles.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published  by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#ifndef __XLHTML_H_INCLUDED
#define __XLHTML_H_INCLUDED



#if !(defined( __BORLANDC__ ) || defined( __WIN32__ ))
#include "config.h"		/* Created by ./configure script */
#include "support.h"		/* Needs to be before internal.h */
#include "internal.h"		/* Needs to be before cole */
#include "cole.h"
#else
#include "config.h.in"		/* Created by ./configure script */
#include "support.h"		/* Needs to be before internal.h */
#include "internal.h"		/* Needs to be before cole */
#include "cole.h.in"
#include <io.h>			/* for umask */
#include <dir.h>
#endif
#include <stdlib.h>		/* For atof(), calloc() */
#include <string.h>		/* For string functions */
#include <math.h>		/* For fabs() */
#include <ctype.h>		/* For isprint() */
#include <errno.h>

/* Used by packed string array Opcode: 0xFC */
#define HARD_MAX_ROWS_97	0x7FFE	/*!< Used in add_wb_array to prevent OOM */
#define HARD_MAX_ROWS_95	0x3FFF	/*!< Used in add_wb_array to prevent OOM */
#define HARD_MAX_COLS		256	/*!< Used in add_wb_array to prevent OOM */

/**********************************
*
*	Don't change anything below here...
*
************************************/
#define PRGNAME 		"xlhtml"
#define WBUFF_SIZE 		8240	/*!< The working buffer. SB 522+10+4(header) bytes minimum = 536 */
#define MAX_COLORS		65	/*!< This is the size of the built-in color table */
#define EXCEL95		0x500		/*!< This is the file stamp for biff7 - Excel 5 & 95 */
#define EXCEL97		0x600		/*!< This is the file stamp for biff8 - Excel 97 & 2000 */
#if !(defined( __WIN32__ ) || defined( __BORLANDC__ ))
#include <sys/stat.h>
#define GLOBAL_UMASK (S_IXUSR|S_IWGRP|S_IRGRP|S_IXGRP|S_IWOTH|S_IROTH|S_IXOTH)
#else
#define GLOBAL_UMASK (2)
#endif

/*! \brief This encapsulates the Unicode String	*/
typedef struct
{
	U8 uni;		/*!< Unicode String: 0==ASCII/8859-1, 1==windows-1252, 2==utf-8 */
	U8 *str;	/*!< Characters of string */
	U16 len;	/*!< Length of string */
	U8 *fmt_run;	/*!< formatting run, short pairs: offset, index to font */
	U8 crun_cnt;	/*!< The count of format runs */
} uni_string;

/*! \brief This is everything we need for a cell */
typedef struct
{
	U16 xfmt;		/*!< The high bit will tell us which version 0 =< 2; 1 == 2+ */
	U16 type;		/*!< This will record the record type that generated the cell */
	U16 spanned;		/*!< If 1 don't output */
	uni_string ustr;	/*!< The cell's displayed contents */
	U16 rowspan;		/*!< rows to span */
	U16 colspan;		/*!< columns to span */
	uni_string h_link;	/*!< If a hyperlinked cell, this is the link*/
} cell;

/*! \brief This encapsulates some information about each worksheet */
typedef struct
{
	U32 first_row;
	S32 biggest_row;
	U32 max_rows;
	U16 first_col;
	S16 biggest_col;
	U16 max_cols;
	uni_string ws_title;
	cell **c_array;
	U16 spanned;
} work_sheet;

/*! \brief This is everything we need to know about fonts */
typedef struct
{
	U16 size;
	U16 attr;
	U16 c_idx;
	U16 bold;
	U16 super;
	U8 underline;
	uni_string name;
} font_attr;

typedef struct
{
	uni_string *name;
	U16 cnt;
} fnt_cnt;

/*! \brief This covers the Extended Format records */
typedef struct
{
	U16 fnt_idx;
	U16 fmt_idx;
	U16 gen;
	U16 align;
	U16 indent;
	U16 b_style;
	U16 b_l_color;
	U32  b_t_color;
	U16 cell_color;
} xf_attr;

/*! \brief HTML Attribute */
typedef struct
{
	int fflag;		/*!< Font Flag */
	int bflag;		/*!< Bold Flag */
	int iflag;		/*!< Itallic Flag */
	int sflag;		/*!< Strike thru flag */
	int uflag;		/*!< Underline flag */
	int sbflag;		/*!< Subscript */
	int spflag;		/*!< Superscript */
} html_attr;


extern int first_sheet;
extern int last_sheet;
extern char filename[256];
extern char *default_text_color;
extern char *default_background_color;
extern char *default_image;
extern int aggressive;
extern int center_tables;
extern int NoHeaders;
extern int formula_warnings;
extern int Csv;
extern xf_attr **xf_array;
extern work_sheet **ws_array;
extern font_attr **font_array;
extern uni_string default_font;
extern unsigned int next_font;
extern unsigned int next_ws_title;
extern int default_fontsize;
extern char *default_alignment;
extern char *title;
extern uni_string author;
extern char *lastUpdated;
extern int file_version;
extern char colorTab[MAX_COLORS][8];
extern int NoFormat;
extern int notAccurate;
extern int NotImplemented;
extern int Unsupported;
extern int MaxPalExceeded;
extern int MaxXFExceeded;
extern int MaxFormatsExceeded;
extern int MaxColExceeded;
extern int MaxRowExceeded;
extern int MaxWorksheetsExceeded;
extern int MaxStringsExceeded;
extern int MaxFontsExceeded;
extern int UnicodeStrings;
extern int CodePage;


void OutputString (uni_string *);
void output_cell (cell *, int);
int IsCellNumeric (cell *);
int IsCellSafe (cell *);
int IsCellFormula (cell *);
void output_formatted_data (uni_string *, U16, int, int);
void SetupExtraction (void);
void trim_sheet_edges (unsigned int);
void update_default_font (unsigned int);
void update_default_alignment (unsigned int, int);



#endif
