#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* maximum length (\0 excluded) of a log line */
#define MAX_LINE_LEN        500
#define TAI_STR_LEN         24


int main(int argc, char *argv[]) {
    int line_num = 0;
    char line[MAX_LINE_LEN + 1];
    char taient[TAI_STR_LEN + 1];
    
    
    /* roughly checking the command line */
    if (argc != 2) {
        fprintf(stderr, "Usage: qfilt tai_base\n");
        exit(2);
    }

    /* now trusting the command line */
    while ( fgets(line, MAX_LINE_LEN+1, stdin) != NULL ) {
        line_num++;
        
        /* safety check: is this line valid? */
        if (line[0] != '@') {
            if ( strlen(line) == MAX_LINE_LEN ) {
                fprintf(stderr, "Line %d overwhelms buffer capacity (%d). Please  consider enlarging it.\n", line_num, MAX_LINE_LEN);
            } else {
                fprintf(stderr, "Error parsing line %d\n", line_num);
            }
            
            continue;
        }
        
        /* extrapolating tai timestamp information */
        memcpy(taient, & line[1], TAI_STR_LEN);
        taient[TAI_STR_LEN] = '\0';        
        
        if (strcmp(taient, argv[1]) > 0) {
            /* print the log line excluding timestamp to stdout */
            printf("%s", &line[TAI_STR_LEN + 2]);
        }
    }
    
    
    return 0;
}

