/*
 *  qmrtg-queue.c
 *  qmrtg
 *
 *  Created by Mij <mij@bitchx.it> on Wed Jan 21 2004.
 *  Please have a look at the LICENCE file for informations
 *  regarding how to use, modify or redistribute this code.
 *
 */

#define MAX(a,b)        (((a)>(b))?(a):(b))

#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#include <sys/stat.h>
#include <dirent.h>

#include "qmrtg-utils.h"


long count_files_in(char *queuedir);
void usage();

int main(int argc, char *argv[]) {
    long out1, out2;
    char tempstr[MAX_PATH_LENGTH];       /* a temporary buffer */
    char queuedir[MAX_PATH_LENGTH];      /* the path of the qmail queue (argv[1]) */
    
    
     /* some safety check */
    if ( argc != 2 ) {
        usage();
        return 1;
    }

    if (strlen(argv[1]) > MAX_PATH_LENGTH-1) {
        fprintf(stderr, "Maximum string size for the directory name exceeded.\nPlease recompile qmrtg-queue if you want it working with this huge path.\n");
        return 1;
    }    
    strncpy(queuedir, argv[1], MAX_PATH_LENGTH);
    
    
     /* now, at work */

     /* for $QUEUE/mess : already preprocessed msgs */
    snprintf(tempstr, MAX_PATH_LENGTH-strlen(queuedir)-5, "%s/mess", queuedir);
    if ((out1 = count_files_in(tempstr)) < 0) {
        perror("Error opening QUEUE/mess");
        return 1;
    }


     /* for $QUEUE/todo : still to be preprocessed msgs */
    snprintf(tempstr, MAX_PATH_LENGTH-strlen(queuedir)-5, "%s/todo", queuedir);
    if ((out2 = count_files_in(tempstr)) < 0) {
        perror("Error opening QUEUE/todo");
        return 1;
    }
    printf("%lu\n%lu\n", out1, out2);
    
    
    return 0;
}


 /* recursively counts the number of files under directory "queuedir" */
long count_files_in(char *queuedir) {
    DIR *dir;
    struct dirent *de;
    char newdir[MAX_PATH_LENGTH];
    long err;
    long count_sub = 0;          /* local files */
    long count_loc = 0;          /* files in subdirectories */


    if ( (dir = opendir(queuedir)) == NULL ) return -1;

     /* queue tree traversal (depth-first) */
    while ( (de = readdir(dir)) != NULL ) {
        if ( de->d_name[0] == '.' )
            /* skipping entry */
            continue;
        
        if ( de->d_type == DT_DIR ) {
            snprintf(newdir, MAX_PATH_LENGTH-strlen(queuedir), "%s/%s", queuedir, de->d_name);
            if ( (err = count_files_in(newdir)) < 0) {
                closedir(dir);
                return -1;
            } else
                count_sub += err;
        } else {
            count_loc++;
        }
    }

    closedir(dir);
    
    
    return (count_sub + count_loc);
}


void usage() {
    fprintf(stderr, "qmrtg-queue: feeds mrtg with informations about the queue of a qmail mailserver.\n");
    fprintf(stderr, "Usage:\n\tqmrtg-queue <qmail_queue_dir>\n");
    fprintf(stderr, "where qmail_queue_dir is the absolute path of the qmail queue directory.\n");
}

